/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aycr
 */

package
{
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ShaderFilter;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;

    public class WonderTriangleWithMouse extends Sprite
    {
        public var loaderImage : Loader = new Loader;
        public var loaderShader : URLLoader = new URLLoader;
        public var bmp : Bitmap;
        public var shader : Shader = new Shader;
        public var seed : int = Math.floor(Math.random()*0xFFFF)
        public var offset : Array = [new Point, new Point];
        public var bmpdPerlin : BitmapData;
        private var sliderRange:HSlider;
        private var sliderRadius:HSlider;
        private var sliderOffset:HSlider;
    
        
        public function WonderTriangleWithMouse(){
            graphics.beginFill(0x333333, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            loaderImage.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
            loaderImage.load(new URLRequest("http://www.bongiovi.tw/wonderfl/rock.jpg"), new LoaderContext(true));
        }
        
        
        private function imgLoaded(e:Event) : void {
            bmp = Bitmap(loaderImage.content);
            addChild(bmp).y = ( 465 - bmp.height ) * .5;
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/TriangulationMouse.pbj"));
        }
        
        
        private function shaderLoaded(e:Event) : void {
            shader.byteCode = ByteArray(loaderShader.data);
            bmpdPerlin = new BitmapData(bmp.width, bmp.height);
            
            
            var container:Sprite = Sprite(addChild(new Sprite));
            sliderRange = new HSlider(container, 5, 10);
            sliderRange.value = 50;
            sliderRadius = new HSlider(container, 5, 30);
            sliderRadius.value = 35;
            sliderOffset = new HSlider(container, 5, 50);
            sliderOffset.value = 100;
            
            var lblRange:Label = new Label(this, 110, 5, "Cell Size");
            var lblRadius:Label = new Label(this, 110, 25, "Radius");
            var lblOffset:Label = new Label(this, 110, 45, "Offset");
            
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        
        public function render(e:Event) : void {
            shader.data.range.value = [sliderRange.value];
            shader.data.radius.value = [sliderRadius.value*2];
            shader.data.offset.value = [sliderOffset.value/100];
            
            const SPEED : int = 5;
            shader.data.mouse.value = [stage.mouseX , stage.mouseY - sliderRadius.value*2];
            bmpdPerlin.perlinNoise(bmp.width, bmp.height, 3, seed, false, true, 1, false, offset);
            shader.data.srcPerlin.input = bmpdPerlin;
            offset[0].x += SPEED;
            offset[1].y += SPEED;

            
            bmp.filters = [new ShaderFilter(shader)];
        }
    }
}



/*

<languageVersion : 1.0;>

kernel TriangleCells
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "TriangleCells";
>
{
    input image4 src;      
     input image4 srcPerlin;
    output pixel4 dst;
    
    
    parameter float range
    <
        minValue:1.0;
        maxValue:100.0;
        defaultValue:50.0;
    >;                                  

    
    parameter float2 mouse
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(2000.0, 2000.0);
        defaultValue:float2(300.0, 200.0);
    >;                   
    
    
    parameter float radius
    <
        minValue:0.0;
        maxValue:1000.0;
        defaultValue:100.0;
    >;          
    
    
    
    parameter float offset
    <
        minValue:0.0;
        maxValue:1.0;
        defaultValue:1.0;
    >;
    
    #define MAX_LENGTH length(float3(1.0, 1.0, 1.0));
    
    
    void
    evaluatePixel()
    {    
        float2 pos = outCoord();            
        float2 posPixelate = floor(pos/range) * range;
        float2 newPos = pos - posPixelate;
        float2 endPos = float2(posPixelate.x, posPixelate.y);
        float percent = newPos.y / range;
                                            
        float isDown = mod(floor(pos.y/range), 2.0);
        if(isDown < 1.0) percent = 1.0 - percent;
        
        if(newPos.x < range * (0.5 - percent/2.0) ) {
            endPos.x = endPos.x;     
            if(isDown < 1.0) endPos.y += range * .66;
            else endPos.y += range * .33; 
        } else if(newPos.x > range * (0.5 + percent/2.0) ) {
            endPos.x += range;                               
            if(isDown < 1.0) endPos.y += range * .66;
            else endPos.y += range * .33;      
        } else {
            endPos.x += range * .5;
            if(isDown < 1.0) endPos.y += range * .33;
            else endPos.y += range * .66;
        }
                
        pixel4 colorPixel = sampleNearest(src, endPos); 
        pixel4 colorOrg = sampleNearest(src, pos);             
        pixel4 perlin = sampleNearest(srcPerlin, endPos);         
        float mouseOffset = clamp(distance(pos, mouse) / radius * perlin.r, 0.0, 1.0) * offset;
        dst = colorOrg * mouseOffset + colorPixel * (1.0 - mouseOffset); 
    }
}


*/