/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ayWj
 */

// forked from enecre's ぽにょってするCircle
//http://www.gamedesign.jp/flash/yomi/yomi.html
//の左上でぽにょってしてるやつを作りたかったけど何か違う・・・。

//数字を入れてカウントダウンにする(*´ω｀*)
package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.*;
    import flash.text.*;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.utils.Timer;
    import com.bit101.components.PushButton;
    [SWF(width = 465, height = 465, frameRate = 60, backgroundColor = 0xaaffaa)]
    public class CountDown extends Sprite {
    	
    		private static const TIME_UP:String = "timeUp";
    		//可変パラメータ
    		private const radius:int = 50;
    		private const color:int = 0xaaaaff;
    		private const fontColor:int = 0x4444ff;
    		private const timeLimit:int = 5;
    		//不可変パラメータ？
    		private const numSize:int = 10;
    		private const center:int = radius * (1.0 + numSize * 0.01);
    		private const format:TextFormat = new TextFormat("Meiryo",radius * 1.5,fontColor);

    		
    		private var _circles:Vector.<Shape>;
    		private var _numbers:Vector.<Bitmap>;
    		private var _timer:Timer;
    		private var animationStep:int;
    	
        public function CountDown(){
			_circles = new Vector.<Shape>(numSize);//0-9
			var tmp:int;
			for(var i:int = 0; i < numSize; i++){
				tmp = radius * (1.00 + 0.01*i)
				_circles[i] = Circle(tmp,color);
				if(i != 0)_circles[i].visible = false;
			}
            animationStep = 0;
            
            var tf:TextField = new TextField();
            tf.defaultTextFormat = format;
            tf.autoSize = TextFieldAutoSize.LEFT;
            _numbers = new Vector.<Bitmap>();
            for(var j:int = 0; j <= timeLimit ; j++){
            		tf.text = String(j);
            		var bmpdata:BitmapData = new BitmapData(tf.width,tf.textHeight,true,0);
            		bmpdata.draw(tf);
            		_numbers[j] = new Bitmap(bmpdata);
            		_numbers[j].x = center - _numbers[j].width/2;
            		_numbers[j].y = center - _numbers[j].height/2;
            		addChild(_numbers[j]);
            		_numbers[j].visible = false;
            }
            _numbers[timeLimit].visible = true;
            
            _timer = new Timer(1000,5);
            _timer.addEventListener(TimerEvent.TIMER,onTimer);
            _timer.addEventListener(TimerEvent.TIMER_COMPLETE,onTimerComplete);

            var startButton:PushButton = new PushButton(this,0,stage.height,"Start",start);
            var resetButton:PushButton = new PushButton(this,startButton.width,startButton.y,"Reset",reset);
            var stopButton:PushButton = new PushButton(this,startButton.width+resetButton.width,startButton.y,"Stop",stop);
        }
        private function onTimer(e:TimerEvent):void{
            		if(!_timer.hasEventListener(Event.ENTER_FRAME)){
            			addEventListener(Event.ENTER_FRAME,onEnterFrame);
            			var timeLeft:int = timeLimit - _timer.currentCount;
            			_numbers[timeLeft + 1].visible = false;
            			_numbers[timeLeft].visible = true;
            		}
        }
        
        private function onTimerComplete(e:TimerEvent):void{
        		dispatchEvent(new Event("timeUp"));
        }
        
        public function start(e:Event=null):void{
        		if(_timer.currentCount != timeLimit)_timer.start();
        }
        
        public function reset(e:Event=null):void{
        		_timer.reset();
        		for(var i:int = 0; i< timeLimit; i++){
        			_numbers[i].visible = false;
        		}
        		_numbers[timeLimit].visible = true;
        }
        
        public function stop(e:Event=null):void{
        		_timer.stop();
        }
        
        private function onEnterFrame(e:Event):void{
        		if(animationStep != numSize){
        			if(animationStep == 0){
        				_circles[0].visible = false;
        				_circles[numSize - 1].visible = true;
        			}
        			else{
        				_circles[numSize - animationStep].visible = false;
        				_circles[numSize - animationStep - 1].visible = true;
        			}
        			animationStep++;
        		}
        		else{
        			removeEventListener(Event.ENTER_FRAME,onEnterFrame);
        			animationStep = 0;
        		}
        }
        
        private function Circle(rad:int,color:int):Shape{
        		var sp:Shape = new Shape();
        		sp.graphics.beginFill(color);
        		sp.graphics.drawCircle(center,center,rad);
        		sp.graphics.endFill();
        		addChild(sp);
        		return sp;	
        }
    }
}