/**
 * Copyright pseudoDust ( http://wonderfl.net/user/pseudoDust )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ay7b
 */

package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Stage;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.display.Sprite;
    public class Tree extends Sprite {
        private var bm:Bitmap;
        private var bmd:BitmapData;
        
        private var rootBranch:Branch;
        
        public static var db:TextField;
        public function Tree() {
            db = new TextField();
            db.defaultTextFormat = new TextFormat(null, 14,0xffffff);
            Wonderfl.capture_delay( 100 );
            bmd = new BitmapData(stage.stageWidth,stage.stageWidth,false,0);
            rootBranch = new Branch(stage.stageWidth*0.5,stage.stageHeight,-Math.PI/2,35,2,1);
            bm = new Bitmap(bmd);
            addChild(bm);
            addChild(db);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        

        private function onEnterFrame(e:Event = null) : void {    
            rootBranch.grow(bmd,1000);
            bm.bitmapData = bmd;
        }
    }
    
    

    
}
import flash.display.Sprite;
import flash.display.BitmapData;

class Branch extends Object {
    
    private static const ENERGY_FACTOR:Number = 0.05;
    
    private var children:Array;
    
    private var startX:Number;
    private var startY:Number;
    private var endX:Number;
    private var endY:Number;
    private var dir:Number;
    private var length:Number;
    private var depth:Number;
    private var isBranch:Boolean;
    private var curve:Number;
    
    private var energy:Number = 0;

    public function Branch(x:Number, y:Number, dir:Number, length:Number, curve:Number, depth:Number) {
        startX = x;
        startY = y;
        endX = x+Math.cos(dir)*length;
        endY = y+Math.sin(dir)*length;
        this.length = length;
        this.dir = dir;
        children = new Array();
        this.depth = depth;
        this.curve = curve;
        isBranch = (depth-Math.floor(depth))<(2.6/(depth*4.5+4))
    }    

    public function grow(bmd:BitmapData, energy:Number) : void {
        this.energy+=energy*ENERGY_FACTOR;
        var sp:Sprite = new Sprite();
        if(Math.random()<Math.pow(this.energy*0.001,2)) {
            sp.graphics.lineStyle(1,0xff0000+0x000101*Math.min(255,Math.floor(0xff-depth*18-rand()*5)),0.02);
            var w : Number = 40*Math.pow(this.energy*0.000005,0.8);
            sp.graphics.moveTo(startX+w*randn(),startY+w*randn());
            sp.graphics.lineTo(endX+w*randn(),endY+w*randn());
            bmd.draw(sp);
        }
        for(var i:int = 0 ; i<children.length ; i++) {
            Branch(children[i]).grow(bmd, (energy*(0.8-ENERGY_FACTOR)));
        }
        if(children.length==0 && length>0.5) {
            if(this.energy>30){
                children.push(new Branch(endX,
                                         endY,
                                         dir+curve/length,
                                         length*(.9+Math.random()*0.15),
                                         curve+rand()*0.3,
                                         depth+Math.random()));
            }
        }

        if(isBranch && children.length==1 && length>1) {
            if(this.energy>50){
                children.push(new Branch(endX,
                                         endY,
                                         dir+sgn(rand())*(0.3+0.4*Math.random()),
                                         length*(.85+Math.random()*0.15),
                                         sgn(rand())*curve+rand()*0.6,
                                         depth+Math.random()));
            }
        }

    }
    
    private function sgn(x:Number) : Number {
        return x==0?x:x/Math.abs(x);
    }
    
    
    private function randn() : Number {
        return rand()*rand()*rand();
    }
    
    private function rand() : Number {
        return 2*Math.random()-1;
    }
    
    

}
    
    
    
    
    
    
    