/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/axQR
 */

// forked from clockmaker's [最適化 Tips] SpriteとMovieClipってそんなに変わるの？
// forked from muta244's [最適化 Tips] 変数名の長さによる処理速度の違い
package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.system.*;

public class Main extends Sprite
{
    static private const _W:uint = 2000;
    static private const _H:uint = 2000;
    
    private var wrap:Sprite;
    
    // 参考
    // http://www.be-interactive.org/?itemid=273
    private function _init():void
    {
        while(wrap.numChildren) wrap.removeChildAt(0);
        
        _debug(
            "各テスト " + _W + "x"+ _H + "px 処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var old:int = System.totalMemory;
        _measure("lock/unclockを未使用", function ():void
        {
            var bmpdata :BitmapData = new BitmapData(_W, _H);
            addChild(new Bitmap(bmpdata));
            for (var x:uint = 0; x < _W; ++x){
                for (var y:uint = 0; y < _H; ++y) {
                    bmpdata.setPixel(x, y, 0xFFFFFF);
                }
            }
            bmpdata.dispose();
        });
        
        var old1:int = System.totalMemory;
        _measure("lock/unclockを使用", function ():void
        {
            var bmpdata :BitmapData = new BitmapData(_W, _H);
            addChild(new Bitmap(bmpdata));
            bmpdata.lock();
            for (var x:uint = 0; x < _W; ++x){
                for (var y:uint = 0; y < _H; ++y) {
                    bmpdata.setPixel(x, y, 0xFFFFFF);
                }
            }
            bmpdata.unlock();
            bmpdata.dispose();

        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        wrap = new Sprite
        addChild(wrap)
        
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
