/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/awo1
 */

package {
	import flash.display.*;
	import flash.events.Event;
	import flash.geom.*;
	public class Main extends Sprite {
		
		private var SW:Number = stage.stageWidth;
		private var SH:Number = stage.stageHeight;
		private var borns:Array = new Array();
		
		public function Main():void {
			var bornsNum:uint = 3;
			var vArray:Array = ["x","y","z"];
			
			// Borns Setting
			var core:Born = new Born(10,30);
			core.x = SW/2 + 50;
			core.y = SH/2 + 5;
			core.z = 0;
			addChild(core);
			xRotate([core],"z",-90);
			
			var body:Born = new Born(60,30);
			body.x = SW/2 + 50;
			body.y = SH/2;
			body.z = 0;
			addChild(body);
			xRotate([body],"z",-90);
			
			var head:Born = new Born(40,40);
			head.x = SW/2 + 50;
			head.y = SH/2 - 60;
			head.z = 0;
			addChild(head);
			xRotate([head],"z",-90);
			
			var shoulderL:Born = new Born(30,15);
			shoulderL.x = SW/2 - 20 + 50;
			shoulderL.y = SH/2 - 55;
			shoulderL.z = 0;
			addChild(shoulderL);
			xRotate([shoulderL],"z",90);
			
			var armL:Born = new Born(30,15);
			armL.x = SW/2 - 20 + 50;
			armL.y = SH/2 - 25;
			armL.z = 0;
			addChild(armL);
			xRotate([armL],"z",90);
			
			var shoulderR:Born = new Born(30,15);
			shoulderR.x = SW/2 + 20 + 50;
			shoulderR.y = SH/2 - 55;
			shoulderR.z = 0;
			addChild(shoulderR);
			xRotate([shoulderR],"z",90);
			
			var armR:Born = new Born(30,15);
			armR.x = SW/2 + 20 + 50;
			armR.y = SH/2 - 25;
			armR.z = 0;
			addChild(armR);
			xRotate([armR],"z",90);
			
			var legL:Born = new Born(40,20);
			legL.x = SW/2 - 10 + 50;
			legL.y = SH/2;
			legL.z = 0;
			addChild(legL);
			xRotate([legL],"z",90);
			
			var kneeL:Born = new Born(40,20);
			kneeL.x = SW/2 - 10 + 50;
			kneeL.y = SH/2 + 40;
			kneeL.z = 0;
			addChild(kneeL);
			xRotate([kneeL],"z",90);
			
			var legR:Born = new Born(40,20);
			legR.x = SW/2 + 10 + 50;
			legR.y = SH/2;
			legR.z = 0;
			addChild(legR);
			xRotate([legR],"z",90);
			
			var kneeR:Born = new Born(40,20);
			kneeR.x = SW/2 + 10 + 50;
			kneeR.y = SH/2 + 40;
			kneeR.z = 0;
			addChild(kneeR);
			xRotate([kneeR],"z",90);
			
			// Controller Setting
			var sbCoreX:SlidBar = new SlidBar([core,body,head,shoulderL,armL,shoulderR,armR,legL,kneeL,legR,kneeR], 'x', 'Core');
			addChild(sbCoreX);
			sbCoreX.x = 280;
			sbCoreX.y = 30;
			sbCoreX.addEventListener(Event.CHANGE, xLoop);
			sbCoreX.blendMode = BlendMode.DARKEN;
			sbCoreX.rotation = -90;
			
			var sbCoreY:SlidBar = new SlidBar([core,body,head,shoulderL,armL,shoulderR,armR,legL,kneeL,legR,kneeR], 'y', 'Core');
			addChild(sbCoreY);
			sbCoreY.x = 280;
			sbCoreY.y = 60;
			sbCoreY.addEventListener(Event.CHANGE, xLoop);
			sbCoreY.blendMode = BlendMode.DARKEN;
			sbCoreY.rotation = -90;
			
			var sbCoreZ:SlidBar = new SlidBar([core,body,head,shoulderL,armL,shoulderR,armR,legL,kneeL,legR,kneeR], 'z', 'Core');
			addChild(sbCoreZ);
			sbCoreZ.x = 280;
			sbCoreZ.y = 90;
			sbCoreZ.addEventListener(Event.CHANGE, xLoop);
			sbCoreZ.blendMode = BlendMode.DARKEN;
			sbCoreZ.rotation = -90;
			
			var sbBodyX:SlidBar = new SlidBar([body,head,shoulderL,armL,shoulderR,armR], 'x', 'Body');
			addChild(sbBodyX);
			sbBodyX.x = 20;
			sbBodyX.y = 70;
			sbBodyX.addEventListener(Event.CHANGE, xLoop);
			sbBodyX.blendMode = BlendMode.DARKEN;
			
			var sbBodyY:SlidBar = new SlidBar([body,head,shoulderL,armL,shoulderR,armR], 'y', 'Body');
			addChild(sbBodyY);
			sbBodyY.x = 50;
			sbBodyY.y = 70;
			sbBodyY.addEventListener(Event.CHANGE, xLoop);
			sbBodyY.blendMode = BlendMode.DARKEN;
			
			var sbBodyZ:SlidBar = new SlidBar([body,head,shoulderL,armL,shoulderR,armR], 'z', 'Body');
			addChild(sbBodyZ);
			sbBodyZ.x = 80;
			sbBodyZ.y = 70;
			sbBodyZ.addEventListener(Event.CHANGE, xLoop);
			sbBodyZ.blendMode = BlendMode.DARKEN;
			
			var sbHeadX:SlidBar = new SlidBar([head], 'x', 'Head');
			addChild(sbHeadX);
			sbHeadX.x = 120;
			sbHeadX.y = 70;
			sbHeadX.addEventListener(Event.CHANGE, xLoop);
			sbHeadX.blendMode = BlendMode.DARKEN;
			
			var sbHeadY:SlidBar = new SlidBar([head], 'y', 'Head');
			addChild(sbHeadY);
			sbHeadY.x = 150;
			sbHeadY.y = 70;
			sbHeadY.addEventListener(Event.CHANGE, xLoop);
			sbHeadY.blendMode = BlendMode.DARKEN;
			
			var sbHeadZ:SlidBar = new SlidBar([head], 'z', 'Head');
			addChild(sbHeadZ);
			sbHeadZ.x = 180;
			sbHeadZ.y = 70;
			sbHeadZ.addEventListener(Event.CHANGE, xLoop);
			sbHeadZ.blendMode = BlendMode.DARKEN;
			
			var sbShoulderLX:SlidBar = new SlidBar([shoulderL,armL], 'x', "ShoulderL");
			addChild(sbShoulderLX);
			sbShoulderLX.x = 20;
			sbShoulderLX.y = 200;
			sbShoulderLX.addEventListener(Event.CHANGE, xLoop);
			sbShoulderLX.blendMode = BlendMode.DARKEN;
			
			var sbShoulderLZ:SlidBar = new SlidBar([shoulderL,armL], 'z', "ShoulderL");
			addChild(sbShoulderLZ);
			sbShoulderLZ.x = 50;
			sbShoulderLZ.y = 200;
			sbShoulderLZ.addEventListener(Event.CHANGE, xLoop);
			sbShoulderLZ.blendMode = BlendMode.DARKEN;
			
			var sbArmLX:SlidBar = new SlidBar([armL], 'x', "ArmL");
			addChild(sbArmLX);
			sbArmLX.x = 80;
			sbArmLX.y = 200;
			sbArmLX.addEventListener(Event.CHANGE, xLoop);
			sbArmLX.blendMode = BlendMode.DARKEN;
			
			var sbShoulderRX:SlidBar = new SlidBar([shoulderR,armR], 'x', "ShoulderR");
			addChild(sbShoulderRX);
			sbShoulderRX.x = 120;
			sbShoulderRX.y = 200;
			sbShoulderRX.addEventListener(Event.CHANGE, xLoop);
			sbShoulderRX.blendMode = BlendMode.DARKEN;
			
			var sbShoulderRZ:SlidBar = new SlidBar([shoulderR,armR], 'z', "ShoulderR");
			addChild(sbShoulderRZ);
			sbShoulderRZ.x = 150;
			sbShoulderRZ.y = 200;
			sbShoulderRZ.addEventListener(Event.CHANGE, xLoop);
			sbShoulderRZ.blendMode = BlendMode.DARKEN;
			
			var sbArmRX:SlidBar = new SlidBar([armR], 'x', "ArmR");
			addChild(sbArmRX);
			sbArmRX.x = 180;
			sbArmRX.y = 200;
			sbArmRX.addEventListener(Event.CHANGE, xLoop);
			sbArmRX.blendMode = BlendMode.DARKEN;
			
			var sbLegLX:SlidBar = new SlidBar([legL,kneeL], 'x', "LegL");
			addChild(sbLegLX);
			sbLegLX.x = 20;
			sbLegLX.y = 330;
			sbLegLX.addEventListener(Event.CHANGE, xLoop);
			sbLegLX.blendMode = BlendMode.DARKEN;
			
			var sbLegLZ:SlidBar = new SlidBar([legL,kneeL], 'z', "LegL");
			addChild(sbLegLZ);
			sbLegLZ.x = 50;
			sbLegLZ.y = 330;
			sbLegLZ.addEventListener(Event.CHANGE, xLoop);
			sbLegLZ.blendMode = BlendMode.DARKEN;
			
			var sbKneeLX:SlidBar = new SlidBar([kneeL], 'x', "KneeL");
			addChild(sbKneeLX);
			sbKneeLX.x = 80;
			sbKneeLX.y = 330;
			sbKneeLX.addEventListener(Event.CHANGE, xLoop);
			sbKneeLX.blendMode = BlendMode.DARKEN;
			
			var sbLegRX:SlidBar = new SlidBar([legR,kneeR], 'x', "LegR");
			addChild(sbLegRX);
			sbLegRX.x = 120;
			sbLegRX.y = 330;
			sbLegRX.addEventListener(Event.CHANGE, xLoop);
			sbLegRX.blendMode = BlendMode.DARKEN;
			
			var sbLegRZ:SlidBar = new SlidBar([legR,kneeR], 'z', "LegR");
			addChild(sbLegRZ);
			sbLegRZ.x = 150;
			sbLegRZ.y = 330;
			sbLegRZ.addEventListener(Event.CHANGE, xLoop);
			sbLegRZ.blendMode = BlendMode.DARKEN;
			
			var sbKneeRX:SlidBar = new SlidBar([kneeR], 'x', "KneeR");
			addChild(sbKneeRX);
			sbKneeRX.x = 180;
			sbKneeRX.y = 330;
			sbKneeRX.addEventListener(Event.CHANGE, xLoop);
			sbKneeRX.blendMode = BlendMode.DARKEN;
		}
		
		public function xLoop(e:Event):void {
			
			var targets:Array = e.target.myTargets;
			var myAxis:String = e.target.myAxis;
			var val:Number    = e.target.param / 5;
			
			xRotate(targets, myAxis, val);
		}
		
		public function xRotate(targets:Array, axis:String, val:Number):void {
			
			var myAxis:Vector3D;
			var born:Born = targets[0];
			var tv:Vector3D = new Vector3D(born.x, born.y, born.z);
			
			if (axis == "x") {
				myAxis = born.axisX;
			} else if (axis == "y") {
				myAxis = born.axisY;
			} else if (axis == "z") {
				myAxis = born.axisZ;
			}
			
			for (var i:uint = 0; i < targets.length; i++) {
				born = targets[i];
				born.transform.matrix3D.appendTranslation(-tv.x, -tv.y, -tv.z);
				born.transform.matrix3D.appendRotation(val, myAxis);
				born.transform.matrix3D.appendTranslation( tv.x,  tv.y,  tv.z);
				// 骨が持つ回転軸も回転させる
				var m3D:Matrix3D = new Matrix3D();
				m3D.appendRotation(val, myAxis);
				if (i > 0) {	// 基の回転軸は固定
					born.axisX = m3D.transformVector(born.axisX);
					born.axisX.normalize();
					born.axisY = m3D.transformVector(born.axisY);
					born.axisY.normalize();
					born.axisZ = m3D.transformVector(born.axisZ);
					born.axisZ.normalize();
				}
			}
		}
	}
}


import flash.display.*;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.geom.*;
import flash.text.*;

class SlidBar extends Sprite {
	public var grab:Sprite;
	public var param:Number;
	public var myTargets:Array;
	public var myAxis:String;
	public function SlidBar(targets:Array, axis:String, name:String=""):void {
		myTargets = targets;
		myAxis = axis;
		
		graphics.lineStyle(2,0x666666);
		graphics.beginFill(0x999999);
		graphics.drawRoundRect(-10,-60,20,120,20);
		
		var tfmt:TextFormat = new TextFormat("Arial Black",12,0xcccccc);
		var tfld:TextField = new TextField();
		tfld.defaultTextFormat = tfmt;
		tfld.text = name + ' ' + axis;
		var bmd:BitmapData = new BitmapData(80, 20,true,0x00000000);
		bmd.draw(tfld);
		var bmp:Bitmap = new Bitmap(bmd);
		addChild(bmp);
		bmp.rotation = 90;
		bmp.x += 10;
		bmp.y -= 50;
		
		grab = new Sprite();
		grab.graphics.lineStyle(2,0x666666);
		grab.graphics.beginFill(0xcccccc);
		grab.graphics.drawCircle(0,0,8);
		grab.buttonMode = true;
		param = grab.y;
		addChild(grab);
		
		grab.addEventListener(MouseEvent.MOUSE_DOWN, mDown);
		grab.addEventListener(MouseEvent.MOUSE_UP,   mUp);
	}
	private function mDown(e:MouseEvent):void {
		grab.startDrag(true, new Rectangle(0,-50,0,100));
		stage.addEventListener(Event.ENTER_FRAME, xLoop);
		stage.addEventListener(MouseEvent.MOUSE_UP, this.mUp);
	}
	public function mUp(e:MouseEvent):void {
		grab.stopDrag();
		stage.removeEventListener(Event.ENTER_FRAME, xLoop);
		grab.y = 0;
	}
	private function xLoop(e:Event):void {
		if (0 != grab.y) {
			param = grab.y;
			dispatchEvent(new Event(Event.CHANGE));
		}
	}
}

class Born extends Sprite {
	public var axisX:Vector3D;
	public var axisY:Vector3D;
	public var axisZ:Vector3D;
	public function Born(len:Number=50,w:Number=20):void {
		graphics.beginFill(0x000055,0.5);
		graphics.drawRoundRect(0,-w/2,len,w,w);
		axisX = Vector3D.X_AXIS;
		axisY = Vector3D.Y_AXIS;
		axisZ = Vector3D.Z_AXIS;
	}
}