/**
 * Copyright teleranek ( http://wonderfl.net/user/teleranek )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/awYY
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.text.*;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shaders.ShadedMaterial;
    import org.papervision3d.materials.shaders.FlatShader;
    import org.papervision3d.materials.shaders.GouraudShader;
    import org.papervision3d.materials.utils.MaterialsList;

    
    public class FRT extends Sprite {
        private var lion0:Lion;
        private var lion1:Lion;
        private var v:BasicView;
        private var cube0:Cube;
        private var container:Sprite;
        private var rot:Number;
        public var light:PointLight3D;
////////
        public function FRT() {
            addChild( v = new BasicView( stage.stageWidth , stage.stageHeight , false )) ;
            v.camera.zoom = 8;
            v.camera.focus = 100;
            v.camera.target = null;
            
            addEventListener( Event.ENTER_FRAME , render );
            
            container = new Sprite();
            
            addChild( lion0 = new Lion() );
            addChild( lion1 = new Lion() );
            lion0.x = stage.stageWidth/2 - lion0.width;
            lion1.x = stage.stageWidth/2 + lion0.width;
            lion0.y = lion1.y = 100;
            
            // FRT
            var frtTxt:TextField = new TextField();
            var tf:TextFormat = new TextFormat();
            tf.size = 50;
            tf.font = "Arial";
            frtTxt.defaultTextFormat = tf;
            frtTxt.text = "FRT";
            frtTxt.textColor = 0xaaaaaa;
            frtTxt.x = stage.stageWidth/2 - frtTxt.textWidth/2;
            frtTxt.y = stage.stageHeight/2 - frtTxt.textHeight/2;
            container.addChild( frtTxt );
            
            //container.graphics.beginFill(0);
            //container.graphics.drawRect(0,0,container.width,container.height);
            //container.graphics.endFill();
            
            // procudere
            var proc:TextField = new TextField();
            proc.autoSize = TextFieldAutoSize.LEFT;
            tf = new TextFormat();
            tf.size = 20;
            proc.textColor = 0xdddddd;
            tf.font = "Verdana";
            proc.defaultTextFormat = tf;
            
            proc.text = "visiones in res procudere";
            proc.x = stage.stageWidth/2 - proc.textWidth/2;
            proc.y = stage.stageHeight/2 + frtTxt.textHeight/2;
            container.addChild( proc );
            
            container.graphics.lineStyle(1);
            container.graphics.drawRect(proc.x,proc.y,proc.textWidth,proc.textHeight);
            
            light = new PointLight3D( );
            light.z = -1000;
            light.y = 0;
            light.x = 0;
            
            var mat0:MovieMaterial = new MovieMaterial( container,false,false,true );
            //var mat1:MovieMaterial = new MovieMaterial( lion0,true,true );
            //var mat2:MovieMaterial = new MovieMaterial( lion1,true,true );
            
            rot = 1;
            var mats0:MaterialsList = new MaterialsList({
                back:new ShadedMaterial( mat0 , new GouraudShader( light ) ),
                front:new ShadedMaterial( mat0 , new GouraudShader( light ) ),
                left:new ColorMaterial(0x333333),
                right:new ColorMaterial(0x333333),
                top:new ColorMaterial(0x222222),
                bottom:new ColorMaterial(0x222222)
                });
            
            v.scene.addChild( cube0 = new Cube( mats0 , 300 , 15, 100 , 10 , 10,10 ) );
            cube0.rotationX = 30;
        }
        
        public function render(evt:Event ):void{
            v.singleRender();
            var sp:Number;
            sp = ((stage.stageWidth/2 - mouseX) - cube0.rotationY)*.1;
            cube0.rotationY += sp;
            light.x += (cube0.rotationY*10 - light.x )*.05;
            
            v.filters = [ new BlurFilter( sp/2 , 0 ) ];
        }
    }
    
}
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.*;
class Lion extends Sprite{
       public var rotDir:Number;
       public function Lion(){
            graphics.beginFill( 0xcccc00 );
            graphics.moveTo( -50,0 );
            graphics.lineTo( 50,0 );
            graphics.lineTo( 0,100 );
            graphics.endFill();  
            
            //eyez
            graphics.beginFill(0);
            graphics.drawCircle( -30,35 , 5 );
            graphics.endFill();
            graphics.beginFill(0);
            graphics.drawCircle( 30,35 , 5 );
            graphics.endFill();
            
            var i:int;
            var j:int;
            for( i = 0; i < 100; i++ ){
                for( j = 0; j < 10; j++ ){
                graphics.beginFill(0);
                graphics.drawCircle(i-50,10-20*Math.sin((i/100)*Math.PI)+Math.random()*30,Math.random()*2);
                graphics.endFill();}
            }
            rotDir = (Math.random()<0.5)?-2.0:2.0;
            addEventListener( Event.ENTER_FRAME , ef );
            addEventListener( MouseEvent.MOUSE_OVER , movr );
            addEventListener( MouseEvent.MOUSE_OUT , mout );
            addEventListener( MouseEvent.CLICK , click );
            //filters = [ new BlurFilter( 2 , 0 ) ];
       }
       
       public function movr( evt:MouseEvent ):void{
            Lion(evt.currentTarget).alpha = 0.5;
        }
        public function mout( evt:MouseEvent ):void{
            Lion(evt.currentTarget).alpha = 1.0;
        }
        public function click(evt:MouseEvent):void{
            Lion(evt.currentTarget).rotDir = -Lion(evt.currentTarget).rotDir;
        }
       
       private function ef(evt:Event):void{
            if( Math.abs(rotation )> 45 ) rotDir = -rotDir;
            rotation += rotDir;
       }
}