/**
 * Copyright yooyke ( http://wonderfl.net/user/yooyke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/awRE
 */

package {
    import flash.geom.Vector3D;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private const OBJECT_NUM:int = 32;
        private const OBJECT_RADIUS:int = 2;
        private const OBJECT_SPEED:Number = 8;
        private const MOVING_DIST_SQU:Number = OBJECT_SPEED * OBJECT_SPEED;
        
        
        private var list_:Array;
        private var head_:Sprite;
        private var headPoint_:Point = new Point();
        
        
        public function FlashTest() {
            // write as3 code here..
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event=null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.frameRate = 60;
            
            graphics.beginFill(0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            initObjects();
            next();
            
            //stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function initObjects():void {
            list_ = new Array();
            
            var i:int;
            var object:Sprite;
            for (i = 0; i < OBJECT_NUM; i++) {
                object = createObject(OBJECT_RADIUS, 0xff0000, 0.5);
                list_.push(object);
                addChildAt(object, 0);
                
                if (i == 0) {
                    head_ = object;
                }
            }
        }
        
        private function createObject(radius:Number, color:uint, alpha:Number):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color, alpha);
            sp.graphics.drawCircle(0,0,radius);
            sp.graphics.endFill();
            return sp;
        }
        
        private function next():void {
            var x:Number = Math.random() * stage.stageWidth;
            var y:Number = Math.random() * stage.stageHeight;
            headPoint_ = new Point(x, y)
        }

        
        private function onEnterFrame(e:Event):void {
            var vec:Vector3D = new Vector3D(headPoint_.x - head_.x, headPoint_.y - head_.y);
            
            if (vec.lengthSquared > MOVING_DIST_SQU) {
                vec.normalize();
                vec.scaleBy(OBJECT_SPEED);
                head_.x += vec.x;
                head_.y += vec.y;
            }
            else {
                next();
            }
            
            
            var i:int;
            var object1:Sprite;
            var object2:Sprite;
            for (i = (OBJECT_NUM - 1); i > 0 ; i--) {
                object1 = list_[i];
                object2 = list_[i - 1];
                
                object1.x = object2.x;
                object1.y = object2.y;
            }
        }
        
        /*
        private function onMouseMove(e:MouseEvent):void {
            headPoint_ = new Point(e.stageX, e.stageY);
        }
        */
    }
}