/**
 * Copyright hourglasseye ( http://wonderfl.net/user/hourglasseye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aw1e
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FleeingCircles extends Sprite
    {
        public function FleeingCircles()
        {
        		var circles:Array = [];
        		for( var row:int = 0; row < 22; row++ )
        		{
	        		for( var col:int = 0; col < 22; col++ )
	        		{
	        			var circle:FleeingCircle = new FleeingCircle( 10 + 21 * col, 10 + 21 * row, 9, 50 );
	        			addChild( circle );
	        			circles.push( circle );
        			}
        		}
        		
        		var lastIteration:Number = new Date().getTime();
        		addEventListener( Event.ENTER_FRAME, function( e:Event ) : void {
        			var thisIteration:Number = new Date().getTime();
        			var deltaTime:Number = ( thisIteration - lastIteration ) * 0.001;
        			lastIteration = thisIteration;
        			var max:int = circles.length;
        			for( var i:int = 0; i < max; i++ )
        			{
        				var circle:FleeingCircle = circles[i];
        				circle.update( deltaTime );
        			}
        		} );
        }
    }
}

import flash.display.Sprite;
import flash.geom.Point;

class FleeingCircle extends Sprite
{
	private var home:Point;
	private var mouse:Point;
	private var location:Point;
	private var direction:Point;
	private var speed:Number;
	
	public function FleeingCircle( x:Number, y:Number, radius:Number, speed:Number )
	{
		graphics.beginFill( 0 );
		graphics.drawCircle( 0, 0, radius );
		this.x = x;
		this.y = y;
		home = new Point( this.x, this.y );
		mouse = new Point();
		location = new Point();
		direction = new Point();
		this.speed = speed;
	}
	
	public function update( deltaTime:Number ) : void
	{
		mouse.x = stage.mouseX;
		mouse.y = stage.mouseY;
		location.x = x;
		location.y = y;
		var displacement:Number;
		if( Point.distance( mouse, location ) < 50 )
		{
			displacement = speed * deltaTime;
			direction.x = location.x - mouse.x;
			direction.y = location.y - mouse.y;
			direction.normalize( 1 );
			x += direction.x * displacement;
			y += direction.y * displacement;
		}
		else if( Point.distance( home, location ) > 0.5 )
		{
			displacement = speed * deltaTime * 0.5;
			direction.x = home.x - location.x;
			direction.y = home.y - location.y;
			direction.normalize( 1 );
			x += direction.x * displacement;
			y += direction.y * displacement;
		}
	}
}