/**
 * Copyright forunot ( http://wonderfl.net/user/forunot )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/avuE
 */

// forked from nobeshima's forked from: 色相環カラーピッカー(HSV色空間)
// forked from zahir's 色相環カラーピッカー(HSV色空間)
package{
    /*
     * zahirです
     * HSV色空間式カラーピッカー(のつもり)
     * なんとなく作ったのでかなり適当です
     * だれかいい感じにつくり直してください　(^^;
    */
    import flash.display.*;
    [SWF(width = 1000, height = 750, backgroundColor = 0xFFFFFF)]
    public class CircleColorPiker extends Sprite{
        private var picker:Base;
        private var g:Graphics;
        private var w:int, h:int;
        public function CircleColorPiker(){
            g = this.graphics;
            picker = new Base( 500, 500, draw);
            picker.x = (this.stage.stageWidth - picker.width) >> 1;
            picker.y = (this.stage.stageHeight - picker.height - 15) >> 1;
            this.addChild( picker );
            w = this.stage.stageWidth;
            h = this.stage.stageHeight;
            Wonderfl.capture_delay(2);
        }
        public function draw( color:uint ):void{
            g.clear();
            g.beginFill( color );
            g.drawRect(0, 0 , w, h );
            g.endFill();
        }
    }
}

import flash.display.Shader;
import mx.utils.Base64Decoder;
import flash.display.Shape;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.geom.Matrix;
class Base extends Sprite{
    private const PI:Number = 0.01745;
    
    private var g:Graphics;
    private var h_s:HueSlider;
    private var svs:SVSlider;
    private var cx:Number, cy:Number;
    private var h_r:int;
    private var bg:Shape;
    private var bg_l:Number;
    private var svX1:int, svX2:int, svY1:int, svY2:int;
    
    private var H:Number = 0, S:Number = 0, V:Number = 1;
    
    private var parentDraw:Function;
    
    public function Base( w:int, h:int , pDraw:Function){
        parentDraw = pDraw;
        g= this.graphics;
        g.lineStyle( 2, 0x333333);
        g.beginFill( 0x111111 );
        g.drawRoundRectComplex(0, 0, w, h, 5, 5, 5, 5);
        g.endFill();
        
        cx = w>>1, cy = h>>1;
        
        var circle:Circle = new Circle( (w  - 40) >>1 );
        circle.x = cx;
        circle.y = cy;
        this.addChild( circle );
        
        bg = new Shape();
        g = bg.graphics;
        bg_l = w*0.4;
        g.beginFill( 0xFF0000 );
        g.drawRect( 0,0, bg_l ,bg_l );
        g.endFill()
        this.addChild( bg );
        bg.x = cx - (bg.width >>1 );
        bg.y = cy - (bg.height >>1);
        
        var gr:GradientRect = new GradientRect( bg_l ,  bg_l  );
        this.addChild( gr );
        gr.x = cx - (gr.width >>1 );
        gr.y = cy - (gr.height >>1);
        
        svX1 = gr.x; svX2 = svX1 + bg_l;
        svY1 = gr.y; svY2 = svY1 + bg_l;
        
        svs = new SVSlider();
        svs.x = gr.x;
        svs.y = gr.y;
        this.addChild( svs );
        svs.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
            svs.stage.addEventListener(MouseEvent.MOUSE_MOVE, svMove);
            svs.stage.addEventListener(MouseEvent.MOUSE_UP, svUp);
        });
        
        h_s = new HueSlider();
        this.addChild( h_s );
        h_r = (w-60) >> 1;
        h_s.x = Math.cos( PI * -90 ) * h_r + cx;
        h_s.y = Math.sin( PI * -90) * h_r + cy;
        
        h_s.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
            h_s.stage.addEventListener(MouseEvent.MOUSE_MOVE, moveH);
            h_s.stage.addEventListener(MouseEvent.MOUSE_UP, upH);
        });
    }
    private function svMove(e:MouseEvent):void{
        e.updateAfterEvent();
        var _x:int = mouseX, _y:int = mouseY;
        if(_x < svX1) svs.x = svX1;
        else if(_x > svX2) svs.x = svX2;
        else svs.x = _x;
        if(_y < svY1) svs.y = svY1;
        else if(_y > svY2) svs.y = svY2;
        else svs.y = _y;
        
        S = 1 - (svX2 - svs.x) / bg_l;
        V = (svY2 - svs.y) / bg_l;
        
        parentDraw( hsv2RGB() );
    }
    private function svUp(e:MouseEvent):void{
        svs.stage.removeEventListener(MouseEvent.MOUSE_MOVE, svMove);
        svs.stage.removeEventListener(MouseEvent.MOUSE_UP, svUp);
    }
    private function draw( color:uint ):void{
        g.clear();
        g.beginFill( color );
        g.drawRect( 0,0, bg_l ,bg_l );
        g.endFill();
    }
    private function moveH(e:MouseEvent):void{
        e.updateAfterEvent();
        var rot:Number = -Math.atan2( mouseX - cx,  mouseY - cy) / PI + 90;
        h_s.x = Math.cos( PI *rot ) * h_r + cx;
        h_s.y =Math.sin( PI *rot ) * h_r + cy;
        
        draw( Hue2RGB( rot + 90 ) );
        parentDraw( hsv2RGB() );
    }
    private function upH(e:MouseEvent):void{
        h_s.stage.removeEventListener(MouseEvent.MOUSE_MOVE, moveH);
        h_s.stage.removeEventListener(MouseEvent.MOUSE_UP, upH);
    }
    private function hsv2RGB():uint{
        if(H<0) H+= 360;
        H %= 360;
        var h:Number = H / 60;
        var _h:Number = Math.floor( h );
        var v:Number = Math.max(0, Math.min( 0xFF, V * 0xFF) );
        var mr:uint = v <<16;
        var mg:uint = v <<8;
        var h_:Number = Math.round( v * ( 1 - ( 1- h+_h ) * S) );
        h = Math.round( v * (1- S * h + S* _h) );
        var n:Number = Math.round( v * (1-S) );
        var c:uint;
        switch(_h){
            case 0:
                c = mr| ( h_ << 8) | n;
                break;
            case 1:
                c = (h << 16) | mg | n;
                break;
            case 2:
                c = (n<<16) | mg | h_;
                break;
            case 3:
                c =  (n<<16) | (h<<8) | v;
                break;
            case 4:
                c = (h_<<16) | (n<<8) | v; 
                break;
            case 5:
                c = mr | (n<<8) | h;
                break;
        }
        return c;
    }
    private function Hue2RGB( Hue:int ):uint{
        var h:Number = H = (Hue % 360 < 0) ? Hue + 360 : Hue;
        h /= 60;
        var _h:Number = Math.floor( h );
        var m:int = 255;
        var red:uint = m<<16;
        var green:uint = m<<8;
        var h_:Number = Math.round( m * (1 - h + _h) );
        h = Math.round( m * ( 1 - (1 - h + _h) ) );
        var c:uint;
        switch(_h){
            case 0:
                c = red | ( h << 8) | 0;
                break;
            case 1:
                c = (h_ << 16) | green | 0;
                break;
            case 2:
                c = 0 | green | h;
                break;
            case 3:
                c =  0 | (h_<<8) | m;
                break;
            case 4:
                c = (h<<16) | 0 | m; 
                break;
            case 5:
                c = red | 0 | h_;
                break;
        }
        return c;
    }
}
class GradientRect extends Shape{
    public function GradientRect(w:int, h:int){
        var m:Matrix = new Matrix();
        var g:Graphics = this.graphics;
        m.createGradientBox( w, h );
        g.lineStyle( 1 );
        g.beginGradientFill("linear", [0xFFFFFF, 0xFFFFFF], [1,0], [0,255],m);
        g.drawRect(0,0, w, h );
        g.endFill();
        m.createGradientBox( w, h, 90 * 0.01745 );
        g.beginGradientFill("linear", [0x0, 0x0], [0,1], [0,255],m);
        g.drawRect(0,0, w, h );
        g.endFill();
    }
}
class HueSlider extends Sprite{
    private var g:Graphics;
    public const RAD:int = 7;
    public function HueSlider(){
        g = this.graphics;
        g.lineStyle(2);
        g.beginFill( 0xFFFFFF , 0.6 );
        g.drawCircle( 0, 0, RAD);
        g.endFill();
    }
}
class SVSlider extends Sprite{
    public function SVSlider(){
        var g:Graphics = this.graphics;
        g.lineStyle(2);
        g.beginFill( 0xFFFFFF, 0.6);
        g.drawCircle( 0, 0 , 4);
        g.endFill();
    }
}
class Circle extends Shape{
    private var g:Graphics;
    public function Circle( rad:int){
        g = this.graphics;
        var s:HueGradient = new HueGradient();
        s.center = [ 0,0];
        s.rotate = [-90];
        g.lineStyle( 1, 0x0 );
        g.beginShaderFill( s );
        g.drawCircle( 0, 0, rad);
        g.drawCircle( 0, 0, rad - 20);
        g.endFill();
    }
}
class HueGradient extends Shader{
    // 色相環なグラデーションを塗るShader
    public function HueGradient(){
        var dec:Base64Decoder = new Base64Decoder();
        dec.decode( "pQEAAACkCwBIdWVHcmFkaWVudKAMbmFtZXNwYWNlAHphaGlyMTkyOQCgDHZlbmRvcgB6YWhpcgCgCHZlcnNpb24AAQCgDGRlc2NyaXB0aW9uAAChAQIAAAxfT3V0Q29vcmQAoQIEAQAPZHN0AKEBAQAAAnJvdGF0ZQCiAW1heFZhbHVlAEO0AACiAW1pblZhbHVlAMO0AACiAWRlZmF1bHRWYWx1ZQAAAAAAoQECAgAMY2VudGVyAKICbWF4VmFsdWUARXoAAEV6AACiAm1pblZhbHVlAAAAAAAAAAAAogJkZWZhdWx0VmFsdWUAQwAAAEMAAAAdAgAxAAAQAB0DAMECABAAAgMAwQIAsAAdAwAxAwAQADIAABA8jvNNHQMAgAMAwAAGAwCAAwCAAAQDAEAAAMAAAwMAQAMAAAAdAwCAAwBAAAEDAIAAAIAAMgMAQEO0AAAdBACAAwAAAAgEAIADAEAAHQMAgAQAAAAyAwBAAAAAACoDAIADAEAAHQGAgACAAAA0AAAAAYAAADIDAEBDtAAAAQMAgAMAQAA2AAAAAAAAADIDAEBCcAAABAQAgAMAQAADBACAAwAAAB0DAEAEAAAAGgQAgAMAQAAdBABABAAAADIEAIAAAAAAMgQAIAAAAAAyBAAQAAAAADIFAIBDfwAAMgUAQD+AAAAyBQAgAAAAACgEAEAFAIAAHQGAgACAAAA0AAAAAYAAAB0EAIAFAAAAHQUAIAUAQAACBQAgAwBAAB0FABAFAIAAAQUAEAQAQAAdBQAgBQBAAAIFACAFAMAAHQUAEAUAAAADBQAQBQCAABsFACAFAMAAHQQAIAUAgAAyBAAQAAAAADUAAAAAAAAAMgUAID+AAAAoBABABQCAAB0BgEAAgAAANAAAAAGAQAAdBQAgBQBAAAIFACADAEAAHQUAEAUAgAABBQAQBABAAB0FACAFAAAAAwUAIAUAwAAbBQAQBQCAAB0EAIAFAMAAHQQAIAUAAAAyBAAQAAAAADUAAAAAAAAAMgUAIEAAAAAoBABABQCAAB0BgCAAgAAANAAAAAGAgAAyBACAAAAAAB0EACAFAAAAHQUAIAUAQAACBQAgAwBAAB0FABAFAIAAAQUAEAQAQAAdBQAgBQBAAAIFACAFAMAAHQUAEAUAAAADBQAQBQCAABsFACAFAMAAHQQAEAUAgAA1AAAAAAAAADIFACBAQAAAKAQAQAUAgAAdAYAQAIAAADQAAAABgMAAMgQAgAAAAAAdBQAgBQBAAAIFACADAEAAHQUAEAUAgAABBQAQBABAAB0FACAFAAAAAwUAIAUAwAAbBQAQBQCAAB0EACAFAMAAHQQAEAUAAAA1AAAAAAAAADIFACBAgAAAKAQAQAUAgAAdAoCAAIAAADQAAAACgAAAHQUAIAUAQAACBQAgAwBAAB0FABAFAIAAAQUAEAQAQAAdBQAgBQBAAAIFACAFAMAAHQUAEAUAAAADBQAQBQCAABsFACAFAMAAHQQAgAUAgAAyBAAgAAAAAB0EABAFAAAANQAAAAAAAAAyBQAgQKAAACgEAEAFAIAAHQKAQACAAAA0AAAAAoBAAB0EAIAFAAAAMgQAIAAAAAAdBQAgBQBAAAIFACADAEAAHQUAEAUAgAABBQAQBABAAB0FACAFAAAAAwUAIAUAwAAbBQAQBQCAAB0EABAFAMAANgAAAAAAAAA2AAAAAAAAADYAAAAAAAAANgAAAAAAAAA2AAAAAAAAADYAAAAAAAAABAUAIAUAAAADBACABQCAAAQFACAFAAAAAwQAIAUAgAAEBQAgBQAAAAMEABAFAIAAHQYAgAQAAAAdBgBABACAAB0GACAEAMAAMgUAID+AAAAdBgAQBQCAAB0BAPMGABsA" );
        this.byteCode = dec.toByteArray();
        dec = null;
    }
    public function get center():Array{
        return this.data.center.value;
    }
    public function set center( value:Array ):void{
        this.data.center.value = value;
    }
    public function get rotate():Array{
        return this.data.rotate.value;
    }
    public function set rotate( value:Array ):void{
        this.data.rotate.value = value;
    }
}