/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/avVW
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", frameRate="60")]
    
    public class FlashTest extends Sprite {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        private var canvas:BitmapData;
        private var sprite:Sprite;
        
        private var particleList:/*Particle*/Array;
        
        public function FlashTest() {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);           
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild(new Bitmap(canvas));
            
            sprite = new Sprite();
            
            IniteParticle();
            
            addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, IniteParticle);
        }
        
        private function EnterFrameHandler(e:Event):void
        {
            sprite.graphics.clear();
            var angle:Number = (stage.mouseX - (WIDTH / 2)) / 20;
            var speed:Number = (stage.mouseY - (HEIGHT / 2)) / 40;
            
            var linesize:Number = Math.abs(stage.mouseY - (HEIGHT / 2)) / 50;
            sprite.graphics.lineStyle(1 + linesize, 0xffffff);
            
            for(var i:int = 0; i < particleList.length; i++)
            {
                particleList[i].angle += angle;
                var rad:Number = particleList[i].angle * Math.PI / 180;
                particleList[i].prevx = particleList[i].x;
                particleList[i].prevy = particleList[i].y;
                particleList[i].x += Math.cos(rad) * speed;
                particleList[i].y += Math.sin(rad) * speed;
                
                sprite.graphics.moveTo(particleList[i].prevx, particleList[i].prevy);
                sprite.graphics.lineTo(particleList[i].x, particleList[i].y);
            }
            canvas.draw(sprite);
        }
        
        private function IniteParticle(e:MouseEvent = null):void
        {
            canvas.lock();
            canvas.fillRect(canvas.rect, 0);
            canvas.unlock();
            
            particleList = [];
            
            particleList.push(new Particle(WIDTH/2, HEIGHT/2, 90));
            particleList.push(new Particle(WIDTH/2, HEIGHT/2, 180));
            particleList.push(new Particle(WIDTH/2, HEIGHT/2, 270));
            particleList.push(new Particle(WIDTH/2, HEIGHT/2, 0));
        }
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var prevx:Number;
    public var prevy:Number;
    public var angle:Number;
    
    public function Particle(x:Number, y:Number, angle:Number)
    {
        this.x = x;
        this.y = y;
        this.angle = angle;
    }

}
