/**
 * Copyright hashito ( http://wonderfl.net/user/hashito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/auv8
 */

// forked from hashito's 文字集まる修正
// MainStage
package {
    import flash.display.Sprite;
    [SWF(frameRate=60,width=456,height=456)]
    public class MainStage extends Sprite {
        public function MainStage(){
            addChild(new Main());
        }
    }
}

import flash.display.*;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.events.*;
import flash.utils.Timer;
import flash.text.TextField;
import flash.text.TextFormat;
import net.hires.debug.Stats;
// debug
class debug{public static var out:TextField=new TextField();}

/*t.hashito*/
class MF{
    public static function AFFORD (x:Number,aim:Number,a:Number):Boolean{return (x<=(a+aim))&&(x>=(a-aim));}
    public static function RAN (n:Number=1):Number{return (Math.random()*n);}
    public static function ISPM (n:Number):Number{if(n<0){return -1;}else if(n>0){return 1;}return 0;}
    public static function MAX (n:Number,max:Number):Number{return (n>max)?max:n;}
    public static function MIN (n:Number,min:Number):Number{return (n<min)?min:n;}
    public static function LIMIT (n:Number,max:Number,min:Number):Number{if(n>max){return max;}else if(n<min){return min;}else{return n};}
    public static function RAD_ANG(n:Number):Number{return n*180/Math.PI}
    public static function ANG_RAD(n:Number):Number{return n*Math.PI/180 }
    public static function LATCH(v:Boolean,s:Boolean,r:Boolean):Boolean{if(s)v=true;if(r)v=false;return v;}
    public static function ONE_SHOT_ON(v:Boolean,o:Boolean):Boolean{var r:Boolean = (v==(!o));o=v;return r;}
    public static function DOT2(x1:Number,y1:Number,x2:Number,y2:Number):Number{return x1 * x2 + y1 * y2; }//内積
    public static function SLOPE(x1:Number,y1:Number,x2:Number,y2:Number):Number{return (y1-y2)/(x1-x2) }//傾き(無限の可能性あり)
    public static function DISTANCE(x1:Number,y1:Number,x2:Number,y2:Number):Number{var a:Number=(x2-x1);var b:Number=(y2-y1);return Math.sqrt(a*a+b*b);}//距離
}

class Main extends Sprite{
    public const H:Number = 456
    public const W:Number = 456;
    public const BAL_W_MAX :Number = 15;
    public const BAL_H_MAX :Number = H/(BAL_W*2)-5;
    public const BAL_W     :Number = (W/BAL_W_MAX)/2;
    public const BAL_IX:Number = W/2;
    public const BAL_IY:Number = H - BAL_W;
    public const BAL_OFFSET:Number = Math.sqrt((BAL_W*BAL_W)/2);
    
    public var BAL_COLOR_S :Array  = [0x00ff00,0xccff00,0xcc00cc,0x5500ff,0x555500];
    
    public var kal:Boolean = false;
    public var kar:Boolean = false;
    public var ksp:Boolean = false;
    
    public var gun:Shape   = new Shape();
    public var ball:Shape  = new Shape(),bax:Number=0,bay:Number=0,ac:Boolean=false;
    
    public var balls:Array = new Array();
    public var ballsLayer:Sprite = new Sprite();
    
    public var tx:TextField=new TextField();
    
    // constructor
    public function Main() {addEventListener(Event.ADDED_TO_STAGE, init);}
    
    public function msg(s:String):void{
        tx.text = s;
        tx.x = W/2-tx.textWidth/2;
        tx.y = H/2-tx.textHeight/2;
    }
    // init
    public function init(e:*):void{
        // debug
        // debug.out.autoSize=flash.text.TextFieldAutoSize.LEFT;
        // addChild(debug.out);
        
        // gun init
        const GUN_W:int=10,GUN_H:int=50;
        gun.graphics.beginFill(0xff0000);
        gun.graphics.drawRect(-(GUN_W/2),0,GUN_W,-GUN_H);
        gun.x = W/2;
        gun.y = H;
        addChild(gun);
        
        // ball init
        ball.graphics.beginFill(uint(BAL_COLOR_S[int(MF.RAN(BAL_COLOR_S.length))]));
        ball.graphics.drawCircle(0,0,BAL_W);
        ball.x = BAL_IX;
        ball.y = BAL_IY;
        addChild(ball);
        
        // balls init
        var b:Shape,maxh:int,offset:Number;
        for(var yi:int=0; yi< BAL_H_MAX ;yi++){
            // 行のボール数を決定
            if((yi%2) == 0){
                maxh   = BAL_W_MAX;
                offset = BAL_W;
            }else{
                maxh   = BAL_W_MAX-1;
                offset = BAL_W + BAL_OFFSET;
            }
            
            for(var xi:int=0; xi < maxh ;xi++){
                b = new Shape();
                b.graphics.beginFill(uint(BAL_COLOR_S[int(MF.RAN(BAL_COLOR_S.length))]));
                b.graphics.drawCircle(0,0,BAL_W);
                b.x = xi * BAL_W*2 + offset;
                b.y = yi * BAL_W*2 ;
                ballsLayer.addChild(b);
            }
        }
        addChild(ballsLayer);
        
        // msg init
        tx.autoSize   = flash.text.TextFieldAutoSize.CENTER;
        tx.selectable = false;
        addChild(tx);
        
        addEventListener(Event.ENTER_FRAME ,ef);
        stage.addEventListener(KeyboardEvent.KEY_DOWN ,key);
        stage.addEventListener(KeyboardEvent.KEY_UP   ,key);
       //stage.addEventListener(MouseEvent.MOUSE_DOWN ,modechg);

        msg("スペースを押してください。");

        var s:Stats = new Stats();
        addChild(s);
        addChild(test);
    }
    public function key(e:KeyboardEvent=null):void{
        if (e.keyCode == 37) { kal = ( e.type == KeyboardEvent.KEY_DOWN ); }// left
        if (e.keyCode == 39) { kar = ( e.type == KeyboardEvent.KEY_DOWN ); }// right
        if (e.keyCode == 32) { ksp = ( e.type == KeyboardEvent.KEY_DOWN ); }// space
    }
    public var test:Sprite = new Sprite();

    public function ef(e:Event=null):void{
        
        // goto文の代わりに while to break
        while(1){
            
            // gun move
            if(kal) gun.rotation--;
            if(kar) gun.rotation++;
            gun.rotation = MF.LIMIT(gun.rotation, 60,-60);
            
            // ball move
            if(ac){
                // ball active
                
                // move
                ball.x += bax;
                ball.y += bay;
                
                // limit hit test
                if((ball.x-BAL_W) < 0){ball.x=0+BAL_W; bax=-bax;}
                if((ball.x+BAL_W) > W){ball.x=W-BAL_W; bax=-bax;}
                
                // balls hit test
                if(ballsLayer.hitTestObject(ball)){
                    
                    
                    
                    
                }
                if(ksp){ac=false;}
                
            }else{
                // ball not active
                if(ksp){
                    //var mp:Number =MF.ISPM()
                    bax = Math.cos(MF.ANG_RAD(gun.rotation+90))*-1;
                    bay = Math.sin(MF.ANG_RAD(gun.rotation+90))*-1;
                    
                    ball.x = BAL_IX;
                    ball.y = BAL_IY;
                    
                    ac=true;
                }else{
                }
            }
            break;
        }
        //debug.out.text="x="+t.bits[0].x+" y="+t.bits[0].y+" vx="+t.bits[0].vx+" vy="+t.bits[0].vy+" ax="+t.bits[0].ax+" ay="+t.bits[0].ay;
    }
}




