/**
 * Copyright evgeniy.arshanskiy ( http://wonderfl.net/user/evgeniy.arshanskiy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/au2m
 */

// forked from glasses_factory's FishTank
/*//////////////////////////////////////
 * 俺々コードライブラリから無理矢理一枚にまとめたのでカオス
 * こっちの方がFPSでるぽ
 * http://glasses-factory.net/lab/FishTank.swf
 *//////////////////////////////////////
package
{
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor = 0x00faff, framRate = 60 )]
    public class FishTank extends Sprite
    {
        /*/////////////////////////////////////
        public methods
        /*/////////////////////////////////////
        
        public function reset():void
        {
            _tank.reset();
            _tank2.reset();
        }
        
        //Constractor
        public function FishTank()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode =StageScaleMode.NO_SCALE;
            init();
        }
        
        public function init():void
        {
            
            _tank = new Tank(this);
            _tank.init();
            _tank.y = 100;
            _tank.pow = 0.4;
            
            _tank2 = new Tank(this);
            _tank2.init();
            _tank2.y = 98;
            _tank2.id = 1;
            _tank2.alpha = 0.85;
            _tank2.pow = 0.63;
            addChild( _tank2);
            addChild( _tank );
            
            _fishVect = new Vector.<Fish>();
            for( var i:int = 0; i < _LINE_NUM; i++ )
            {
                var fish:Fish = new Fish( _PT_NUM, this );
                _fishVect.push( fish );
                addChild( fish );
            }
            
            addEventListener( Event.ENTER_FRAME, enterFrameFunc );
            
            stage.addEventListener( Event.RESIZE, function( e:Event ):void
            {
                reset();
            });
            
            stage.addEventListener( MouseEvent.MOUSE_UP, generateFood );
        }
        
        private function enterFrameFunc(e:Event  = null ):void
        {
            for(var i:int = 0; i < _fishVect.length; i++ )
            {
                _fishVect[i].drawLine();
            }
            _tank.enterFrameFunc();
            _tank2.enterFrameFunc();
            return;
        }
        
        private function generateFood( e:MouseEvent ):void
        {
            if( _tank.isMouseOver || _tank2.isMouseOver )
            {
                return;
            } 
            var food:Food = new Food( this );
            food.x = stage.mouseX;
            food.y = stage.mouseY;
            addChild( food );
            _foodAry.push( food );
        }
        
        /*/////////////////////////////////////
        private const
        /*/////////////////////////////////////
        
        //魚の大きさ？長さ？
        private const _PT_NUM:uint = 8;
        
        //魚の数
        private const _LINE_NUM:uint = 100;
        
        /*/////////////////////////////////////
        private variables
        /*/////////////////////////////////////
        
        private var _fishVect:Vector.<Fish>;
        
        private var _tank:Tank;
        
        private var _tank2:Tank;
        
        public var _foodAry:Array = [];
    }
}

import flash.display.Sprite;
class Fish extends Sprite
{
    
    /*////////////////////////////////////////////
    publuc variables
    /*////////////////////////////////////////////
    
    public var life:uint = 5;
    
    public function Fish( num:uint, parent:FishTank )
    {
        super();
        _POINT_NUM = num;
        init( parent );
    }
    
    /*////////////////////////////////////////////
    private methods
    /*////////////////////////////////////////////
    
    private function init( parent:FishTank ):void
    {
        _ptVect = new Vector.<SimpleFunnelBase>();
        for( var i:int = 0; i < _POINT_NUM; i++)
        {
            var p:SimpleFunnelBase = new SimpleFunnelBase();
            p.y = 150;
            _ptVect.push( p );
        }
        _fish = new FishBase( _ptVect[0], parent );
    }
    
    public function drawLine():void
    {
        graphics.clear();
        var p1:SimpleFunnelBase = _ptVect[0];
        var p2:SimpleFunnelBase = _ptVect[1];
        
        movePt( p1, p2, 0.02, 0.8 );
        var tick:Number = 6;
        
        if( _fish.isAte ){ _color = 0xff0000; }
        
        for( var j:int = 2; j < _ptVect.length; j++ )
        {
            var p3:SimpleFunnelBase = _ptVect[j - 1];
            var p4:SimpleFunnelBase = _ptVect[j];
            movePt( p3, p4, 0.5, 0.5);
            graphics.lineStyle( tick, _color );
            graphics.moveTo( p3.x, p3.y );
            graphics.lineTo( p4.x, p4.y );
            tick -= 0.9;
        }
    }
    
    private function movePt( pA:SimpleFunnelBase, pB:SimpleFunnelBase, spring:Number, friction:Number ):void
    {
        pB.vx += ( pA.x - pB.x ) * spring;
        pB.vx *= friction;
        pB.x += pB.vx;
        
        pB.vy += ( pA.y - pB.y ) * spring;
        pB.vy *= friction;
        pB.y += pB.vy;
    }
    
    private var _fish:FishBase;
    
    private var _ptVect:Vector.<SimpleFunnelBase>;
    
    private var _POINT_NUM:uint = 8;
    
    private var _color:uint = 0xffffff;
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.utils.Timer;

class FishBase extends Sprite
{
    /*////////////////////////////////////////////
    public variables
    /*////////////////////////////////////////////
    
    public var mass:Number = Math.random() * 10 + 10;
    
    /*////////////////////////////////////////////
    public methods
    /*////////////////////////////////////////////
    
    //Constractor
    public function FishBase( p:SimpleFunnelBase, parent:FishTank )
    {
        _p = p;
        _parent = parent;
        super();
        init();
    }
    
    
    /*////////////////////////////////////////////
    private methods
    /*////////////////////////////////////////////
    
    private function init():void
    {
        _timer = new Timer(0);
        
        
        _parent.stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDownHandler );
        _parent.stage.addEventListener( MouseEvent.MOUSE_UP, mouseUpHandler );
        
        _timer.addEventListener( TimerEvent.TIMER, timerHandler );
        _timer.start();
    }
    
    private function mouseDownHandler( e:MouseEvent ):void
    {
        _isPress = true;
        _lastMass = mass;
        mass = 100;
    }
    
    private function mouseUpHandler( e:MouseEvent ):void
    {
        _isPress = false;
        mass = Math.random() * 10 + 10;
    }
    
    private function timerHandler( e:TimerEvent ):void
    {
        if( _isPress )
        {
            _p.x = Math.random() * mass - mass * 0.5 + _parent.stage.mouseX | 0;
            _p.y = Math.random() * mass - mass * 0.5 + _parent.stage.mouseY | 0;
        }
        else
        {
            _p.vx += Math.random() * mass - mass * 0.5 | 0; 
            _p.x += _p.vx;
            
            _p.vy += Math.random() * mass - mass * 0.5 | 0;
            _p.y += _p.vy;    
        }
        findFood();
        bounce();
        _timer.delay = Math.random() * 110 + 110;
    }
    
    private function findFood():void
    {
        if( _parent._foodAry.length > 0 )
        {
            for( var i:int = 0; i < _parent._foodAry.length; i++ )
            {
                var dx:Number = _parent._foodAry[i].x - _p.x;
                var dy:Number = _parent._foodAry[i].y - _p.y;
                if( _parent._foodAry[i].y >  200 )
                {
                    if( Math.abs(dx) < 50 && Math.abs(dy) < 50 )
                    {
                        _p.x =  _parent._foodAry[i].x | 0;
                        _p.y =  _parent._foodAry[i].y | 0;
                        if( dx < 5 && dy < 5 )
                        {
                            _parent._foodAry[i].eat();
                            this.isAte = true;
                        }
                    }
                }
            }
        }
    }
    
    private function bounce():void
    {
        if( _p.x > _parent.stage.stageWidth )
        {
            _p.x = _parent.stage.stageWidth - 1;
            _p.vx *= -0.9;
        }
        if( _p.x < 0 )
        {
            _p.x = 1;
            _p.vx *= -0.9;
        }
        
        if( _p.y > _parent.stage.stageHeight )
        {
            _p.y = _parent.stage.stageHeight - 1;
            _p.vy *= -0.9;
        }
        if( _p.y < 130 )
        {
            _p.y = 131;
            _p.vy *= -0.9;
        }
    }
    
    
    /*////////////////////////////////////////////
    private variables
    /*////////////////////////////////////////////
    
    public var isAte:Boolean = false;
    
    private var _p:SimpleFunnelBase;
    
    private var _parent:FishTank;
    
    private var _timer:Timer;
    
    private var _isPress:Boolean;
    
    private var _lastMass:Number;
}

import flash.display.Sprite;

class Food extends Sprite
{
    public function eat():void
    {
        this.parent.removeChild( this );
        var index:int = this._parent._foodAry.indexOf( this );
        this._parent._foodAry.splice( index, 1);
        removeEventListener( Event.ENTER_FRAME, this.enterFrameFunc );
    }
    
    public function Food( parent:FishTank )
    {
        this._parent = parent;
        init();
        
        addEventListener( Event.ENTER_FRAME, this.enterFrameFunc )
    }
    
    private function init():void
    {
        graphics.beginFill( 0, 1 );
        graphics.moveTo( Math.cos( 0 ) * _radius, Math.sin( 0 ) * _radius );
        for( var i:int = 0; i < _deko; i++ )
        {
            var ang:Number = Math.PI * 2 / _deko * i;
            var rad:Number = _radius + ( Math.random() * _degree - _degree / 2 );
            graphics.lineTo( Math.cos( ang ) * rad, Math.sin( ang ) * rad );
        }
        graphics.endFill();
        this.blendMode = 'invert';
    }
    
    private function enterFrameFunc( e:Event = null ):void
    {
        this._vx = Math.random() * 2 - 1;
        this._vy = Math.random() * 2 - 1;
        this._vy += Math.abs( _gravity * this._radius );
        this.x += this._vx;
        this.y += this._vy;
        
        if( this.y > _parent.stage.stageHeight )
        {
            if( this.parent != null)
            {    
                this.parent.removeChild( this );
                var index:int = this._parent._foodAry.indexOf( this );
                this._parent._foodAry.splice( index, 1);
                removeEventListener( Event.ENTER_FRAME, this.enterFrameFunc );
            }
        }
    }
    
    private var _parent:FishTank;
    
    private var _gravity:Number = 0.5;
    
    private var _vx:Number;
    
    private var _vy:Number;
    
    private var _radius:Number = Math.random() * 4 + 4;
    
    private var _deko:uint =  10;
    
    private var _degree:Number  = _radius / 5;
}

import flash.display.Graphics;
//ラスボス
class Tank extends Sprite
{
    /*/////////////////////////////////////////
    * public consts
    /*/////////////////////////////////////////
    
    public static var NUM:Number = 30;
    public static var a:Number = 100;
    public static var b:Number = 1;
    public static var bk:Number = 1.015;
    public static var reactPow:Number = 0.8;
    public static var reactRange:Number = 4;
    public static var mmin:Number = 40;
    public static var interval:Number = 0;
    
    /*/////////////////////////////////////////
    * public vars
    /*/////////////////////////////////////////
    
    public var count:Number = Tank.interval;
    
    public var _y:Number = 0;
    
    public var gridX:Number;
    
    public var id:uint = 0;
    
    public var k:Number = 0;
    
    public var m:Object;
    
    public var tmpM:Object;
    
    public var mx:Number = 0;
    
    public var mx0:Number = 0;
    
    public var my:Number = 0;
    
    public var my0:Number = 0;
    
    public var timelag_in:TimeLager;
    
    public var timelag_out:TimeLager;
    
    public var ptVect:Vector.<SimpleFunnelBase>;
    
    public var right:Number;
    
    public var bottom:Number = 0;
    
    public var pow:Number = 0.6;
    
    public var isMouseOver:Boolean = false;
    
    public var color:uint;
    
    //Constractor
    public function Tank(parent:FishTank)
    {
        this._parent = parent;
        super();
    }
    
    public function init( col:uint = 0 ):void
    {
        color = col;
        k = id * 0.07 + 0.05;
        mx = this.mouseX;
        my = this.mouseY;
        m = {};
        tmpM = {};
        
        ptVect = new Vector.<SimpleFunnelBase>();
        right = _parent.stage.stageWidth;
        bottom = _parent.stage.stageHeight - this.y;
        gridX = right / Tank.NUM;
        timelag_in = new TimeLager( this.action, ["in"]);
        timelag_out = new TimeLager( this.action, ["out"]);
        this.useHandCursor = false;
        var i:int = 0;
        while( i <= Tank.NUM )
        {
            var p:SimpleFunnelBase = new SimpleFunnelBase();
            p.x = gridX * i | 0;
            p.y = 0;
            p.x0 = p.x;        p.y0 = p.y;
            p.vx = 0;    p.vy = 0;
            ptVect.push( p );
            ++i;
        }
        addEventListener( MouseEvent.MOUSE_OVER, mouseOverHandler );
        addEventListener( MouseEvent.MOUSE_OUT, mouseOutHandler );
    }
    
    public function action( option:String ):void
    {
        var param:String;
        if (( param = option) === "in" )
        {
            this.reaction(tmpM);
            return;
        }
        else
        {
            if( param !== "out" )
            {
                return;
            }
        }
        this.reaction(tmpM);
        return;
    }
    
    public function enterFrameFunc():void
    {
        mx0 = mx;
        my0 = my;
        mx = this.mouseX;
        my = this.mouseY;
        var dmy:Number = my - my0;
        var dmx:Number = mx - mx0;
        m.x = Math.max(Math.min(dmx, Tank.mmin), 0 - Tank.mmin );
        m.y = Math.max(Math.min(dmy, Tank.mmin), 0 - Tank.mmin );
        wave();
        movePt();
        drawCurve();
    }
    
    public function wave():void
    {
        for(var i:int = 0; i < Tank.NUM; ++i)
        {
            var dx:Number = 0;
            var dy:Number = 0;
            if(i == 0)
            {
                dy = ptVect[1].y - ptVect[0].y;
                dx = ptVect[1].x - ptVect[0].x;
            }
            else
            {
                if( i == Tank.NUM )
                {
                    dy = ptVect[i-1].y - ptVect[i].y;
                    dx = ptVect[i-1].x - ptVect[i].x;
                }
                else
                {
                    dy = ptVect[i + 1].y + ptVect[i-1].y - 2 * ptVect[i].y;
                    dx = ptVect[i + 1].x + ptVect[i-1].x - 2 * ptVect[i].x;
                }
            }
            var ay:Number = dy * this.k;
            var ax:Number = dx * this.k;
            ptVect[i].vy = ( ptVect[i].vy + ay ) / Tank.bk;
            ptVect[i].vx = ( ptVect[i].vx + ax ) / Tank.bk;
        }
        return;
    }
    
    public function movePt():void
    {
        for(var i:int =0; i < Tank.NUM; ++i)
        {
            ptVect[i].y += ptVect[i].vy;
            ptVect[i].vy = ( ptVect[i].vy + (ptVect[i].y0  - ptVect[i].y) / Tank.a) / Tank.b;
            if( i != 0 && i != Tank.NUM )
            {
                ptVect[i].x += ptVect[i].vx;
                ptVect[i].vx = ( ptVect[i].vx + ( ptVect[i].x0 - ptVect[i].x ) / Tank.a ) / Tank.b;
            }
            else
            {
                ptVect[i].vx = 0;
            }
        }
        return;
    }
    
    public function reaction(mt:Object):void
    {
        var perMx:int = Math.round( mx / gridX );
        var perMy:int = Math.ceil( Tank.reactRange * Math.abs( mt.y ) / 20 );
        var mpy:Number = Math.abs( mt.y / 8 ) + 3;
        for(var i:int =0; i < Tank.NUM; ++i)
        {
            var fx:Number = Math.abs(perMx - i);
            var fy:Number = Math.max((perMy - fx) / perMy, 0 ) * 3.14159265359 - 1.57079632679;
            var afy:Number = ( Math.sin( fy ) + 1 ) * 0.5;
            var force:Number = ( pow * Tank.reactPow * mt.y * afy + (Math.random() * mpy - mpy * 0.5 )) * stage.stageWidth / 1000;
            ptVect[i].vy += force;
            ptVect[i].vx += ( force * mt.x / mt.y / 3 );
        }
        return;
    }
    
    public function drawCurve():void
    {
        var g:Graphics = this.graphics;
        g.clear();
        g.beginFill( color, alpha );
        g.moveTo(ptVect[0].x, ptVect[0].y);
        g.lineTo((ptVect[0].x + ptVect[1].x ) * 0.5, ( ptVect[0].y + ptVect[1].y ) * 0.5 );
        var i:int = 1;
        while( i < Tank.NUM )
        {
            g.curveTo(ptVect[i].x, ptVect[i].y, ( ptVect[i].x + ptVect[i+1].x ) * 0.5, ( ptVect[i].y + ptVect[i+1].y ) * 0.5 );
            ++i;
        }
        g.lineTo( ptVect[ Tank.NUM ].x, ptVect[ Tank.NUM ].y );
        g.lineTo( right, bottom );
        g.lineTo( 0, bottom);
        g.endFill();
    }
    
    public function reset():void
    {
        right = _parent.stage.stageWidth;
        bottom = _parent.stage.stageHeight - this.y;
        gridX = right / Tank.NUM;
        this.useHandCursor = false;
        var i:int = 0;
        while( i <= Tank.NUM )
        {
            ptVect[i].x = gridX * i;
            ptVect[i].x0 = ptVect[i].x;
            ++i;
        }
    }
    
    /*/////////////////////////////////////////
    * private methods
    /*/////////////////////////////////////////
    
    private function mouseOverHandler( e:MouseEvent ):void
    {
        isMouseOver = true;
        if( m.y > 0 )
        {
            tmpM.x = m.x;
            tmpM.y = m.y;
            timelag_in.play();
            return;
        }
    }
    
    private function mouseOutHandler( e:MouseEvent ):void
    {
        isMouseOver = false;
        if( m.y < 0 )
        {
            tmpM.x = m.x;
            tmpM.y = m.y;
            timelag_out.play();
            return;
        }
    }
    
    /*/////////////////////////////////////////
    * private variables
    /*/////////////////////////////////////////
    
    private var _parent:FishTank;
}

import flash.display.MovieClip;

class TimeLager extends MovieClip
{
    /*/////////////////////////////////////////
    * public methods
    /*/////////////////////////////////////////
    
    //Constractor
    public function TimeLager( func:Function, args:Array, lagTime:uint = 3 )
    {
        super();
        executeFunc = func;
        this.args = args;
        this.lagTime = lagTime;
        _isProcessing = false;
    }
    
    override public function play():void
    {
        if( _isProcessing )
        {
            return;
        }
        _lagCnt = 0;
        addEventListener( Event.ENTER_FRAME, _lag );
    }
    
    
    /*/////////////////////////////////////////
    * private methods
    /*/////////////////////////////////////////
    
    private function _lag( e:Event ):void
    {
        if( _lagCnt > lagTime )
        {
            executeFunc.apply( null, args );
            removeEventListener( Event.ENTER_FRAME, _lag );
            dispatchEvent( new Event( Event.COMPLETE ));
            _isProcessing = false;
        }
        _lagCnt++;
    }
    
    /*/////////////////////////////////////////
    * private vars
    /*/////////////////////////////////////////
    
    public var executeFunc:Function;
    
    public var args:Array;
    
    public var lagTime:uint;
    
    private var _lagCnt:uint = 0;
    
    private var _isProcessing:Boolean;
}

class SimpleFunnelBase
{
    //x位置:整数値
    public var x:int;
    
    //y位置:整数値
    public var y:int;
    
    //x速度:数字
    public var vx:Number;
    
    //y速度:数字
    public var vy:Number;
    
    //x保持
    public var x0:Number;
    
    //y保持
    public var y0:Number;
    
    public function SimpleFunnelBase()
    {
        x = 0;
        y = 0;
        vx = 0;
        vy = 0;
        x0 = 0;
        y0 = 0;
    }
}