/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/atiq
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    import net.hires.debug.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            //stage.scaleMode = StageScaleMode.NO_SCALE;
            
            graphics.beginFill(0x000033);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            //addChild(new BitmapTwist((stage.stageHeight / 5)));
            addChild(new BitmapTwist());
            //addChild(new BitmapTwist((stage.stageHeight * 0.8)));
            
            addChild(new Stats());
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class BitmapTwist extends Sprite
{
    private static const RADIUS :Number = 120;
    private static const THICKNESS :Number = 4;

    private var vertexPool :Vector.<Vertex>;
    private var twistBmpData :BitmapData;
    private var twistSize :Number;
    private var twistY :Number;
    private var tick :uint;

    public function BitmapTwist($twistY:Number = 232.5)
    {
        vertexPool = Vector.<Vertex>
        ([
            new Vertex(0, 0xFF0000),
            new Vertex(0, 0xFF9900),
            new Vertex(0, 0x009900),
            new Vertex(0, 0x0099FF),
            new Vertex(0, 0xFFFFFF)
        ]);

        twistBmpData = new BitmapData(1, 1);
        twistSize = (2 * RADIUS * Math.sin(Math.PI / vertexPool.length));
        twistY = $twistY;
        tick = 0;
        
        addEventListener(Event.ENTER_FRAME, onFrame);
    }
    
    private function onFrame($e:*) :void
    {
        ++tick;
        twistBmpData.perlinNoise(3, 0, 1, 108, false, true, 4, false, [new Point(tick / 17.0, 0)]);
        init((twistBmpData.getPixel(0, 0) - 128.0) / 128.0 * 2 * Math.PI, (tick / 41.0) * Math.PI);
    }

    private function init($twistX:Number, $twistY:Number) :void
    {
        var $canvas :Graphics = graphics;
        var $length :uint = (stage.stageWidth - 1);
        var $i :uint;
        
        $canvas.clear();
        
        for (var $x :uint = 0; $x <= $length; $x += THICKNESS)
        {
            var $fit :Number = ($twistX * $x / $length + $twistY);
            
            for ($i = 0; $i < vertexPool.length; ++$i)
            {
                vertexPool[$i].coordinate = (RADIUS * Math.cos(2 * Math.PI * $i / vertexPool.length + $fit));
            }
            for ($i = 0; $i < vertexPool.length; ++$i)
            {
                var $yA :Number = vertexPool[$i].coordinate;
                var $yB :Number = vertexPool[($i + 1) % vertexPool.length].coordinate;
                
                if ($yA < $yB)
                {
                    $canvas.beginFill(color(vertexPool[$i].color, ($yB - $yA) / twistSize));
                    $canvas.drawRect($x, (twistY + $yA), THICKNESS, ($yB - $yA));
                    $canvas.endFill();
                }
            }
        }
    }
    
    private function color($color:uint, $shade:Number) :uint
    {
        var $r :uint = ($color >> 16);
        var $g :uint = (($color >> 8) & 0xFF);
        var $b :uint = ($color & 0xFF);
        
        return ((($r * $shade) >> 0) << 16 | (($g * $shade) >> 0) << 8 | ($b * $shade) >> 0);
    }
}

class Vertex
{
    public var coordinate :Number;
    public var color :uint;

    public function Vertex($y:Number, $color:uint)
    {
        coordinate = $y;
        color = $color;
    }
}