/**
 * Copyright momolab ( http://wonderfl.net/user/momolab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ataF
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.text.TextFormat;
    import flash.text.engine.ContentElement;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.FontPosture;
    import flash.text.engine.FontWeight;
    import flash.text.engine.GraphicElement;
    import flash.text.engine.GroupElement;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.TextLine;
    
    public class TestDaumTextEngine extends Sprite {
        private var _textField:TextField;
        
        private var fontDescription:FontDescription;
        private var elementFormat:ElementFormat;
        private var textEngineLayer:Sprite;
        private var contentCollection:Vector.<ContentElement>;
        
        public function TestDaumTextEngine() {
            // Test Text Engine
            var format:TextFormat = new TextFormat();
            format.font = "Malgun Gothic";
            format.size = 20;
            format.color = 0x333333;
            format.bold = false;
            format.italic = false;
            
            createTextField(format);
            
            fontDescription = new FontDescription();
            elementFormat = new ElementFormat();
            textLinesDefaultFormat(format);
            
            textEngineLayer = new Sprite();
            addChild(textEngineLayer);
        }
        
        private function createTextField(format:TextFormat):void {
            _textField = new TextField();
            _textField.type = TextFieldType.INPUT;
            _textField.autoSize = TextFieldAutoSize.LEFT;
            _textField.multiline = true;
            _textField.border = true;
            _textField.borderColor = 0;
            addChild(_textField);
            
            _textField.defaultTextFormat = format;
            
            _textField.addEventListener(Event.CHANGE, textFieldChangeHandler);
        }
        
        private function textFieldChangeHandler(event:Event):void {
            createTextLines(event.target.text);
            
            textEngineLayer.y = _textField.y + _textField.height;
        }
        
        private function createTextLines(value:String):void {
            var textLine:TextLine = null;
            var textBlock:TextBlock;
            var textElement:TextElement;
            var graphicElement:GraphicElement;
            var groupElement:GroupElement;
            var char:String;
            
            removeAllTextLine();
            
            contentCollection = new Vector.<ContentElement>();
            
            for(var i:int = 0, l:int = value.length; i < l; i++) {
                char = value.charAt(i);
                
                switch (char) {
//                    case "A" :
//                    case "B" :
//                    case "C" :
//                    case "D" :
//                    case "E" :
//                    case "F" :
//                        graphicElement = createGraphicElement(char, elementFormat, 64, 64);
//                        contentCollection.push(graphicElement);
//                        break;
                    case "1" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/animals/48/Panda.png", elementFormat, 48, 48);
                        contentCollection.push(graphicElement);
                        break;
                    case "2" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/animals/48/Elephant.png", elementFormat, 48, 48);
                        contentCollection.push(graphicElement);
                        break;
                    case "3" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/animals/48/Butterfly.png", elementFormat, 48, 48);
                        contentCollection.push(graphicElement);
                        break;
                    case "4" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/animals/48/Dolphin.png", elementFormat, 48, 48);
                        contentCollection.push(graphicElement);
                        break;
                    case "a" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/walle/64/my_computer.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "b" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/walle/64/media_player.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "c" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/walle/64/my_documents.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "d" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/walle/64/basket_empty.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "e" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/walle/64/search.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "f" :
                        graphicElement = createGraphicElementWithURL("http://cdn1.iconfinder.com/data/icons/walle/64/network.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "g" :
                        graphicElement = createGraphicElementWithURL("http://server2.iconfinder.com/data/icons/walle/64/basket_full.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    case "h" :
                        graphicElement = createGraphicElementWithURL("http://server2.iconfinder.com/data/icons/walle/64/my_applications.png", elementFormat, 64, 64);
                        contentCollection.push(graphicElement);
                        break;
                    default :
                        textElement = createTextElement(char, elementFormat);
                        contentCollection.push(textElement);
                        break;
                }
            }
            
            groupElement = new GroupElement(contentCollection);
            
            textBlock = new TextBlock();
            textBlock.content = groupElement;
            
            while(textLine = textBlock.createTextLine(textLine)) {
                textEngineLayer.addChild(textLine);
                textLine.y = textEngineLayer.height;
            }
        }
        
        private function textLinesDefaultFormat(format:TextFormat):void {
            fontDescription = fontDescription.clone();
            elementFormat = elementFormat.clone();
            
            fontDescription.fontName = (format.font) ? format.font : fontDescription.fontName;
            elementFormat.fontSize = (format.size) ? Number(format.size) : elementFormat.fontSize;
            elementFormat.color = (format.color) ? uint(format.color) : elementFormat.color;
            fontDescription.fontWeight = (format.bold) ? FontWeight.BOLD : fontDescription.fontWeight;
            fontDescription.fontPosture = (format.italic) ? FontPosture.ITALIC : fontDescription.fontPosture;
            
            elementFormat.fontDescription = fontDescription;
        }
        
        private function createGraphicElement(name:String, format:ElementFormat, elementWidth:Number = 15.0, elementHeight:Number = 15.0):GraphicElement {
            var graphicElement:GraphicElement = new GraphicElement(new this[name](), elementWidth, elementHeight);
            graphicElement.elementFormat = format;
            
            return graphicElement;
        }
        
        private function createGraphicElementWithURL(url:String, format:ElementFormat, elementWidth:Number = 15.0, elementHeight:Number = 15.0):GraphicElement {
            var tempGraphic:Shape = new Shape();
            tempGraphic.graphics.drawRect(0, 0, elementWidth, elementHeight);
            
            var graphicElement:GraphicElement = new GraphicElement(tempGraphic, elementWidth, elementHeight);
            graphicElement.elementFormat = format;
            
            var contentLoader:Loader = new Loader();
            var contentLoadCompleteHandler:Function = function(event:Event):void {
                graphicElement.graphic = contentLoader;
                contentLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, contentLoadCompleteHandler);
            };
            contentLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, contentLoadCompleteHandler);
            var request:URLRequest = new URLRequest(url);
            contentLoader.load(request);
            
            return graphicElement;
        }
        
        private function createTextElement(textData:String, format:ElementFormat):TextElement {
            var textElement:TextElement = new TextElement(textData, elementFormat);
            
            return textElement;
        }
        
        private function removeAllTextLine():void {
            while(textEngineLayer.numChildren) {
                textEngineLayer.removeChildAt(0);
            }
        }
    }
}