/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/asV9
 */

package{
	import flash.events.Event;
	
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.PhongMaterial;
	import org.papervision3d.view.BasicView;

	public class ExPaperPlane extends BasicView
	{
		private var _list:Vector.<One> = new Vector.<One>();
		private var _max:uint = 100;
		
		public function ExPaperPlane()
		{
			super(465,465,false);
			opaqueBackground = 0;
			
			var light:PointLight3D = new PointLight3D(true);
			light.z = -1000;
			light.y = 400;
			var material:PhongMaterial = new PhongMaterial(light,0xffffff,0x444444,1);
			
			var i:uint=0;
			for(i=0; i<_max; i++)
			{
				var p:One = scene.addChild(new One(material))as One;
				_list.push(p);
			}
			
			startRendering();
			addEventListener(Event.ENTER_FRAME,loop);
			
			function loop(e:Event):void
			{
				for(i=0;i<_max; i++)
				{
					_list[i].fly();
				}
			}
		}
	}
}
	import org.papervision3d.objects.primitives.PaperPlane;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.PhongMaterial;

class One extends PaperPlane
{
	private var _angle0:Number=0;
	private var _angle1:Number=0;
	private var _radiusX:Number=150;
	private var _radiusY:Number=100;
	private var _radiusZ:Number=1200;
	private var _offsetY:Number=0;
	private var _offsetZ:Number=0;
	
	private const PI:Number = 180/Math.PI;
	
	public function One(material:PhongMaterial)
	{
		super(material,Math.random()*0.5+0.25);
		
		_angle0 = Math.random() * 2 - 1;
		_angle1 = Math.random() * 2 - 1;
		_radiusX = Math.random() * 100 + 200;
		_radiusY = Math.random() * 200 + 200;
		_radiusZ = Math.random() * 300 + 1200;
		_offsetY = Math.random() * 200;
		_offsetZ = Math.random() * 150;
	}
	
	public function fly():void
	{
		this.x = Math.cos(_angle0) * _radiusX;
		this.y = Math.sin(_angle0) * _radiusY + _offsetY;
		this.z = Math.sin(_angle1) * _radiusZ + _offsetZ;
		
		this.rotationY = -_angle1 * PI;
		
		_angle0 += 0.04;
		_angle1 += 0.04;
	}
}