/**
 * Copyright designquest ( http://wonderfl.net/user/designquest )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/as98
 */

// forked from designquest's Box2D Test
package 
{

	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.utils.Timer;
	import flash.events.TimerEvent;

	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;

	import alternativ5.engine3d.controllers.*;
	import alternativ5.engine3d.core.*;
	import alternativ5.engine3d.display.*;
	import alternativ5.engine3d.materials.*;
	import alternativ5.engine3d.primitives.*;
	import alternativ5.types.*;
	import alternativ5.utils.*;
	import alternativ5.utils.FPS;

	[SWF(backgroundColor = "#000000",frameRate = "100")]

	public class test1 extends Sprite
	{

		public var m_world:b2World;
		public var m_iterations:int = 5;
		public var m_timeStep:Number = 1.0 / 30.0;
		public static const RATIO:int = 30;
                public var total_ball:int = 0;
		public var dbgSprite:Sprite;// Sprite of Debug Draw

		public var scene3d:Scene3D;
		public var view:View;
		public var camera:Camera3D;
		public var cameraController:CameraController;
		public var sphere:GeoSphere;

		public function test1()
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		public function init(e:Event):void
		{

			removeEventListener(Event.ADDED_TO_STAGE, init);

			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;

			// Build Box2D World
			buildWorld();
			buildGround(3,10,14,0.5,0.3);
			buildGround(17,10,14,0.5,-0.3);
			debugDraw();

			// Build Alternativa3D World
			build3DWorld();
			addObject();
			
			// Loop
			var loopTimer:Timer = new Timer(10000,0);
			loopTimer.addEventListener(TimerEvent.TIMER, addObject); 
			loopTimer.start();


			addEventListener(Event.ENTER_FRAME, Update, false, 0, true);
		}

		/*	A physics world is a collection of bodies, shapes, and constraints 
			that interact together. Box2D supports the creation of multiple worlds, 
			but this is usually not necessary or desirable.
		*/
		private function buildWorld():void
		{
			// Creat world AABB
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-1, -1);
			worldAABB.upperBound.Set(stage.stageWidth/RATIO+1, stage.stageHeight/RATIO+1);

			// Define the gravity vector
			var gravity:b2Vec2 = new b2Vec2(0,5.0);

			// Allow bodies to sleep
			var doSleep:Boolean = true;

			// Construct a world object
			m_world = new b2World(worldAABB,gravity,doSleep);
		}

/*	Bodies are built using the following steps:
			1) Define a body with a position, damping, etc.
			2) Use the world object to create the body.
			3) Define shapes with geometry, friction, density, etc.
			4) Create shapes on the body.
			5) Optionally adjust the body's mass to match the attached shapes.
		*/
		private function buildGround(Gx:Number,Gy:Number,Gw:Number,Gh:Number,Ga:Number):void
		{
			var ground:b2Body;
			var groundDef:b2BodyDef;
			var boxDef:b2PolygonDef;

			// Define a body with a position, damping, etc
			groundDef = new b2BodyDef();
			groundDef.position.Set(Gx, Gy);
			groundDef.angle = Ga;

			// make the body visible (PhyGround is a MovieClip in Library)
			//groundDef.userData = new PhysGround();
			//groundDef.userData.width = Gw*RATIO; 
			//groundDef.userData.height = Gh*RATIO; 
			//addChild(groundDef.userData);

			// Use the world object to create the body
			ground = m_world.CreateBody(groundDef);

			/* 	Define shapes,
			 	a 2D piece of collision geometry that is rigidly attached to a body. 
				Shapes have material properties of friction and restitution.
			*/
			boxDef = new b2PolygonDef();
			boxDef.SetAsBox(Gw/2, Gh/2);
			boxDef.friction = 0.3;
			boxDef.density = 0;// static bodies require zero density

			// Create shapes on the body
			ground.CreateShape(boxDef);
		}

		private function addObject(e:TimerEvent = null):void
		{
    
                        total_ball ++;
                        if (total_ball > 8) {
                            return;
                        }
                        
			var body:b2Body;
			var bodyDef:b2BodyDef;
			var boxDef:b2PolygonDef;
			var circleDef:b2CircleDef;

			bodyDef = new b2BodyDef();
			bodyDef.position.x = Math.random()*400 / RATIO;
			bodyDef.position.y = Math.random()*300 / RATIO;

			var rX:Number = Math.random() + 0.1;
			var rY:Number = -3;

			// Circle
			circleDef = new b2CircleDef();
			circleDef.radius = rX + 0.5;
			circleDef.density = 1.0;
			circleDef.friction = 0.5;
			circleDef.restitution = 0.8;

			//bodyDef.userData = new PhysCircle();
			//bodyDef.userData.width = rX * 2 * RATIO; 
			//bodyDef.userData.height = rX * 2 * RATIO; 
			//addChild(bodyDef.userData);

			body = m_world.CreateBody(bodyDef);
			body.CreateShape(circleDef);
			body.SetMassFromShapes();

			addSphere(circleDef.radius * 10);
		}

		private function Update(e:Event):void
		{

			m_world.Step(m_timeStep, m_iterations);
			
			// Go through body list and update sprite positions/rotations
			//for (var bb:b2Body = m_world.m_bodyList; bb; bb = bb.m_next) {
				//if (bb.m_userData is Sprite) {
					sphere.x = m_world.m_bodyList.GetPosition().x * 10 - 100;
					sphere.z = - m_world.m_bodyList.GetPosition().y * 10 + 100;
					sphere.rotationY = m_world.m_bodyList.GetAngle();
				//}
			//}

			// 3D World Update
			cameraController.processInput();
			scene3d.calculate();
		}

		private function debugDraw():void
		{
			var dbgDraw:b2DebugDraw = new b2DebugDraw();
			dbgSprite = new Sprite();
			addChild(dbgSprite);
			dbgSprite.alpha = 0.5;
			dbgDraw.m_sprite = dbgSprite;
			dbgDraw.m_drawScale = RATIO;
			dbgDraw.m_fillAlpha = 0.0;
			dbgDraw.m_lineThickness = 1.0;
			dbgDraw.m_drawFlags = 0xFFFFFFFF;
			m_world.SetDebugDraw(dbgDraw);

		}

		//    3D World Start
		private function build3DWorld():void
		{
			// Create scene
			scene3d = new Scene3D();
			scene3d.root = new Object3D();
			// Create sphere
			//sphere = new GeoSphere(100, 3);
			//sphere.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFFFFFF));
			//scene.root.addChild(sphere);

			// Add camera and view
			camera = new Camera3D();
			camera.x = 130;
			camera.y = -90;
			camera.z = 130;
			scene3d.root.addChild(camera);

			view = new View();
			addChild(view);
			view.camera = camera;
			// Add camera controller
			cameraController = new CameraController(stage);
			cameraController.camera = camera;
			//cameraController.lookAt(sphere.coords);
			cameraController.setDefaultBindings();
			cameraController.checkCollisions = true;
			cameraController.collisionRadius = 20;
			cameraController.speed = 200;
			cameraController.controlsEnabled = true;

			// FPS counter init
			FPS.init(stage);

			stage.addEventListener(Event.RESIZE, onResize);
			onResize(null);

		}

		//    Testing draw
		private function addSphere(w:Number=80):void
		{
			// Create sphere
			sphere = new GeoSphere(w,2);
			sphere.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFFFFFF));
			scene3d.root.addChild(sphere);
			cameraController.lookAt(sphere.coords);
		}

		private function onResize(e:Event):void
		{
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}


	}

}