/**
 * Copyright kamip ( http://wonderfl.net/user/kamip )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/as54
 */

// --------------------------------
// 外部ファイル（画像）を読み込む方法
// http://d.hatena.ne.jp/kamip/
package   
{ 
    import flash.display.Bitmap;
    import flash.display.Loader; 
    import flash.display.Sprite; 
    import flash.errors.IOError;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent; 
    import flash.net.URLRequest; 
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    /** 
     * ... 
     * @author kamip 
     */ 
    public class Wonderfla extends Sprite
    { 
        private var loader:Loader; 
        private var bmp:Bitmap;
        private var tf:TextField = new TextField();
        
        public function Wonderfla()  
        { 
            addChild(tf);
            tf.text = "aaa";
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.x = stage.stageWidth / 2;
            tf.y = stage.stageHeight / 2;
            
            var rq:URLRequest = new URLRequest(); 
            rq.url = "http://dmpm.org/images/user.gif";
            //Security.loadPolicyFile("http://dmpm.org/images/crossdomain.xml");
            
            loader = new Loader();
            var lc:LoaderContext = new LoaderContext();
            lc.checkPolicyFile = true;
            loader.load(rq, lc); //LoaderContextオブジェクトを第2引数に
            addChild(loader);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIoError);
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);

        } 
        
        public function onComplete(e:Event):void {
            loader = Loader(e.target.loader);
            bmp = Bitmap(loader.content);
            tf.text = "Lets mouse click";
        }
        
        public function onIoError(e:IOErrorEvent):void {
            tf.text = "error";
        }
        
        public function onMouseClick(e:MouseEvent):void { 
            var bitmap:Bitmap = new Bitmap( bmp.bitmapData.clone() );
            addChild(bitmap);
            bitmap.x = mouseX;
            bitmap.y = mouseY;
            //bitmap.z = 0;
            //tf.text = "mouseX:" + mouseX + ",mouseY:" + mouseY;
            removeChild(tf);
        } 
         
    } 
     
}