/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/arii
 */

package {
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;
    import flash.display.BitmapData;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
           Wonderfl.disable_capture();
           deb = new TextField();
           deb.width=320;deb.height=240; deb.mouseEnabled=false;
           addChild(deb);
        
           myRend = new xMiniRender();
           addChild(myRend);
           myRend.init(); 
           
        
           stage.addEventListener(Event.ENTER_FRAME, initLoop);                           
        }//ctor

        public var myRend:xMiniRender;
        public var deb:TextField;
        
        public function initLoop(e:Event):void
        {
           if (myRend.cerr) { deb.text = myRend.cerr_msg; return; }
           if (myRend.cready == false) { return; }
           stage.removeEventListener(Event.ENTER_FRAME, initLoop); 
           stage.addEventListener(Event.ENTER_FRAME, onEnter);                     
           deb.text = "ready";   
           deb.text = myRend.context.driverInfo; 
        }//init


        public var gt:int = 0;
        public function onEnter(e:Event):void
        {
           deb.text = ""+gt;

            myRend.context.clear(); 
             myRend.use2DMode(465,465);
             
             myRend.setColor(1,0,0);      myRend.drawRect(0,0, 465,465);
             myRend.setColor(0,0,1);      myRend.drawRect(64,64, 64,64);

             myRend.setColor(0,0,0,0.5);
             myRend.drawSprite(330, 330, 640,640, gt*-0.03);

             myRend.setColor(0,0,1);
             myRend.drawSprite(230, 230, 64,64, gt*0.1);

             var i:int; 
             var n:Number;
             for (i =0; i < 256; i++)
             {
                 myRend.setColor(((gt+i)%256)/256,0.3,i*0.02,0.2);
 
                 n = (gt+i) *0.02;
                 myRend.drawSprite(230+Math.sin(n)*256, 230+Math.cos(n)*256, 64+i,64, i);                 
             }

            
            myRend.context.present();            
      
           gt += 1;
               
        }//onenter
        
        
    }//classend
}

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.ErrorEvent;
import flash.events.Event;
import flash.geom.Matrix;
import flash.geom.Matrix3D;
import flash.geom.Vector3D;
import flash.utils.ByteArray;
import com.adobe.utils.AGALMiniAssembler;
import flash.display3D.*;
import flash.display3D.textures.Texture;

internal class xMiniRender extends Sprite
{ 

  public var cready:Boolean = false;
  public var cerr:Boolean = false;
  public var cerr_msg:String = "noerror";
  
  public var context:Context3D = null;
  public var scrWidth:int = 400;
  public var scrHeight:int = 400;

  public var prog:Program3D;
 
  public var projmat:Matrix3D = new Matrix3D();
  public var cammat:Matrix3D = new Matrix3D();
  public var mat:Matrix3D = new Matrix3D();
  public var texMat:Matrix3D = new Matrix3D(); 

  public var blankSkin:xTex;

 public function init():void
  {
    stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, contReady);
    stage.stage3Ds[0].addEventListener(ErrorEvent.ERROR, onError);
    stage.stage3Ds[0].requestContext3D(Context3DRenderMode.AUTO);   
  }//init
  

  public function onError(e:ErrorEvent):void { trace("context error: ", e.text); cerr_msg = e.text; cerr = true; }
  public function contReady(e:Event):void
  {
    context = stage.stage3Ds[0].context3D;
    context.addEventListener(ErrorEvent.ERROR, onError);
    context.configureBackBuffer(scrWidth, scrHeight, 0, true);
    context.enableErrorChecking = true; // false; //set true for debug  false for speed
    initProgram(context);    
    context.setProgram(prog);
    cready = true;
    
    rectGeo = new xGeo();
    rectGeo.initPlane(1); rectGeo.upload(context);

    blankSkin = new xTex();
    var temp:BitmapData;
    temp = new BitmapData(64,64,true,0xFFffFFff);
      temp.perlinNoise(12,5,2,4,true,true,7, true);
    blankSkin.genTex(temp, context);

  }//contready 

  public function initProgram(c:Context3D):void
  { 
      prog = c.createProgram();
     
      var code:String;
      var vert:ByteArray;
      var frag:ByteArray;
      var assembler:AGALMiniAssembler = new AGALMiniAssembler();
          code = "";
    
           code += "m44 vt0, va0, vc4\n"; //pos * objmatrix
           code += "m44 op, vt0, vc0\n"; // * cammatrix
           code += "m44 v0, va1, vc8\n"  // uv*texture matrix to fragment    
           code += "mov v1, va2\n" // vertex color to fragment
           vert = assembler.assemble(Context3DProgramType.VERTEX, code);
    
          code = "";
          code += "tex ft0 v0, fs0 <2d, linear, miplinear, wrap>\n";
          code += "mul ft1, fc0, v1\n"; //color*vertex color
          code += "mul oc, ft1, ft0\n"; //texture * color
    
          frag = assembler.assemble(Context3DProgramType.FRAGMENT, code);

      prog.upload(vert, frag);
  }//initprogram 
  
  
   public static function setOrthoMatrix(m:Matrix3D,
   left:Number, right:Number, bottom:Number, top:Number, near:Number, far:Number):void   
   {
    var vec:Vector.<Number>;     var i:int;
    vec = m.rawData; for (i = 0; i < 16; i++) { vec[i] = 0.0;  } 
    vec[0] = 2.0 / (right - left);   vec[5] = 2.0 / (top - bottom);
    vec[10] = -2 / (far - near);     vec[12] = (right + left) / (left - right);
    vec[13] = (top + bottom) / (bottom - top);  vec[14] = (far + near) / (near - far);
    vec[15] = 1.0;   m.rawData = vec;
   }//setortho

  public var rectGeo:xGeo; 
  public var rectColor:Vector.<Number> = Vector.<Number>([1.0, 1.0, 1.0, 1.0]);
  public var rectUv:Matrix3D = new Matrix3D();
  public var rectTrans:Matrix3D = new Matrix3D(); 

  public function setCurTex(skin:xTex):void
  { context.setTextureAt(0, skin.tex); }
  
  public function setColor(r:Number=1.0, g:Number=1.0, b:Number=1.0, a:Number = 1.0):void
  {
    rectColor[0] = r; rectColor[1] = g; rectColor[2] = b; rectColor[3] = a;
    context.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, rectColor); 
  }//set2dcolor
  
  public function setUv(u0:Number = 0.0, v0:Number = 0.0, uw:Number = 1.0, vh:Number = 1.0):void
  {
    rectUv.identity();
      rectUv.appendScale(uw, vh, 1);
      rectUv.appendTranslation(u0, v0, 0);
    context.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 8, rectUv, true);
  }//set2duv
  
  public function drawRect(ax:Number, ay:Number, aw:Number, ah:Number):void
  { drawSprite(ax + aw * 0.5, ay + ah * 0.5, aw, ah, 0); }
   
  public function getMag(ax:Number, ay:Number):Number  { return Math.sqrt(ax * ax + ay * ay); }  
 
  public function drawLine(ax:Number, ay:Number, bx:Number, by:Number, w:Number):void
  {
    var a:Number; var d:Number;
    a = Math.atan2(ay - by, ax - bx);
    d = getMag(bx - ax, by - ay);    
    drawSprite(ax + Math.cos(a) * d * -0.5, ay + Math.sin(a) * d * -0.5, w, d, a+1.57);    
  }//draw2dline
  
  public function drawSprite(ax:Number, ay:Number, aw:Number, ah:Number, ang:Number=0):void
  { 
    var g:xGeo; g = rectGeo;
    var c:Context3D; c = context;
    
    rectTrans.identity();
     rectTrans.appendScale(aw, -ah, 1); //note the negative Y trick here
     if (ang!=0){rectTrans.appendRotation(ang * 57.29, Vector3D.Z_AXIS);}
     rectTrans.appendTranslation(ax, ay, 0); 
   
     c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 4, rectTrans, true);
     c.drawTriangles(g.bufFace, 0, g.numFace);
  }//draw2dsprite
  
  public function use2DMode(w:Number=640, h:Number=480):void
  { 
    var g:xGeo;    var c:Context3D;
     g = rectGeo; c = context;   
    context.setProgram(prog);
    setOrthoMatrix(projmat, 0, w, h, 0, 1000, -1000); 
    mat.identity();    mat.append(projmat);
      
    c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mat, true);   
    c.setCulling(Context3DTriangleFace.NONE);
    c.setDepthTest(false, Context3DCompareMode.ALWAYS);
    c.setBlendFactors(Context3DBlendFactor.SOURCE_ALPHA, Context3DBlendFactor.ONE_MINUS_SOURCE_ALPHA);
  
    setCurTex(blankSkin);
    setColor(1, 1, 1, 1);
    setUv(0, 0, 1, 1);
     
    //all rectangles use same buffer (uv set with texture matrix)
      c.setVertexBufferAt(0, g.bufVert, 0, Context3DVertexBufferFormat.FLOAT_3);    
      c.setVertexBufferAt(1, g.bufUv, 0, Context3DVertexBufferFormat.FLOAT_2);
      c.setVertexBufferAt(2, g.bufColor, 0, Context3DVertexBufferFormat.FLOAT_4);
  }//set2dmode
  
  

}//xminirender
  

internal class xGeo
{
    public var vecVert:Vector.<Number> ;    public var vecUv:Vector.<Number> ;    public var vecFace:Vector.<uint> ;
    public var vecColor:Vector.<Number>;
    public var bufVert:VertexBuffer3D;    public var bufUv:VertexBuffer3D;    
    public var bufColor:VertexBuffer3D;   public var bufFace:IndexBuffer3D;
    public var numVert:int=0;  public var numFace:int=0;

    public function upload(c:Context3D):void
    {
      if (bufVert != null) { bufVert.dispose(); }      if (bufUv != null) { bufUv.dispose(); }
      if (bufFace != null) { bufFace.dispose(); }      if (bufColor != null) { bufColor.dispose(); }
     
      numVert = Math.floor( vecVert.length / 3);     numFace = Math.floor( vecFace.length / 3);
      
      bufVert = c.createVertexBuffer(numVert, 3);      bufUv = c.createVertexBuffer(numVert, 2);
      bufColor = c.createVertexBuffer(numVert, 4);     bufFace = c.createIndexBuffer(numFace * 3);
      
      bufVert.uploadFromVector(vecVert, 0, numVert);
      bufUv.uploadFromVector(vecUv, 0, numVert);   
      bufColor.uploadFromVector(vecColor, 0, numVert);  
      bufFace.uploadFromVector(vecFace, 0, numFace * 3);
    }//upload  
    
     public function initPlane(s:Number = 1.0):void
    {
      var n:Number;            var pa:Number;
        n = -0.5 * s;            pa = 0.5 * s;
        numFace = 6;    numVert = 4; 
        vecFace  = Vector.<uint>([0, 1, 2,  2, 1, 3]);
        vecVert  = Vector.<Number>([ n,  n,  0,    pa,  n,  0,     n, pa,  0,    pa, pa,  0]);               
        vecUv = Vector.<Number>([0.0, 1.0,     1.0, 1.0,     0.0, 0.0,       1.0, 0.0]);        
        var i:int;      var num:int;
        num = numVert * 4;
        vecColor = new Vector.<Number>(num, false);
        for (i = 0; i < num; i++) { vecColor[i] = 1.0; }            
    }//iniplane

}//xgeo

  
internal class xTex
{
  public var tex:Texture = null;
  public static function getXor(w:int, h:int, red:Boolean=true,green:Boolean=true,blue:Boolean=true):BitmapData
  {
      var bm:BitmapData;        var k:int;        var i:int;      
      bm = new BitmapData(w,h,false,0);     
      for (i = 0; i < h; i++)  {   for (k = 0; k < w; k++)      {
      bm.setPixel(k,i, (red ? ((i^k)<<16):0) | (green ? ((i ^ k) << 8):0) | (blue ? (i^k):0));  }} 
      return bm;
  }//getxor
  
    private var tempMat:Matrix = new Matrix();
    public function genTex(bm:BitmapData, c:Context3D):void
    {
      var s:int;   var m:int;  var tmp:BitmapData;
      tex = c.createTexture(bm.width, bm.height, Context3DTextureFormat.BGRA, false);
      tex.uploadFromBitmapData( bm , 0);
      tempMat.identity();
      m = 1; s = bm.width * 0.5;
       while (s > 0)
       { 
        tempMat.a = s / bm.width;
        tempMat.d = s / bm.height;
        tmp = new BitmapData(s, s, bm.transparent, 0);
        tmp.draw(bm, tempMat, null, null, null, true);
        tex.uploadFromBitmapData(tmp, m); m += 1;  s *= 0.5; 
       }//wend
    }//gentex
    
};//classend xtex
  