/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ar3U
 */

package  
{
	import caurina.transitions.Tweener;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.geom.TriangleMesh3D;
	import org.papervision3d.core.math.NumberUV;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	import org.papervision3d.materials.WireframeMaterial;
	
	[SWF(width = "500", height = "500", backgroundColor = "0" )] 
	
	/**
	 * TriangleMesh3Dにてデジタル時計を作りました。
	 * というより、三角ポリゴンで数字になるようにデータを作成し、riangleMesh3Dにて再配置してみました。
	 * 「ActionScript3.0アニメーション」のp422に記述してあるように方眼紙を利用したモデリングは退屈な
	 * 作業だったので、これを補助するモデリング用フロントエンドツールをJavaにて作成を試みてみました。
	 * なんとか、平面のモデリングができるフロントエンドツールができたので、このツールを利用して作成した、
	 * 数字データを使用して、デジタル時計を作成してみました。（5と8はちょっと変だけど（汗））
	 * 現在、立体モデリング用のフロントエンドツールを構想中です。平面のモデリングは、平面の画像を読み込み
	 * トレースすることで、実現できるのですが、立体のモデリングとなると、奥行きがあるので、単純にはいきません。
	 * でも、なんとか、簡単に立体のモデリングができる方法がないか検討中です。 
	 */
	public class Clock extends BasicView
	{
		public var mesh_array:Array = new Array(10);
		private var uvA:NumberUV;
		private var uvC:NumberUV;
		private var uvB:NumberUV;
		private var v0:Vertex3D;
		private var v1:Vertex3D;
		private var v2:Vertex3D;
		private var meshface:Triangle3D;
		private var obj3D:DisplayObject3D ;
		private var bfm:BitmapEffectLayer;
		private var color_m:ColorMaterial;
		private var start_sw:Boolean = false;
		private var save_hh:int = 0;
		private var save_mm:int=0;
		private var save_ss:int = 0;
		private var hh_1_sw:Boolean = false;
		private var hh_2_sw:Boolean = false;
		private var mm_1_sw:Boolean = false;
		private var mm_2_sw:Boolean = false;
		private var ss_1_sw:Boolean = false;
		private var ss_2_sw:Boolean = false;
		private var angle:Number = 0;
		private var coltrans:ColorTransform;
		
		public function Clock() 
		{ 
			super(500, 500, false, false);
			camera.z = -400;
			obj3D = new DisplayObject3D();
			scene.addChild(obj3D);
			Num_data.init_number();
			init_mesh();
			ss_1(0);
			ss_2(0);
			mm_1(0);
			mm_2(0);
			hh_1(0);
			hh_2(0);
			coltrans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
			startRendering();
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		public function init_mesh():void {
			bfm = new BitmapEffectLayer(viewport, 500, 500, true, 0, "clear_pre", false, false );
			bfm.addEffect(new BitmapLayerEffect(new BlurFilter(3, 3, 5), false));
			color_m = new ColorMaterial(0xFFFFFF);
			color_m.doubleSided = true;
			var wire:WireframeMaterial = new WireframeMaterial(0xFFFFFF, 1);
			wire.doubleSided = true;
			viewport.containerSprite.addLayer(bfm);
			for (var j:Number = 0; j < mesh_array.length;j++){
				mesh_array[j] = new Array(Num_data.max_num);
				for (var i:Number = 0; i < Num_data.max_num ; i++) {
					mesh_array[j][i] = new TriangleMesh3D(wire, new Array(), new Array(), null );
					v0 = new Vertex3D( -300, 300, 0 );
					v1 = new Vertex3D( -300, 300, 0 );
					v2 = new Vertex3D( -300, 300, 0 );
					mesh_array[j][i].geometry.vertices.push( v0 );
					mesh_array[j][i].geometry.vertices.push( v1 );
					mesh_array[j][i].geometry.vertices.push( v2 );
					uvA = new NumberUV( 0, 0 );
					uvC = new NumberUV( 1, 0 );
					uvB = new NumberUV( 0, 1 );
					mesh_array[j][i].geometry.faces.push( new Triangle3D( mesh_array[j][i], new Array(v0,v1,v2), null, new Array(uvA,uvC,uvB) ));
					mesh_array[j][i].geometry.ready = true;
					obj3D.addChild(mesh_array[j][i]);
//					bfm.addDisplayObject3D(mesh_array[j][i]);
				}
			}
		}
		private function ss_1(num:Number):void {
			trace(num);
			ss_1_sw = true;
			for (var i:Number = 0; i < Num_data.second_1[num].length; i++) {
				for (var j:Number = 0; j < Num_data.second_1[num][i].length; j++ ) {
					for (var n:Number = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[4][i].geometry.vertices[n], { x: Num_data.second_1[num][i][n].x,
																				  y: Num_data.second_1[num][i][n].y,
																				  z: Num_data.second_1[num][i][n].z,
																				  delay:i*.02,
																				  time:0.2,
																				  transition:"easeInOutCubic" } );
					}													   
				}				
			}
			Tweener.addTween(this, { delay:i * .03, onComplete:end_ss1 } );
			mesh_save(4, i);
		}
		private function ss_2(num:Number):void {
			ss_2_sw = true;
			for (var i:Number = 0; i < Num_data.second_2[num].length; i++) {
				for (var j:Number = 0; j < Num_data.second_2[num][i].length; j++ ) {
					for (var n:Number = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[5][i].geometry.vertices[n], { x: Num_data.second_2[num][i][n].x,
																				  y: Num_data.second_2[num][i][n].y,
																				  z: Num_data.second_2[num][i][n].z,
																				  delay:i*.02,
																				  time:0.2,
																				  transition:"easeInOutCubic" } );
					}													   
				}				
			}
			Tweener.addTween(this, { delay:i * .03, onComplete:end_ss2 } );
			mesh_save(5, i);
		}
		private function mm_1(num:Number):void {
//			trace(num);
			mm_1_sw = true;
			for (var i:Number = 0; i < Num_data.min_1[num].length; i++) {
				for (var j:Number = 0; j < Num_data.min_1[num][i].length; j++ ) {
					for (var n:Number = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[2][i].geometry.vertices[n], { x: Num_data.min_1[num][i][n].x,
																				  y: Num_data.min_1[num][i][n].y,
																				  z: Num_data.min_1[num][i][n].z,
																				  delay:i*.02,
																				  time:0.2,
																				  transition:"easeInOutCubic" } );
					}													   
				}				
			}
			Tweener.addTween(this, { delay:i * .03, onComplete:end_mm1 } );
			mesh_save(2, i);
		}
		private function mm_2(num:Number):void {
			mm_2_sw = true;
			for (var i:Number = 0; i < Num_data.min_2[num].length; i++) {
				for (var j:Number = 0; j < Num_data.min_2[num][i].length; j++ ) {
					for (var n:Number = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[3][i].geometry.vertices[n], { x: Num_data.min_2[num][i][n].x,
																				  y: Num_data.min_2[num][i][n].y,
																				  z: Num_data.min_2[num][i][n].z,
																				  delay:i*.02,
																				  time:0.2,
																				  transition:"easeInOutCubic" } );
					}													   
				}				
			}
			Tweener.addTween(this, { delay:i * .03, onComplete:end_mm2 } );
			mesh_save(3, i);
		}
		private function hh_1(num:Number):void {
			hh_1_sw = true;
			for (var i:Number = 0; i < Num_data.hour_1[num].length; i++) {
				for (var j:Number = 0; j < Num_data.hour_1[num][i].length; j++ ) {
					for (var n:Number = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[0][i].geometry.vertices[n], { x: Num_data.hour_1[num][i][n].x,
																				  y: Num_data.hour_1[num][i][n].y,
																				  z: Num_data.hour_1[num][i][n].z,
																				  delay:i*.02,
																				  time:0.2,
																				  transition:"easeInOutCubic" } );
					}													   
				}				
			}
			Tweener.addTween(this, { delay:i * .03, onComplete:end_hh1 } );
			mesh_save(0, i);
		}
		private function hh_2(num:Number):void {
			hh_2_sw = true;
			for (var i:Number = 0; i < Num_data.hour_2[num].length; i++) {
				for (var j:Number = 0; j < Num_data.hour_2[num][i].length; j++ ) {
					for (var n:Number = 0; n < 3; n++) {
						Tweener.addTween(mesh_array[1][i].geometry.vertices[n], { x: Num_data.hour_2[num][i][n].x,
																				  y: Num_data.hour_2[num][i][n].y,
																				  z: Num_data.hour_2[num][i][n].z,
																				  delay:i*.02,
																				  time:0.2,
																				  transition:"easeInOutCubic" } );
					}													   
				}				
			}
			Tweener.addTween(this, { delay:i * .03, onComplete:on_start } );
			mesh_save(1, i);
		}
		private function on_start():void {
			if (!start_sw) start_sw = true;
			hh_2_sw = false;
		}
		private function end_hh1():void {
			hh_1_sw = false;
		}
		private function end_mm1():void {
			mm_1_sw = false;
		}
		private function end_mm2():void {
			mm_2_sw = false;
		}
		private function end_ss1():void {
			ss_1_sw = false;
		}
		private function end_ss2():void {
			ss_2_sw = false;
		}
		private function mesh_save(tm:Number , tria_no:Number):void {
			for ( var i:Number = tria_no; i < Num_data.max_num; i++ ){
				for (var n:Number=0; n < 3; n++) {
					mesh_array[tm][i].geometry.vertices[n].x = -300;
					mesh_array[tm][i].geometry.vertices[n].y = 300;
					mesh_array[tm][i].geometry.vertices[n].z = 0;
				}
			}
		}
		private function onLoop(evet:Event):void {
			var nowDate :Date = new Date();
			if (start_sw) {
			    obj3D.rotationY += 1;
				obj3D.rotationX += 1;
				var hh:Number = nowDate.getHours();
				var mm:Number = nowDate.getMinutes();
				var ss:Number = nowDate.getSeconds();
				if (save_hh != hh) {
					if (!hh_1_sw) {
						hh_1(int(hh / 10));
					}
					if (!hh_2_sw) {
						hh_2(int(hh % 10 ));
					}
				}
				if (save_mm != mm) {
					if (!mm_1_sw) {
						mm_1(int(mm / 10));
					}
					if (!mm_2_sw) {
						mm_2(int(mm % 10 ));
					}
				}
				if (save_ss != ss) {
					if (!ss_1_sw) {
						ss_1(int(ss / 10));
					}
					if (!ss_2_sw) {
						ss_2(int(ss % 10 ));
					}
				}
				save_hh = hh;
				save_mm = mm;
				save_ss = ss;
				angle+=.01;
				var sin:Number = Math.sin(angle)
				var cos:Number = Math.cos(angle)
				if (sin < .1) sin = Math.abs(sin)+.1;
				if (cos < .1) cos = Math.abs(cos)+.1;
			
				coltrans.redMultiplier = sin/4;
				coltrans.greenMultiplier = cos/2;
				coltrans.blueMultiplier = sin;
			 
				bfm.drawCommand.colorTransform = coltrans;
			}
		}
	}

}
	import org.papervision3d.core.geom.renderables.Vertex3D;
	
	/**
	 * ...
	 * @author ...
	 */
	class Num_data
	{
		public static const num_data:Array = [
								[
									[[-43,4,0],[-75,23,0],[-75,6,0]],
									[[-43,4,0],[-43,21,0],[-75,23,0]],
									[[-75,23,0],[-43,21,0],[-73,43,0]],
									[[-43,21,0],[-41,37,0],[-73,43,0]],
									[[-73,43,0],[-41,37,0],[-69,60,0]],
									[[-69,60,0],[-41,37,0],[-39,50,0]],
									[[-69,60,0],[-39,50,0],[-36,65,0]],
									[[-36,65,0],[-64,78,0],[-69,60,0]],
									[[-64,78,0],[-36,65,0],[-32,77,0]],
									[[-32,77,0],[-57,95,0],[-64,78,0]],
									[[-32,77,0],[-23,97,0],[-57,95,0]],
									[[-57,95,0],[-23,97,0],[-50,108,0]],
									[[-50,108,0],[-23,97,0],[-40,120,0]],
									[[-23,97,0],[-11,110,0],[-40,120,0]],
									[[-40,120,0],[-11,110,0],[-31,129,0]],
									[[-31,129,0],[-11,110,0],[-21,137,0]],
									[[-21,137,0],[-11,110,0],[1,114,0]],
									[[1,114,0],[-11,141,0],[-21,137,0]],
									[[1,114,0],[1,142,0],[-11,141,0]],
									[[1,114,0],[11,141,0],[1,142,0]],
									[[11,141,0],[1,114,0],[7,113,0]],
									[[7,113,0],[21,137,0],[11,141,0]],
									[[21,137,0],[7,113,0],[19,105,0]],
									[[19,105,0],[32,130,0],[21,137,0]],
									[[32,130,0],[19,105,0],[41,122,0]],
									[[41,122,0],[19,105,0],[24,98,0]],
									[[24,98,0],[51,110,0],[41,122,0]],
									[[51,110,0],[24,98,0],[29,89,0]],
									[[29,89,0],[58,97,0],[51,110,0]],
									[[58,97,0],[29,89,0],[34,79,0]],
									[[34,79,0],[65,81,0],[58,97,0]],
									[[65,81,0],[34,79,0],[38,66,0]],
									[[38,66,0],[71,63,0],[65,81,0]],
									[[71,63,0],[38,66,0],[41,52,0]],
									[[41,52,0],[74,46,0],[71,63,0]],
									[[74,46,0],[41,52,0],[43,39,0]],
									[[43,39,0],[76,28,0],[74,46,0]],
									[[76,28,0],[43,39,0],[45,23,0]],
									[[45,23,0],[77,7,0],[76,28,0]],
									[[77,7,0],[45,23,0],[45,9,0]],
									[[45,9,0],[77,-12,0],[77,7,0]],
									[[77,-12,0],[45,9,0],[44,-16,0]],
									[[44,-16,0],[75,-30,0],[77,-12,0]],
									[[75,-30,0],[44,-16,0],[41,-35,0]],
									[[41,-35,0],[71,-49,0],[75,-30,0]],
									[[71,-49,0],[41,-35,0],[38,-49,0]],
									[[38,-49,0],[65,-68,0],[71,-49,0]],
									[[65,-68,0],[38,-49,0],[34,-61,0]],
									[[34,-61,0],[59,-82,0],[65,-68,0]],
									[[59,-82,0],[34,-61,0],[30,-72,0]],
									[[30,-72,0],[51,-97,0],[59,-82,0]],
									[[51,-97,0],[30,-72,0],[19,-89,0]],
									[[19,-89,0],[43,-108,0],[51,-97,0]],
									[[19,-89,0],[33,-118,0],[43,-108,0]],
									[[19,-89,0],[23,-124,0],[33,-118,0]],
									[[23,-124,0],[19,-89,0],[7,-97,0]],
									[[7,-97,0],[12,-129,0],[23,-124,0]],
									[[12,-129,0],[7,-97,0],[1,-99,0]],
									[[1,-99,0],[1,-131,0],[12,-129,0]],
									[[1,-131,0],[1,-99,0],[-9,-129,0]],
									[[1,-99,0],[-20,-125,0],[-9,-129,0]],
									[[-20,-125,0],[1,-99,0],[-11,-94,0]],
									[[-11,-94,0],[-30,-119,0],[-20,-125,0]],
									[[-30,-119,0],[-11,-94,0],[-40,-109,0]],
									[[-40,-109,0],[-11,-94,0],[-22,-82,0]],
									[[-22,-82,0],[-48,-98,0],[-40,-109,0]],
									[[-48,-98,0],[-22,-82,0],[-56,-84,0]],
									[[-22,-82,0],[-32,-62,0],[-56,-84,0]],
									[[-56,-84,0],[-32,-62,0],[-63,-70,0]],
									[[-32,-62,0],[-38,-40,0],[-63,-70,0]],
									[[-63,-70,0],[-38,-40,0],[-68,-52,0]],
									[[-38,-40,0],[-72,-32,0],[-68,-52,0]],
									[[-72,-32,0],[-38,-40,0],[-40,-27,0]],
									[[-40,-27,0],[-75,-15,0],[-72,-32,0]],
									[[-75,-15,0],[-40,-27,0],[-42,-10,0]],
									[[-42,-10,0],[-75,6,0],[-75,-15,0]],
									[[-75,6,0],[-42,-10,0],[-43,4,0]]
		
								],
		
								[
									[[-10,87,0],[-10,-128,0],[22,87,0]],
									[[-10,-128,0],[22,-128,0],[22,87,0]],
									[[-52,105,0],[-52,87,0],[-11,87,0]],
									[[-52,105,0],[-11,87,0],[-36,105,0]],
									[[-36,105,0],[-11,87,0],[-23,109,0]],
									[[-23,109,0],[-11,87,0],[-12,115,0]],
									[[-12,115,0],[-11,87,0],[-1,126,0]],
									[[-1,126,0],[-11,87,0],[22,87,0]],
									[[-1,126,0],[22,87,0],[5,144,0]],
									[[5,144,0],[22,87,0],[22,144,0]]	
								],
		
	
								[
									[[-34,57,0],[-35,70,0],[-61,57,0]],
									[[-35,70,0],[-64,72,0],[-61,57,0]],
									[[-64,72,0],[-35,70,0],[-61,91,0]],
									[[-35,70,0],[-34,83,0],[-61,91,0]],
									[[-61,91,0],[-34,83,0],[-27,101,0]],
									[[-27,101,0],[-54,110,0],[-61,91,0]],
									[[-54,110,0],[-27,101,0],[-19,109,0]],
									[[-19,109,0],[-42,126,0],[-54,110,0]],
									[[-19,109,0],[-34,132,0],[-42,126,0]],
									[[-34,132,0],[-19,109,0],[-9,115,0]],
									[[-9,115,0],[-17,141,0],[-34,132,0]],
									[[-9,115,0],[-8,143,0],[-17,141,0]],
									[[-8,143,0],[-9,115,0],[6,117,0]],
									[[6,117,0],[11,143,0],[-8,143,0]],
									[[6,117,0],[29,138,0],[11,143,0]],
									[[29,138,0],[6,117,0],[16,113,0]],
									[[16,113,0],[45,127,0],[29,138,0]],
									[[45,127,0],[16,113,0],[25,106,0]],
									[[25,106,0],[57,111,0],[45,127,0]],
									[[57,111,0],[25,106,0],[31,96,0]],
									[[31,96,0],[62,102,0],[57,111,0]],
									[[62,102,0],[31,96,0],[34,89,0]],
									[[34,89,0],[67,82,0],[62,102,0]],
									[[67,82,0],[34,89,0],[37,76,0]],
									[[37,76,0],[67,63,0],[67,82,0]],
									[[67,63,0],[37,76,0],[37,64,0]],
									[[37,64,0],[64,43,0],[67,63,0]],
									[[64,43,0],[37,64,0],[32,45,0]],
									[[32,45,0],[24,27,0],[58,25,0]],
									[[58,25,0],[24,27,0],[43,2,0]],
									[[24,27,0],[8,5,0],[43,2,0]],
									[[8,5,0],[-38,-51,0],[43,2,0]],
									[[43,2,0],[-38,-51,0],[-12,-66,0]],
									[[-12,-66,0],[-38,-51,0],[-70,-104,0]],
									[[-70,-104,0],[-37,-104,0],[-12,-66,0]],
									[[-70,-104,0],[-70,-131,0],[-37,-104,0]],
									[[-37,-104,0],[-70,-131,0],[-37,-131,0]],
									[[-37,-131,0],[71,-131,0],[-37,-104,0]],
									[[-37,-104,0],[71,-131,0],[71,-104,0]],
									[[64,43,0],[32,45,0],[58,25,0]]
								],
								[
									[[-35,70,0],[-65,85,0],[-65,70,0]],
									[[-35,70,0],[-34,84,0],[-65,85,0]],
									[[-65,85,0],[-34,84,0],[-60,104,0]],
									[[-34,84,0],[-26,102,0],[-60,104,0]],
									[[-60,104,0],[-26,102,0],[-50,121,0]],
									[[-26,102,0],[-19,111,0],[-50,121,0]],
									[[-50,121,0],[-19,111,0],[-36,134,0]],
									[[-19,111,0],[-10,116,0],[-36,134,0]],
									[[-36,134,0],[-10,116,0],[-19,142,0]],
									[[-10,116,0],[0,118,0],[-19,142,0]],
									[[-19,142,0],[0,118,0],[0,145,0]],
									[[0,118,0],[18,142,0],[0,145,0]],
									[[18,142,0],[0,118,0],[14,114,0]],
									[[14,114,0],[27,139,0],[18,142,0]],
									[[14,114,0],[43,129,0],[27,139,0]],
									[[43,129,0],[14,114,0],[23,107,0]],
									[[23,107,0],[55,114,0],[43,129,0]],
									[[55,114,0],[23,107,0],[32,91,0]],
									[[32,91,0],[60,105,0],[55,114,0]],
									[[32,91,0],[65,86,0],[60,105,0]],
									[[65,86,0],[32,91,0],[35,78,0]],
									[[35,78,0],[66,77,0],[65,86,0]],
									[[35,78,0],[65,68,0],[66,77,0]],
									[[65,68,0],[35,78,0],[35,66,0]],
									[[35,66,0],[64,59,0],[65,68,0]],
									[[35,66,0],[60,50,0],[64,59,0]],
									[[60,50,0],[35,66,0],[32,54,0]],
									[[32,54,0],[55,40,0],[60,50,0]],
									[[55,40,0],[32,54,0],[29,47,0]],
									[[29,47,0],[50,33,0],[55,40,0]],
									[[29,47,0],[43,26,0],[50,33,0]],
									[[43,26,0],[29,47,0],[23,37,0]],
									[[23,37,0],[36,20,0],[43,26,0]],
									[[36,20,0],[23,37,0],[14,30,0]],
									[[14,30,0],[27,15,0],[36,20,0]],
									[[27,15,0],[14,30,0],[0,26,0]],
									[[27,15,0],[0,26,0],[-11,22,0]],
									[[27,15,0],[-11,22,0],[-11,-2,0]],
									[[-11,-2,0],[5,-3,0],[27,15,0]],
									[[27,15,0],[5,-3,0],[17,-7,0]],
									[[27,15,0],[17,-7,0],[37,4,0]],
									[[37,4,0],[17,-7,0],[26,-15,0]],
									[[26,-15,0],[46,-2,0],[37,4,0]],
									[[46,-2,0],[26,-15,0],[34,-25,0]],
									[[34,-25,0],[53,-9,0],[46,-2,0]],
									[[53,-9,0],[34,-25,0],[59,-18,0]],
									[[34,-25,0],[39,-38,0],[59,-18,0]],
									[[59,-18,0],[39,-38,0],[64,-27,0]],
									[[39,-38,0],[68,-36,0],[64,-27,0]],
									[[39,-38,0],[41,-58,0],[68,-36,0]],
									[[68,-36,0],[41,-58,0],[71,-57,0]],
									[[41,-58,0],[68,-76,0],[71,-57,0]],
									[[68,-76,0],[41,-58,0],[37,-72,0]],
									[[37,-72,0],[65,-86,0],[68,-76,0]],
									[[37,-72,0],[60,-96,0],[65,-86,0]],
									[[60,-96,0],[37,-72,0],[27,-89,0]],
									[[27,-89,0],[46,-112,0],[60,-96,0]],
									[[27,-89,0],[38,-117,0],[46,-112,0]],
									[[38,-117,0],[27,-89,0],[17,-97,0]],
									[[17,-97,0],[29,-123,0],[38,-117,0]],
									[[17,-97,0],[20,-126,0],[29,-123,0]],
									[[20,-126,0],[17,-97,0],[6,-101,0]],
									[[6,-101,0],[9,-129,0],[20,-126,0]],
									[[6,-101,0],[-1,-130,0],[9,-129,0]],
									[[6,-101,0],[0,-102,0],[-1,-130,0]],
									[[0,-102,0],[-10,-129,0],[-1,-130,0]],
									[[-10,-129,0],[0,-102,0],[-11,-100,0]],
									[[-11,-100,0],[-21,-127,0],[-10,-129,0]],
									[[-21,-127,0],[-11,-100,0],[-30,-123,0]],
									[[-30,-123,0],[-11,-100,0],[-22,-94,0]],
									[[-22,-94,0],[-39,-118,0],[-30,-123,0]],
									[[-22,-94,0],[-47,-112,0],[-39,-118,0]],
									[[-47,-112,0],[-22,-94,0],[-31,-85,0]],
									[[-31,-85,0],[-61,-97,0],[-47,-112,0]],
									[[-61,-97,0],[-31,-85,0],[-37,-73,0]],
									[[-37,-73,0],[-66,-87,0],[-61,-97,0]],
									[[-66,-87,0],[-37,-73,0],[-70,-77,0]],
									[[-37,-73,0],[-73,-57,0],[-70,-77,0]],
									[[-73,-57,0],[-37,-73,0],[-41,-59,0]],
									[[-41,-59,0],[-41,-48,0],[-73,-57,0]],
									[[-41,-48,0],[-72,-48,0],[-73,-57,0]]
								],
								[
									[[-75,-38,0],[-43,-38,0],[16,82,0]],
									[[16,82,0],[-14,82,0],[-75,-38,0]],
									[[16,143,0],[-14,82,0],[16,82,0]],
									[[16,143,0],[16,-38,0],[50,143,0]],
									[[16,-38,0],[50,-38,0],[50,143,0]],
									[[-75,-38,0],[80,-64,0],[80,-38,0]],
									[[80,-64,0],[-75,-38,0],[-75,-64,0]],
									[[16,-64,0],[16,-129,0],[50,-129,0]],
									[[16,-64,0],[50,-129,0],[50,-64,0]]
								],
								[
									[[-54,143,0],[66,115,0],[66,143,0]],
									[[66,115,0],[-54,143,0],[-30,116,0]],
									[[-64,-8,0],[-30,116,0],[-54,143,0]],
									[[-32,35,0],[-64,-8,0],[-35,-8,0]],
									[[-32,35,0],[-35,-8,0],[-31,-1,0]],
									[[-32,35,0],[-35,-8,0],[-27,5,0]],
									[[-32,35,0],[-27,5,0],[-22,11,0]],
									[[-32,35,0],[-22,11,0],[-19,41,0]],
									[[-19,41,0],[-22,11,0],[-11,18,0]],
									[[-11,18,0],[-10,43,0],[-19,41,0]],
									[[-10,43,0],[-11,18,0],[0,20,0]],
									[[0,20,0],[1,44,0],[-10,43,0]],
									[[0,20,0],[11,18,0],[1,44,0]],
									[[11,18,0],[20,41,0],[1,44,0]],
									[[20,41,0],[11,18,0],[30,37,0]],
									[[11,18,0],[21,11,0],[30,37,0]],
									[[30,37,0],[21,11,0],[47,23,0]],
									[[47,23,0],[21,11,0],[30,0,0]],
									[[30,0,0],[61,5,0],[47,23,0]],
									[[61,5,0],[30,0,0],[37,-16,0]],
									[[37,-16,0],[69,-18,0],[61,5,0]],
									[[69,-18,0],[37,-16,0],[41,-32,0]],
									[[41,-32,0],[72,-42,0],[69,-18,0]],
									[[41,-32,0],[41,-49,0],[72,-42,0]],
									[[41,-49,0],[70,-66,0],[72,-42,0]],
									[[70,-66,0],[41,-49,0],[37,-66,0]],
									[[37,-66,0],[61,-90,0],[70,-66,0]],
									[[61,-90,0],[37,-66,0],[31,-81,0]],
									[[31,-81,0],[48,-109,0],[61,-90,0]],
									[[31,-81,0],[17,-97,0],[48,-109,0]],
									[[17,-97,0],[31,-122,0],[48,-109,0]],
									[[17,-97,0],[22,-127,0],[31,-122,0]],
									[[22,-127,0],[17,-97,0],[6,-102,0]],
									[[6,-102,0],[11,-130,0],[22,-127,0]],
									[[6,-102,0],[1,-131,0],[11,-130,0]],
									[[6,-102,0],[-11,-100,0],[1,-131,0]],
									[[-11,-100,0],[-19,-127,0],[1,-131,0]],
									[[-19,-127,0],[-11,-100,0],[-37,-117,0]],
									[[-11,-100,0],[-22,-93,0],[-37,-117,0]],
									[[-37,-117,0],[-22,-93,0],[-53,-101,0]],
									[[-22,-93,0],[-31,-81,0],[-53,-101,0]],
									[[-53,-101,0],[-31,-81,0],[-64,-80,0]],
									[[-31,-81,0],[-37,-67,0],[-64,-80,0]],
									[[-64,-80,0],[-37,-67,0],[-68,-67,0]],
									[[-37,-67,0],[-70,-56,0],[-68,-67,0]],
									[[-70,-56,0],[-37,-67,0],[-39,-56,0]],
									[[-32,35,0],[-30,116,0],[-64,-8,0]]
								],
								[
									[[6,-103,0],[5,-131,0],[15,-130,0]],
									[[6,-103,0],[15,-130,0],[17,-100,0]],
									[[15,-130,0],[25,-127,0],[17,-100,0]],
									[[17,-100,0],[25,-127,0],[34,-122,0]],
									[[17,-100,0],[34,-122,0],[27,-92,0]],
									[[34,-122,0],[43,-115,0],[27,-92,0]],
									[[27,-92,0],[43,-115,0],[50,-109,0]],
									[[27,-92,0],[50,-109,0],[35,-81,0]],
									[[50,-109,0],[57,-99,0],[35,-81,0]],
									[[35,-81,0],[57,-99,0],[62,-90,0]],
									[[35,-81,0],[62,-90,0],[67,-78,0]],
									[[67,-78,0],[41,-66,0],[35,-81,0]],
									[[41,-66,0],[67,-78,0],[71,-66,0]],
									[[71,-66,0],[44,-50,0],[41,-66,0]],
									[[44,-50,0],[71,-66,0],[72,-55,0]],
									[[44,-50,0],[72,-55,0],[73,-42,0]],
									[[73,-42,0],[44,-34,0],[44,-50,0]],
									[[44,-34,0],[73,-42,0],[72,-31,0]],
									[[44,-34,0],[72,-31,0],[70,-18,0]],
									[[70,-18,0],[43,-25,0],[44,-34,0]],
									[[43,-25,0],[70,-18,0],[67,-7,0]],
									[[67,-7,0],[38,-9,0],[43,-25,0]],
									[[38,-9,0],[67,-7,0],[62,5,0]],
									[[62,5,0],[31,4,0],[38,-9,0]],
									[[31,4,0],[62,5,0],[56,15,0]],
									[[31,4,0],[56,15,0],[49,23,0]],
									[[49,23,0],[22,13,0],[31,4,0]],
									[[22,13,0],[49,23,0],[41,31,0]],
									[[22,13,0],[41,31,0],[33,37,0]],
									[[33,37,0],[11,18,0],[22,13,0]],
									[[11,18,0],[33,37,0],[23,41,0]],
									[[11,18,0],[23,41,0],[14,44,0]],
									[[14,44,0],[-1,17,0],[11,18,0]],
									[[-1,17,0],[14,44,0],[5,44,0]],
									[[-1,17,0],[5,44,0],[-5,43,0]],
									[[-1,17,0],[-5,43,0],[-15,40,0]],
									[[-15,40,0],[-10,13,0],[-1,17,0]],
									[[-10,13,0],[-15,40,0],[-24,36,0]],
									[[-10,13,0],[-24,36,0],[-34,31,0]],
									[[-34,31,0],[-19,3,0],[-10,13,0]],
									[[-19,3,0],[-34,31,0],[-40,22,0]],
									[[-19,3,0],[-40,22,0],[-46,14,0]],
									[[-46,14,0],[-27,-10,0],[-19,3,0]],
									[[-27,-10,0],[-46,14,0],[-52,3,0]],
									[[-27,-10,0],[-52,3,0],[-57,-8,0]],
									[[-57,-8,0],[-31,-26,0],[-27,-10,0]],
									[[-31,-26,0],[-57,-8,0],[-60,-19,0]],
									[[-31,-26,0],[-60,-19,0],[-62,-32,0]],
									[[-62,-32,0],[-32,-42,0],[-31,-26,0]],
									[[-32,-42,0],[-62,-32,0],[-63,-43,0]],
									[[-63,-43,0],[-31,-59,0],[-32,-42,0]],
									[[-31,-59,0],[-63,-43,0],[-64,-52,0]],
									[[-64,-52,0],[-60,-67,0],[-31,-59,0]],
									[[-31,-59,0],[-60,-67,0],[-55,-83,0]],
									[[-55,-83,0],[-29,-67,0],[-31,-59,0]],
									[[-55,-83,0],[-26,-76,0],[-29,-67,0]],
									[[-26,-76,0],[-55,-83,0],[-46,-101,0]],
									[[-46,-101,0],[-19,-88,0],[-26,-76,0]],
									[[-19,-88,0],[-46,-101,0],[-39,-110,0]],
									[[-19,-88,0],[-39,-110,0],[-30,-118,0]],
									[[-30,-118,0],[-9,-97,0],[-19,-88,0]],
									[[-9,-97,0],[-30,-118,0],[-22,-123,0]],
									[[-4,-100,0],[-9,-97,0],[-22,-123,0]],
									[[-4,-100,0],[-22,-123,0],[-12,-127,0]],
									[[-4,-100,0],[5,-131,0],[6,-103,0]],
									[[-4,-100,0],[-12,-127,0],[5,-131,0]],
									[[38,81,0],[70,81,0],[68,93,0]],
									[[68,93,0],[38,92,0],[38,81,0]],
									[[38,92,0],[68,93,0],[63,107,0]],
									[[63,107,0],[34,103,0],[38,92,0]],
									[[34,103,0],[63,107,0],[57,120,0]],
									[[34,103,0],[57,120,0],[47,131,0]],
									[[47,131,0],[30,109,0],[34,103,0]],
									[[30,109,0],[47,131,0],[34,140,0]],
									[[30,109,0],[34,140,0],[21,114,0]],
									[[21,114,0],[34,140,0],[18,144,0]],
									[[18,144,0],[9,116,0],[21,114,0]],
									[[9,116,0],[18,144,0],[2,143,0]],
									[[2,143,0],[1,112,0],[9,116,0]],
									[[1,112,0],[2,143,0],[-9,138,0]],
									[[1,112,0],[-9,138,0],[-24,128,0]],
									[[-24,128,0],[-5,107,0],[1,112,0]],
									[[-5,107,0],[-24,128,0],[-36,115,0]],
									[[-36,115,0],[-11,99,0],[1,112,0]],
									[[-11,99,0],[-36,115,0],[-46,103,0]],
									[[-46,103,0],[-17,89,0],[-11,99,0]],
									[[-17,89,0],[-46,103,0],[-52,89,0]],
									[[-52,89,0],[-23,76,0],[-17,89,0]],
									[[-23,76,0],[-52,89,0],[-58,73,0]],
									[[-58,73,0],[-28,62,0],[-23,76,0]],
									[[-28,62,0],[-58,73,0],[-63,56,0]],
									[[-63,56,0],[-32,47,0],[-28,62,0]],
									[[-32,47,0],[-63,56,0],[-67,32,0]],
									[[-32,47,0],[-67,32,0],[-34,31,0]],
									[[-34,31,0],[-67,32,0],[-67,1,0]],
									[[-34,31,0],[-67,1,0],[-67,-17,0]],
									[[-34,31,0],[-67,-17,0],[-60,-67,0]]
								],
								[
									[[-65,142,0],[68,115,0],[70,142,0]],
									[[68,115,0],[-65,142,0],[-65,116,0]],
									[[39,114,0],[-30,-131,0],[2,-132,0]],
									[[39,115,0],[2,-132,0],[68,115,0]]
								],
								[
									[[6,117,0],[10,142,0],[1,142,0]],
									[[1,142,0],[-4,117,0],[6,117,0]],
									[[-4,117,0],[1,142,0],[-9,142,0]],
									[[-4,117,0],[-9,142,0],[-18,140,0]],
									[[-18,140,0],[-14,113,0],[-4,117,0]],
									[[-14,113,0],[-18,140,0],[-27,136,0]],
									[[-14,113,0],[-27,136,0],[-35,131,0]],
									[[-35,131,0],[-23,105,0],[-14,113,0]],
									[[-23,105,0],[-35,131,0],[-43,125,0]],
									[[-23,105,0],[-43,125,0],[-49,118,0]],
									[[-23,105,0],[-49,118,0],[-29,95,0]],
									[[-29,95,0],[-49,118,0],[-55,109,0]],
									[[-29,95,0],[-55,109,0],[-59,100,0]],
									[[-59,100,0],[-34,82,0],[-29,95,0]],
									[[-34,82,0],[-59,100,0],[-62,92,0]],
									[[-34,82,0],[-62,92,0],[-64,81,0]],
									[[-64,81,0],[-35,69,0],[-34,82,0]],
									[[-35,69,0],[-64,81,0],[-64,63,0]],
									[[-64,63,0],[-34,56,0],[-35,69,0]],
									[[-34,56,0],[-64,63,0],[-59,44,0]],
									[[-59,44,0],[-32,49,0],[-34,56,0]],
									[[-32,49,0],[-59,44,0],[-48,27,0]],
									[[-48,27,0],[-26,37,0],[-32,49,0]],
									[[-26,37,0],[-48,27,0],[-34,14,0]],
									[[-34,14,0],[-18,28,0],[-26,37,0]],
									[[-18,28,0],[-34,14,0],[-22,8,0]],
									[[-18,28,0],[-22,8,0],[-9,22,0]],
									[[-9,22,0],[-22,8,0],[-7,4,0]],
									[[-7,4,0],[1,20,0],[-9,22,0]],
									[[1,20,0],[-7,4,0],[10,4,0]],
									[[10,4,0],[16,25,0],[1,20,0]],
									[[16,25,0],[10,4,0],[28,10,0]],
									[[28,10,0],[24,33,0],[16,25,0]],
									[[24,33,0],[28,10,0],[40,17,0]],
									[[24,33,0],[40,17,0],[51,28,0]],
									[[51,28,0],[31,43,0],[24,33,0]],
									[[31,43,0],[51,28,0],[58,38,0]],
									[[58,38,0],[36,56,0],[31,43,0]],
									[[36,56,0],[58,38,0],[65,55,0]],
									[[36,56,0],[65,55,0],[67,73,0]],
									[[67,73,0],[37,69,0],[36,56,0]],
									[[37,69,0],[67,73,0],[66,84,0]],
									[[37,69,0],[66,84,0],[35,83,0]],
									[[35,83,0],[66,84,0],[61,102,0]],
									[[35,83,0],[61,102,0],[31,95,0]],
									[[31,95,0],[61,102,0],[55,112,0]],
									[[55,112,0],[24,106,0],[31,95,0]],
									[[24,106,0],[55,112,0],[44,126,0]],
									[[24,106,0],[44,126,0],[36,132,0]],
									[[6,117,0],[16,113,0],[10,142,0]],
									[[16,113,0],[19,140,0],[10,142,0]],
									[[16,113,0],[28,136,0],[19,140,0]],
									[[28,136,0],[24,106,0],[36,132,0]],
									[[28,136,0],[16,113,0],[24,106,0]],
									[[5,-5,0],[-9,14,0],[-11,-6,0]],
									[[-11,-6,0],[-22,8,0],[-22,-12,0]],
									[[-22,8,0],[-37,3,0],[-22,-12,0]],
									[[-22,-12,0],[-37,3,0],[-46,-4,0]],
									[[-46,-4,0],[-30,-22,0],[-22,-12,0]],
									[[-30,-22,0],[-46,-4,0],[-53,-10,0]],
									[[-30,-22,0],[-53,-10,0],[-59,-19,0]],
									[[-59,-19,0],[-37,-35,0],[-30,-22,0]],
									[[-37,-35,0],[-59,-19,0],[-64,-29,0]],
									[[-64,-29,0],[-68,-38,0],[-37,-35,0]],
									[[-68,-38,0],[-40,-49,0],[-37,-35,0]],
									[[-40,-49,0],[-68,-38,0],[-70,-49,0]],
									[[-40,-49,0],[-70,-49,0],[-70,-69,0]],
									[[-70,-69,0],[-40,-62,0],[-40,-49,0]],
									[[-40,-62,0],[-70,-69,0],[-36,-76,0]],
									[[-70,-69,0],[-64,-89,0],[-36,-76,0]],
									[[-36,-76,0],[-64,-89,0],[-52,-106,0]],
									[[-52,-106,0],[-30,-89,0],[-36,-76,0]],
									[[-30,-89,0],[-52,-106,0],[-43,-115,0]],
									[[-43,-115,0],[-21,-98,0],[-30,-89,0]],
									[[-21,-98,0],[-43,-115,0],[-27,-125,0]],
									[[-27,-125,0],[-11,-104,0],[-21,-98,0]],
									[[-11,-104,0],[-27,-125,0],[-7,-130,0]],
									[[-7,-130,0],[0,-106,0],[-11,-104,0]],
									[[0,-106,0],[-7,-130,0],[5,-131,0]],
									[[5,-131,0],[17,-101,0],[0,-106,0]],
									[[17,-101,0],[5,-131,0],[23,-128,0]],
									[[17,-101,0],[23,-128,0],[34,-123,0]],
									[[34,-123,0],[43,-118,0],[17,-101,0]],
									[[43,-118,0],[26,-93,0],[17,-101,0]],
									[[26,-93,0],[43,-118,0],[52,-110,0]],
									[[52,-110,0],[63,-97,0],[26,-93,0]],
									[[26,-93,0],[63,-97,0],[34,-82,0]],
									[[63,-97,0],[68,-87,0],[34,-82,0]],
									[[34,-82,0],[68,-87,0],[74,-68,0]],
									[[74,-68,0],[39,-68,0],[34,-82,0]],
									[[39,-68,0],[74,-68,0],[74,-56,0]],
									[[74,-56,0],[40,-55,0],[39,-68,0]],
									[[40,-55,0],[74,-56,0],[71,-37,0]],
									[[71,-37,0],[38,-40,0],[40,-55,0]],
									[[38,-40,0],[71,-37,0],[63,-18,0]],
									[[63,-18,0],[33,-27,0],[38,-40,0]],
									[[33,-27,0],[63,-18,0],[56,-9,0]],
									[[56,-9,0],[26,-16,0],[33,-27,0]],
									[[26,-16,0],[56,-9,0],[49,-3,0]],
									[[26,-16,0],[49,-3,0],[40,4,0]],
									[[40,4,0],[16,-9,0],[26,-16,0]],
									[[16,-9,0],[40,4,0],[21,12,0]],
									[[5,-5,0],[16,-9,0],[12,14,0]],
									[[-11,-6,0],[-7,4,0],[-22,8,0]],
									[[5,-5,0],[12,14,0],[-9,14,0]],
									[[16,-9,0],[21,12,0],[12,14,0]]
								],
								[
									[[-2,143,0],[-12,142,0],[-1,117,0]],
									[[-12,142,0],[-11,114,0],[-1,117,0]],
									[[-11,114,0],[-12,142,0],[-21,139,0]],
									[[-11,114,0],[-21,139,0],[-30,134,0]],
									[[-30,134,0],[-20,106,0],[-11,114,0]],
									[[-20,106,0],[-30,134,0],[-38,128,0]],
									[[-20,106,0],[-38,128,0],[-46,120,0]],
									[[-46,120,0],[-27,94,0],[-20,106,0]],
									[[-27,94,0],[-46,120,0],[-53,111,0]],
									[[-27,94,0],[-53,111,0],[-59,100,0]],
									[[-59,100,0],[-31,86,0],[-27,94,0]],
									[[-31,86,0],[-59,100,0],[-63,88,0]],
									[[-63,88,0],[-33,77,0],[-31,86,0]],
									[[-33,77,0],[-63,88,0],[-66,77,0]],
									[[-66,77,0],[-36,60,0],[-33,77,0]],
									[[-36,60,0],[-66,77,0],[-69,62,0]],
									[[-36,60,0],[-69,62,0],[-69,50,0]],
									[[-69,50,0],[-36,42,0],[-36,60,0]],
									[[-36,42,0],[-69,50,0],[-68,35,0]],
									[[-68,35,0],[-33,25,0],[-36,42,0]],
									[[-68,35,0],[-63,14,0],[-33,25,0]],
									[[-63,14,0],[-27,9,0],[-33,25,0]],
									[[-27,9,0],[-63,14,0],[-58,2,0]],
									[[-58,2,0],[-52,-8,0],[-27,9,0]],
									[[-52,-8,0],[-20,-3,0],[-27,9,0]],
									[[-20,-3,0],[-52,-8,0],[-45,-18,0]],
									[[-20,-3,0],[-45,-18,0],[-37,-26,0]],
									[[-37,-26,0],[-10,-10,0],[-20,-3,0]],
									[[-10,-10,0],[-37,-26,0],[-20,-35,0]],
									[[-10,-10,0],[-20,-35,0],[-10,-38,0]],
									[[-10,-38,0],[-1,-13,0],[-10,-10,0]],
									[[-1,-13,0],[-10,-38,0],[-2,-39,0]],
									[[-1,-13,0],[-2,-39,0],[8,-38,0]],
									[[8,-38,0],[13,-7,0],[-1,-13,0]],
									[[13,-7,0],[8,-38,0],[18,-35,0]],
									[[13,-7,0],[18,-35,0],[26,-31,0]],
									[[26,-31,0],[39,-23,0],[13,-7,0]],
									[[39,-23,0],[22,3,0],[13,-7,0]],
									[[39,-23,0],[49,-7,0],[22,3,0]],
									[[49,-7,0],[28,17,0],[22,3,0]],
									[[28,17,0],[49,-7,0],[54,3,0]],
									[[54,3,0],[59,15,0],[28,17,0]],
									[[28,17,0],[59,15,0],[33,35,0]],
									[[59,15,0],[63,28,0],[33,35,0]],
									[[33,35,0],[63,28,0],[64,40,0]],
									[[64,40,0],[34,52,0],[33,35,0]],
									[[34,52,0],[64,40,0],[66,53,0]],
									[[66,53,0],[33,63,0],[34,52,0]],
									[[64,70,0],[33,63,0],[66,53,0]],
									[[64,70,0],[31,79,0],[33,63,0]],
									[[31,79,0],[64,70,0],[62,80,0]],
									[[31,79,0],[62,80,0],[59,90,0]],
									[[59,90,0],[25,95,0],[31,79,0]],
									[[25,95,0],[59,90,0],[54,102,0]],
									[[25,95,0],[54,102,0],[48,113,0]],
									[[25,95,0],[48,113,0],[41,121,0]],
									[[41,121,0],[17,107,0],[25,95,0]],
									[[17,107,0],[41,121,0],[33,129,0]],
									[[17,107,0],[33,129,0],[24,136,0]],
									[[24,136,0],[8,115,0],[17,107,0]],
									[[8,115,0],[24,136,0],[16,140,0]],
									[[8,115,0],[16,140,0],[7,142,0]],
									[[8,115,0],[7,142,0],[-2,143,0]],
									[[-1,117,0],[8,115,0],[-2,143,0]],
									[[-34,-71,0],[-66,-71,0],[-63,-85,0]],
									[[-63,-85,0],[-33,-79,0],[-34,-71,0]],
									[[-33,-79,0],[-63,-85,0],[-57,-101,0]],
									[[-57,-101,0],[-27,-92,0],[-33,-79,0]],
									[[-27,-92,0],[-57,-101,0],[-49,-113,0]],
									[[-27,-92,0],[-49,-113,0],[-36,-123,0]],
									[[-36,-123,0],[-16,-102,0],[-27,-92,0]],
									[[-16,-102,0],[-36,-123,0],[-24,-128,0]],
									[[-16,-102,0],[-24,-128,0],[-9,-131,0]],
									[[-9,-131,0],[-1,-103,0],[-16,-102,0]],
									[[-1,-103,0],[-9,-131,0],[9,-129,0]],
									[[-1,-103,0],[9,-129,0],[25,-121,0]],
									[[25,-121,0],[10,-98,0],[-1,-103,0]],
									[[10,-98,0],[25,-121,0],[39,-108,0]],
									[[39,-108,0],[20,-85,0],[10,-98,0]],
									[[20,-85,0],[39,-108,0],[47,-95,0]],
									[[20,-85,0],[47,-95,0],[55,-82,0]],
									[[55,-82,0],[25,-73,0],[20,-85,0]],
									[[25,-73,0],[55,-82,0],[59,-71,0]],
									[[59,-71,0],[30,-60,0],[25,-73,0]],
									[[30,-60,0],[59,-71,0],[63,-60,0]],
									[[63,-60,0],[34,-47,0],[30,-60,0]],
									[[34,-47,0],[63,-60,0],[68,-44,0]],
									[[68,-44,0],[37,-34,0],[34,-47,0]],
									[[37,-34,0],[68,-44,0],[70,-24,0]],
									[[37,-34,0],[70,-24,0],[39,-23,0]],
									[[39,-23,0],[70,-24,0],[72,1,0]],
									[[39,-23,0],[72,1,0],[64,65,0]]
								]];
								
		public static var  second_1:Array = new Array(10);
		public static var  second_2:Array = new Array(10);
		public static var  min_1:Array = new Array(10);
		public static var  min_2:Array = new Array(10);
		public static var  hour_1:Array = new Array(10);
		public static var  hour_2:Array = new Array(10);
		public static var  max_num:Number = Math.max(num_data[0].length, num_data[1].length, num_data[2].length, num_data[3].length, num_data[4].length,
													 num_data[5].length, num_data[6].length, num_data[7].length, num_data[8].length, num_data[9].length);
		public static const second1_x:Number = 120;
		public static const second2_x:Number = 190;
		public static const second_y:Number = 0;
		public static const min1_x:Number = -30;
		public static const min2_x:Number = 40;
		public static const min_y:Number = 0;
		public static const hour1_x:Number = -180;
		public static const hour2_x:Number = -110;
		public static const hour_y:Number = 0;
		
		public static const num_alpha:Number = 0.4;
		
		public static var mash:Array = new Array(6);

	
		public static function init_number():void {

			for (var i:Number = 0; i < 10; i++) {
				second_1[i] = new Array(num_data[i].length);
				second_2[i] = new Array(num_data[i].length);
				min_1[i] = new Array(num_data[i].length);
				min_2[i] = new Array(num_data[i].length);
				hour_1[i] = new Array(num_data[i].length);
				hour_2[i] = new Array(num_data[i].length);
				for (var j:Number = 0; j < num_data[i].length; j++) {
					second_1[i][j] = new Array(3);
					second_2[i][j] = new Array(3);
					min_1[i][j] = new Array(3);
					min_2[i][j] = new Array(3);
					hour_1[i][j] = new Array(3);
					hour_2[i][j] = new Array(3);
					for (var n:Number = 0; n < 3;n++){
						second_1[i][j][n] = new Vertex3D();
						second_2[i][j][n] = new Vertex3D();
						min_1[i][j][n] = new Vertex3D();
						min_2[i][j][n] = new Vertex3D();
						hour_1[i][j][n] = new Vertex3D();
						hour_2[i][j][n] = new Vertex3D();
						second_1[i][j][n].x = num_data[i][j][n][0] * num_alpha + second1_x;						
						second_1[i][j][n].y = num_data[i][j][n][1] * num_alpha + second_y;
						second_1[i][j][n].z = num_data[i][j][n][2];
						
//						trace(i +" " + j + " " + n + " second_1 x "+second_1[i][j][n].x+" "+num_data[i][j][n][0]+
//						" second_1 y " + second_1[i][j][n].y + " " + num_data[i][j][n][1] +
//						" second_1 z " + second_1[i][j][n].z + " " + num_data[i][j][n][2]);
						
						second_2[i][j][n].x = num_data[i][j][n][0] * num_alpha + second2_x;
						second_2[i][j][n].y = num_data[i][j][n][1] * num_alpha + second_y;
						second_2[i][j][n].z = num_data[i][j][n][2];
						min_1[i][j][n].x = num_data[i][j][n][0] * num_alpha + min1_x;
						min_1[i][j][n].y = num_data[i][j][n][1] * num_alpha + min_y;
						min_1[i][j][n].z = num_data[i][j][n][2];
						min_2[i][j][n].x = num_data[i][j][n][0] * num_alpha + min2_x;
						min_2[i][j][n].y = num_data[i][j][n][1] * num_alpha + min_y;
						min_2[i][j][n].z = num_data[i][j][n][2];
						hour_1[i][j][n].x = num_data[i][j][n][0] * num_alpha + hour1_x;
						hour_1[i][j][n].y = num_data[i][j][n][1] * num_alpha + hour_y;
						hour_1[i][j][n].z = num_data[i][j][n][2];
						hour_2[i][j][n].x = num_data[i][j][n][0] * num_alpha + hour2_x;
						hour_2[i][j][n].y = num_data[i][j][n][1] * num_alpha + hour_y;
						hour_2[i][j][n].z = num_data[i][j][n][2];
					}									
				}
			}
		}
	}