/**
 * Copyright 1sunbou ( http://wonderfl.net/user/1sunbou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aqwq
 */

// forked from Glav's Water and Bubbles
package {
    import flash.display.Sprite;
    import flash.display.BlendMode;
    
    [SWF(backgroundColor="#ffffff")]
    
    public class Main extends Sprite {
        public function Main() {
            var bubbl:Bubules = new Bubules();
            var water:Wave = new Wave();
            
            water.x = stage.stageWidth / 2;
            water.y = stage.stageHeight / 2;
            
            bubbl.y = stage.stageHeight/2.5;
            
            addChild(water);
            addChild(bubbl);
            
            //bubbl.blendMode = BlendMode.ERASE; // doesn't work !
        }
    
    }
}

//-----------------------------------------------------------------
// Bubbles class
//-----------------------------------------------------------------

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;

class Bubules extends Sprite {
    private const MY_WIDTH:uint = 465;
    private const MY_HEIGHT:uint = 300;
    
    public function Bubules() {
        
       for(var i:int = 0; i<=10; i++){
           var shape:Shape = new Shape();
           addChild(shape);
           shape.graphics.beginFill(0xffffff, 0.5);

           shape.graphics.drawCircle(0,0,50);
           with(shape){
               x = Math.random() * MY_WIDTH;
               y = Math.random() * MY_HEIGHT;
               scaleX = scaleY = 0.01 + Math.random() * 0.05;
               addEventListener(Event.ENTER_FRAME, moveMe);    
           }    
       }
    }

   public function moveMe(event:Event):void{
        var bubble:Shape = Shape(event.target);
        bubble.y -= 10 * bubble.scaleX;
        if(bubble.y<0){
            bubble.y = MY_HEIGHT;
            bubble.x = Math.random() * MY_WIDTH;    
        }
        bubble.z += Math.random() * 1 - 0.5;
        if (bubble.z > 2) bubble.z = 2;
        if (bubble.z < -2) bubble.z = -2;
        bubble.x += bubble.z/2;
        
        if(bubble.x < 0)
            bubble.x = 0;
        if(bubble.x > MY_WIDTH)
            bubble.x = MY_WIDTH;
        
        bubble.alpha = 1-(bubble.y / MY_HEIGHT);
    }
}


//--------------------------------------------------------
// Wave class
//--------------------------------------------------------

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import frocessing.math.PerlinNoise;
import frocessing.color.ColorHSV;

class Wave extends Sprite {
    private var canvas:Sprite;
    private var perlin:PerlinNoise;
    private var color:ColorHSV;
    private var t:Number = 0;
    private const bWidth:uint = 300;
    private const bHeight:uint = 370;
    private const top:Number = 0.11;
    private const bottom:Number = 0.3;
    private const amplitude:Number = bottom - top;
    private const waves:Array = [190, 198, 206, 214];
    private const segments:uint = 4;
    private const ratio:Number = 1/segments;
    private const xOffset:Number = 0.25;
    private const yOffset:Number = 0.01;
    private const tightness:uint = 4;

    public function Wave() {
        canvas = new Sprite();
        addChild(canvas);
        canvas.x = -157;
        canvas.y = -60;
        perlin = new PerlinNoise();
        color = new ColorHSV();
        
        addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
    }
    
    private function draw(evt:Event):void {
        canvas.graphics.clear();
        var points:Array;
        for (var d:uint = 0; d < waves.length; d++) {
            points = new Array();
            points.push(new Point(-bWidth*ratio, bHeight*amplitude));
            
            for (var n:uint = 1; n <= segments+1; n++)
                points.push(new Point((n*bWidth*ratio)-bWidth*ratio, perlin.noise(n*xOffset*d, t)*bHeight*amplitude + bHeight*top));
            
            t += yOffset;
            points.push(new Point(bWidth*(1+ratio), bHeight*amplitude));
            points.unshift(points[0]);
            points.push(points[points.length-1]);
            color.h = waves[d];
            canvas.graphics.beginFill(color.value, 0.2);
            canvas.graphics.moveTo(points[0].x, points[0].y);
            for (var p:uint = 0; p < points.length-3; p++) {
                var p0:Point = points[p];
                var p1:Point = points[p+1];
                var p2:Point = points[p+2];
                var p3:Point = points[p+3];
                for (var s:uint = 1; s < tightness+1; s++)
                    canvas.graphics.lineTo(spline(p0.x, p1.x, p2.x, p3.x, s/tightness), spline(p0.y, p1.y, p2.y, p3.y, s/tightness));
                
            }
            canvas.graphics.lineTo(bWidth*(1+ratio), bHeight);
            canvas.graphics.lineTo(-bWidth*ratio, bHeight);
            canvas.graphics.endFill();
        }
    }
    
    private function spline(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number {
         var v0:Number = (p2 - p0) * 0.5;
        var v1:Number = (p3 - p1) * 0.5;
        var t2:Number = t * t;
        var t3:Number = t2 * t;
        return (2 * p1 - 2 * p2 + v0 + v1) * t3 + ( -3 * p1 + 3 * p2 - 2 * v0 - v1) * t2 + v0 * t + p1;
    }
}

