/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aqHH
 */

package {
        
    import caurina.transitions.Tweener;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.display.DisplayObjectContainer;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.system.Security;

    public class C2_3 extends Sprite {
        //logo画像
        private var _img1:Sprite;
        private var _img2:Sprite;
        private var _img3:Sprite;
        //_img1,_img2,_img3のコンテナ
        private var _container:Sprite;
        private var _spiral:Spiral;
        private var _defaultPositions:Array;
        public function C2_3() {
            init();
        }
        private function init():void {
            //ロゴ画像のコンテナ
            _container = addChild( new Sprite()) as Sprite;
            _container.x = stage.stageWidth*.5;
            _container.y = stage.stageHeight*.5;
            loadImages();
            addEventListener(Event.COMPLETE, completeHandler);
        }
        
        private function completeHandler(e:Event):void {
            removeEventListener(Event.COMPLETE, completeHandler);
            //復元可能なように初期値を格納
            _defaultPositions = [
                [_img1.x, _img1.y],
                [_img2.x, _img2.y],
                [_img3.x, _img3.y],
            ];
            _spiral = new Spiral(_container, _img1, _img2, _img3)
            //ここからアニメーションがスタート
            fadeIn();
        }
        
        private function fadeIn():void{
            Tweener.addTween(_img1, {
                alpha:1, time:.2, transition:"linear" 
            } );
            Tweener.addTween(_img2, { 
                alpha:1, time:.2, delay:.1, transition:"linear" 
            } );
            Tweener.addTween(_img3, { 
                alpha:1, time:.2, delay:.2, transition:"linear",
                onComplete:rotation3d
            } );
        }
        
        private function rotation3d():void {
            Tweener.addTween(_container, {
                rotationY:720, time:2, transition:"easeOutCubic",
                onComplete:alignCenter
            } );
        }
        
        private function alignCenter():void {
            Tweener.addTween(_img1, {
                x:0, time:1 , transition:"easeOutSine" 
            } );
            Tweener.addTween(_img2, { 
                x:0, time:1 , transition:"easeOutSine"
            } );
            Tweener.addTween(_img3, { 
                x:0, time:1 , transition:"easeOutSine", 
                onComplete:moveSpiral 
            } );
        }
        
        private function moveSpiral():void {
            Tweener.addTween(_spiral, { 
                radian:30, time:8, transition:"easeInSine" 
            } );
            Tweener.addTween(_spiral, { 
                radius:220, time:8, transition:"linear" 
            } );
            Tweener.addTween(_spiral, { 
                radian:60, time:8, radius:0, 
                delay:8, transition:"easeOutSine"
            } );
        
            Tweener.addTween(_img1, { 
                x:_defaultPositions[0][0], 
                time:1, delay:16 , transition:"easeOutSine" 
            } );
            Tweener.addTween(_img2, { 
                x:_defaultPositions[1][0],
                time:1, delay:16 , transition:"easeOutSine" 
            } );
            Tweener.addTween(_img3, { 
                x:_defaultPositions[2][0], 
                time:1, delay:16 ,
                transition:"easeOutSine", onComplete:zoom 
            } );
        }
        
        private function zoom():void { 
            Tweener.addTween(_img1, {
                scaleX:1,
                x:_defaultPositions[0][0],
                y:_defaultPositions[0][1],
                time:.8, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:1,
                x:_defaultPositions[1][0],
                y:_defaultPositions[1][1],
                time:.8, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:1,
                x:_defaultPositions[2][0],
                y:_defaultPositions[2][1],
                time:.8, 
                transition:"easeOutElastic"
            } );         
            Tweener.addTween(_container, { 
                scaleX:1.5, rotation: -45, time:.8,
                transition:"easeOutElastic"
            } );            
            Tweener.addTween(_container, { 
                scaleX:1.5, rotation:30, time:.8, delay:.8,
                transition:"easeOutElastic",
                onComplete:scroll
            } ); 
        }
        
        private function scroll():void{
            Tweener.addTween(_img1, {
                scaleY:3, y:-60, time:1.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img2, { 
                scaleY:3, y:60, time:1.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img3, { 
                scaleY:3, y:-60, time:1.5, 
                transition:"easeOutElastic",
                onComplete:reset
            } );
        }
        
        private function reset():void{
            Tweener.addTween(_img1, {
                scaleY:1, y:0, time:.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img2, { 
                scaleY:1, y:0, time:.5, 
                transition:"easeOutElastic" 
            } );
            Tweener.addTween(_img3, { 
                scaleY:1, y:0, time:.5, 
                transition:"easeOutElastic",
                onComplete:compress
            } );
        }
        
        private function compress():void{
            Tweener.addTween(_img1, {
                scaleX:.4,
                x:_defaultPositions[0][0] + 111,
                time:1, 
                transition:"easeInOutBack" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:.4, time:1, 
                transition:"easeInOutBack" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:.4,
                x:_defaultPositions[2][0] - 90,
                time:1, 
                transition:"easeInOutBack",
                onComplete:charge
            } );
        }
        
        private function charge():void {
            Tweener.addTween(_img1, {
                scaleX:.2,
                x:_defaultPositions[0][0] + 160,
                time:1, 
                transition:"easeInCubic" 
            } );
            Tweener.addTween(_img2, { 
                scaleX:.2,
                time:1, 
                transition:"easeInCubic" 
            } );
            Tweener.addTween(_img3, { 
                scaleX:.2,
                x:_defaultPositions[2][0] - 130,
                time:1, 
                transition:"easeInCubic",
                onComplete:destroy
            } );
        }
        
        private function destroy():void {
            Tweener.addTween(_img1, {
                z:-800, rotation:1080, time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img2, { 
                z:-1200, rotation:1080, time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img3, { 
                z:-800, rotation:1080, time:1, 
                transition:"linear" 
            } );
            Tweener.addTween(_img1, {
                x:0, y:-140, time:1, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img2, { 
                x:-180, y:180, time:1, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img3, { 
                x:120, y:-90, time:1, 
                transition:"easeOutCubic",
                onComplete:restore
            } );
        }
        private function restore():void {
            Tweener.addTween(_container, {
                x:stage.stageWidth*.5, y:stage.stageHeight*.5, z:0,
                scaleX:.8, scaleY:.8,
                rotation:0, time:.3, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img1, {
                x:_defaultPositions[0][0],
                y:_defaultPositions[0][1],
                z:0, scaleX:1, rotation:0,
                time:.3, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img2, {
                x:_defaultPositions[1][0],
                y:_defaultPositions[1][1],
                z:0, scaleX:1, rotation:0,
                time:.3, 
                transition:"easeOutCubic" 
            } );
            Tweener.addTween(_img3, {
                x:_defaultPositions[2][0],
                y:_defaultPositions[2][1],
                z:0, scaleX:1, rotation:0,
                time:.3, 
                transition:"easeOutCubic" 
            } );
        }
        
        private function loadImages():void {
            //読み込んだ画像のカウント
            var numLoaded:int = 0;
            Security.loadPolicyFile("http://labs.un-q.net/crossdomain.xml");  
            var loader:Loader = new Loader();
            loader.load(new URLRequest("http://labs.un-q.net/webdb/2_3/logo_1.png"));
            loader.contentLoaderInfo.addEventListener(
                Event.COMPLETE,
                imgCompleteHander
            )
            function imgCompleteHander(e:Event):void {
                loader.contentLoaderInfo.removeEventListener(
                    Event.COMPLETE,
                    imgCompleteHander
                );
                
                switch(++numLoaded) {
                    case 1:
                        //取得した画像を加工してコンテナに追加
                        _img1 = drawBitmap(loader);
                        _img1.alpha = 0;
                        //次の画像を取り込む
                        loader = new Loader();
                        loader.load(new URLRequest("http://labs.un-q.net/webdb/2_3/logo_2.png"));
                        loader.contentLoaderInfo.addEventListener(
                            Event.COMPLETE,
                            imgCompleteHander
                        );
                    break;
                    case 2:
                        _img2 = drawBitmap(loader);
                        _img2.alpha = 0;
                        loader = new Loader();
                        loader.load(new URLRequest("http://labs.un-q.net/webdb/2_3/logo_3.png"));
                        loader.contentLoaderInfo.addEventListener(
                            Event.COMPLETE,
                            imgCompleteHander
                        );
                    break;
                    case 3:
                        _img3 = drawBitmap(loader);
                        _img3.alpha = 0;
                        loader = null;
                        setImagePositions();
                    break;
                    default:
                    break;
                }
            }
            function setImagePositions():void {
                //コンテナに各画像を追加
                _container.addChild(_img1);
                _container.addChild(_img2);
                _container.addChild(_img3);
                //位置を調整し、縦横を中央にそろえる。
                var offset:Number = (_img1.width + _img2.width + _img3.width) * .5;
                _img1.x = _img1.width * .5 - offset;
                _img2.x = _img1.width + _img2.width * .5 - offset - 2;
                _img3.x = offset - _img3.width * .5 - 5;

                dispatchEvent(new Event(Event.COMPLETE));
            }
            function drawBitmap(loader:Loader):Sprite {
                //取り込んだ画像をビットマップに渡してスムージングをかける
                var bmd:BitmapData = new BitmapData(
                    loader.width, loader.height,
                    true, 0
                );
                bmd.draw(loader);
                var img:Bitmap = new Bitmap(bmd)
                img.smoothing = true;
                //画像をセンタリングする
                var container:Sprite = new Sprite();
                container.addChild(img);
                img.x = img.width * -.5;
                img.y = img.height * -.5;
                return container;
            }
        }
    }
}

class Spiral {
    import flash.display.Sprite;
    //回転角度
    private var _radian:Number;
    //半径
    private var _radius:Number;
    private var _container:Sprite;
    private var _img1:Sprite;
    private var _img2:Sprite;
    private var _img3:Sprite;
    
    private const OFFSET_ANGLE_1:Number = Math.PI * 2 / 3;
    private const OFFSET_ANGLE_2:Number = Math.PI * 4 / 3;
    public function Spiral(container:Sprite,img1:Sprite,img2:Sprite,img3:Sprite):void {
        _container = container
        _img1 = img1;
        _img2 = img2;
        _img3 = img3;
        _radian = 0;
        _radius = 0;
    }
    
    public function get radian():Number { return _radian; }
    public function set radian(value:Number):void {
        _radian = value;
        
        //螺旋回転を行う
        _img1.x = Math.cos(value) * _radius;
        _img1.y = Math.sin(value) * _radius;
        _img1.z = Math.sin(value*.5) * _radius;
        _img2.x = Math.cos(value + OFFSET_ANGLE_1) * _radius;
        _img2.y = Math.sin(value + OFFSET_ANGLE_1) * _radius;
        _img2.z = Math.sin(value*.5 + OFFSET_ANGLE_1) * _radius;
        _img3.x = Math.cos(value + OFFSET_ANGLE_2) * _radius;
        _img3.y = Math.sin(value + OFFSET_ANGLE_2) * _radius;
        _img3.z = Math.sin(value * .5 + OFFSET_ANGLE_2) * _radius;        
        
        //重なり順を入れ替え
        if (_img1.z < _img2.z && _img1.z < _img3.z) {
            _container.setChildIndex(_img1, 2);
            if (_img2.z < _img3.z) {
                _container.setChildIndex(_img2, 1);
            }else {
                _container.setChildIndex(_img3, 1);
            }
        }else if (_img1.z < _img2.z) {
            _container.setChildIndex(_img2, 0);
            _container.setChildIndex(_img1, 1);
            _container.setChildIndex(_img3, 2);
        }else if (_img1.z < _img3.z) {
            _container.setChildIndex(_img3, 0);
            _container.setChildIndex(_img1, 1);
            _container.setChildIndex(_img2, 2);
        }else {
            _container.setChildIndex(_img1, 0);
            if (_img2.z < _img3.z) {
                _container.setChildIndex(_img2, 2);
            }else {
                _container.setChildIndex(_img3, 2);
            }
        }
    }
    
    public function get radius():Number { return _radius; }
    
    public function set radius(value:Number):void 
    {
        _radius = value;
    }
}
