/**
 * Copyright hacker_akyifj_9 ( http://wonderfl.net/user/hacker_akyifj_9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aqED
 */

// forked from nitoyon's [BetweenAS3] Random Text Tween
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import org.libspark.betweenas3.easing.*;

    public class FlashTest extends Sprite {
        public function FlashTest() {
            var t:TextField = TextField(addChild(new TextField()));
            t.autoSize = "left";
            t.scaleX = t.scaleY = 2.8;
            t.y = 210;
            t.text = "test";

            var tween:RandomTextTween = new RandomTextTween();
            tween.target = t;
            tween.easing = Sine.easeOut;
            tween.text = "Random Text Tween Sample";
            tween.time = 1;
            tween.play();

            t.addEventListener("mouseOver", function(event:Event):void{
                tween.play();
            });
        }
    }
}

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.core.ticker.ITicker;
import org.libspark.betweenas3.core.tweens.AbstractTween;
import org.libspark.betweenas3.core.tweens.IITween;

/**
 * ランダムテキストを実行する Tween.
 * 
 * @author    nitoyon
 */
class RandomTextTween extends AbstractTween
{
    /**
     * static ITicker cache.
     */
    private static var _ticker:ITicker;

    /**
     * TextField.
     */
    public function get target():Object { return _target; }
    public function set target(value:Object):void { _target = value; }
    private var _target:Object;

    /**
     * Tween easing.
     */
    public function get easing():IEasing { return _easing; }
    public function set easing(value:IEasing):void { _easing = value; }
    private var _easing:IEasing;

    /**
     * Destination text.
     */
    public function get text():String { return _text; }
    public function set text(value:String):void { _text = value; }
    private var _text:String;

    /**
     * Set or get duration.
     */
    public function get time():Number { return _duration; }
    public function set time(value:Number):void { _duration = value; }

    /**
     * Constructor.
     *
     * @param duration sleep duration.
     * @param ticker   ticker object.
     * @param position initial position.
     */
    public function RandomTextTween(ticker:ITicker = null, position:Number = 0) {
        if (!_ticker) {
            // create tmp tween to get the BetweenAS3's static ticker.
            var tmpTween:IITween = BetweenAS3.parallel() as IITween;
            _ticker = tmpTween.ticker;
        }

        super(ticker || _ticker, position);
    }

    /**
     * 更新処理を行う。
     */
    protected override function internalUpdate(time:Number):void
    {
        // check
        if (!_target) { throw new Error("target is not set"); }
        if (!_easing) { throw new Error("easing is not set"); }
        if (!_text) { throw new Error("text is not set"); }

        // get the factor (0.0~1.0)
        var factor:Number = 0.0;
        if (time > 0.0) {
            if (time < _duration) {
                factor = _easing.calculate(time, 0.0, 1.0, _duration);
            }
            else {
                factor = 1.0;
            }
        }

        // update the text
        var pos:int = factor * (_text.length * 2);
        var dst:String = "";
        if (pos > _text.length) {
            dst = _text.substr(0, pos - _text.length);
        }
        while (pos > 0 && dst.length < _text.length) {
            dst += String.fromCharCode(Math.random() * 94 + 32);
            pos--;
        }
        _target["text"] = dst;
    }
}
