/**
 * Copyright Xyrio ( http://wonderfl.net/user/Xyrio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aq9I
 */

// forked from kawamura's 多重連結バネ
//added a rectangle for accelleration and velocity
//added bezier grid
//added coloring depending on vector of velocity and accelleration
package  {
    import net.hires.debug.Stats;
    import flash.display.MovieClip;
    import flash.media.Microphone;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.events.MouseEvent;
    public class FlashTest extends MovieClip {
        private var nxy:Number=10; 
        private var dxy:Number=stage.stageWidth/nxy;
        private var w:uint=Math.floor(stage.stageWidth/dxy);
        private var h:uint=Math.floor(stage.stageHeight/dxy);
        //
        private var d_mc:MovieClip;
        private var mi_ar:Array;
        private var beziershx:Array;
        private var beziershy:Array;
        private var beziersvx:Array;
        private var beziersvy:Array;
        private var canvas:MovieClip
        public function FlashTest() {
            var stats:Stats=new Stats();
            addChild( stats );
            canvas=new MovieClip();
            addChild(canvas)
            // constructor code
            var i:uint;
            var ii:uint;
            var scx:Number=stage.stageWidth*.5;
            var scy:Number=stage.stageHeight*.5;
            //
            w=Math.floor(stage.stageWidth/dxy);
            h=Math.floor(stage.stageHeight/dxy);
            //
            var sx:Number=(stage.stageWidth-dxy*(w-1))*.5
            var sy:Number=(stage.stageHeight-dxy*(h-1))*.5
            //
            var p:MovieClip;
            mi_ar=new Array()
            beziershx = new Array();
            beziershy = new Array();
            beziersvx = new Array();
            beziersvy = new Array();
            for(i=0;i<h;i++){
                var bhx:Bezier=new Bezier();
                var bhy:Bezier=new Bezier();
                var bvx:Bezier=new Bezier();
                var bvy:Bezier=new Bezier();
                for(ii=0;ii<w;ii++){
                    if(i==0 || i==h-1 || ii==0 ||  ii==w-1){
                        p=new Pin();
                    }else{
                        p=new Mi();
                    }
                    canvas.addChild(p);
                    p.x=sx+ii*dxy;
                    p.y=sy+i*dxy;
                    mi_ar.push(p)
                    
                    //0 because coordinates are set later
                    bhx.addPoint(0);
                    bhy.addPoint(0);
                    bvx.addPoint(0);
                    bvy.addPoint(0);
                }
                beziershx.push(bhx);
                beziershy.push(bhy);
                beziersvx.push(bvx);
                beziersvy.push(bvy);
            }
            for(i=0;i<mi_ar.length;i++){
                if(i>w-1 && i<mi_ar.length-w && i%w!=0 && i%w !=w-1){
                    p=mi_ar[i];
                    p.x+=-w+2*w*Math.random();
                    p.y+=-w+2*w*Math.random();
                    p.init([mi_ar[i-1],mi_ar[i+1],mi_ar[i-w],mi_ar[i+w]])
                }
            }
            //
            addEventListener(Event.ENTER_FRAME,ent)
        }
        //

        private function ent(evt:Event):void{
            var i:uint;
            var g:Graphics=canvas.graphics;
            g.clear()
            /*for(i=0;i<mi_ar.length;i++){
                if( i<mi_ar.length-w && i%w !=w-1){
                    g.lineStyle(1,0xFF0000);
                    g.moveTo(mi_ar[i].x,mi_ar[i].y);
                    g.lineTo(mi_ar[i+1].x,mi_ar[i+1].y);
                    g.lineTo(mi_ar[i+w+1].x,mi_ar[i+w+1].y);
                    g.lineTo(mi_ar[i+w].x,mi_ar[i+w].y);
                    g.lineTo(mi_ar[i].x,mi_ar[i].y);
                }
            }*/
            var ix:uint;
            var iy:uint;
            
            //update positions
            for(iy=0; iy<h; iy++){
                for(ix=0; ix<w; ix++){ 
                    beziershx[iy]._points[ix] = mi_ar[iy*w+ix].x;
                    beziershy[iy]._points[ix] = mi_ar[iy*w+ix].y;
                    beziersvx[ix]._points[iy] = mi_ar[iy*w+ix].x;
                    beziersvy[ix]._points[iy] = mi_ar[iy*w+ix].y;
                }
            }

            
            //draw bezier lines
            var resolution:uint=w*2;
            var step:Number=1/resolution;
            var tx:Number;
            var ty:Number;
            for(iy=0; iy<h; iy++){ 
                g.lineStyle(1,0xFF0000);
                g.moveTo(beziershx[iy]._points[0],beziershy[iy]._points[0]);
                for(i=1; i<resolution; i++){ 
                    g.lineTo(beziershx[iy].get(step*i),beziershy[iy].get(step*i)); 
                } 
                g.lineTo(beziershx[iy]._points[ beziershy[iy]._points.length-1 ],beziershy[iy]._points[ beziershy[iy]._points.length-1 ]);
            }
            for(ix=0; ix<w; ix++){
                g.lineStyle(1,0xFF0000);
                g.moveTo(beziersvx[ix]._points[0],beziersvy[ix]._points[0]); 
                for(i=1; i<resolution; i++){ 
                    g.lineTo(beziersvx[ix].get(step*i),beziersvy[ix].get(step*i));
                } 
                g.lineTo(beziersvx[ix]._points[ beziersvy[ix]._points.length-1 ],beziersvy[ix]._points[ beziersvy[ix]._points.length-1 ]);
            }

        }
        //
    }
}
import flash.geom.ColorTransform;


import flash.display.Graphics;
import flash.display.MovieClip;
import flash.events.Event;
import flash.events.MouseEvent;

class Mi extends MovieClip {
    private var n:Number=0;
    private var m:Number=1
    private var k:Number=0.01;
    private var t:Number=0.02;
    private var m_ar:Array;
    
    public var ax:Number=0;
    public var ay:Number=0;
    public var vx:Number=0;
    public var vy:Number=0;
    private var flag:Boolean=true;
    public function Mi() {
        // constructor code
        
    }
    public function init(_ar:Array):void{
        m_ar=_ar;
        ax=0;
        vx=0;
        ay=0;
        vy=0;
        this.buttonMode=true;
        this.addEventListener(Event.ENTER_FRAME,ent);
        this.addEventListener(MouseEvent.MOUSE_DOWN,mdwn);
    }
    //
    private function mdwn(evt:MouseEvent):void{
        flag=false;
        this.startDrag()
        stage.addEventListener(MouseEvent.MOUSE_UP,mup)
    }
    private function mup(evt:MouseEvent):void{
        flag=true;
        this.stopDrag();
        vx=0;
        vy=0;
        stage.removeEventListener(MouseEvent.MOUSE_UP,mup)
    }
    private function ent(evt:Event):void{
        if(flag){
            ax=0;
            ay=0;
            var i:uint;
            for(i=0;i<m_ar.length;i++){
                var mc:MovieClip=m_ar[i];
                ax+=mc.x-this.x;
                ay+=mc.y-this.y;
            }
            vx+=k*ax-t*vx;
            vy+=k*ay-t*vy;
            this.x+=vx;
            this.y+=vy;
        }
        var g:Graphics=this.graphics;
        g.clear();
        g.beginFill(getVectorColorCircular(asinangle(this.vx,this.vy), 255));
        g.drawCircle(0,0,7);
        g.beginFill(getVectorColorCircular(asinangle(this.ax,this.ay), 255));
        g.drawRect(ax*100*k,ay*100*k,vx*100*t,vy*100*t); 
    }
}

import flash.display.MovieClip;
import flash.display.Graphics;
import flash.events.MouseEvent;
class Pin extends MovieClip {
    public function Pin() {
        // constructor code
        var g:Graphics=this.graphics;
        g.beginFill(0x000000);
        g.drawCircle(0,0,3);
        this.buttonMode=true;
        this.addEventListener(MouseEvent.MOUSE_DOWN,mdwn)
    }
    private function mdwn(evt:MouseEvent):void{
        this.startDrag()
        stage.addEventListener(MouseEvent.MOUSE_UP,mup);
    }
    private function mup(evt:MouseEvent):void{
        this.stopDrag();
        this.removeEventListener(MouseEvent.MOUSE_UP,mup);
    }
}

class Bezier{
    public var _points:Array;
    public function Bezier() {
        _points = new Array();
    }
    public function addPoint(n:Number):void {
        _points.push(n);
    }

    ///t: 0.0-1.0 (k and i used for recursion)
    public function get(t:Number, k:Number=0, i:Number=0):Number {
        //if (k >= _points.length) throw "k too big"; 
        //if (i > k) throw "i too big";
        if (k == _points.length-1) //last line with given points
            return _points[i];
        return get(t,k+1,i)*(1-t) + get(t,k+1,i+1)*t;
    }
}

//used for calculating color from an angle -> getVectorColorCircular
function asinangle(x:Number, y:Number):Number
{
    if (x==0 && y==0) return 0; 
    var a:Number = Math.asin(y/Math.sqrt(x*x+y*y));
    if (x < 0) a = Math.PI - a;
    if (y < 0 && x >= 0) a += 2*Math.PI;
    //System.out.print(a/Math.PI*180+" ");
    return a;
}
///arcusangle: example: arcsin(y/sqrt(x*x+y*y))
///intensity: 0-255
function getVectorColorCircular(asinangle:Number, intensity:Number):uint
{
    var r:Number = (Math.sin(asinangle)+0.5)*intensity;
    var g:Number = (Math.sin(asinangle-1/3.*2*Math.PI)+0.5)*intensity;
    var b:Number = (Math.sin(asinangle-2/3.*2*Math.PI)+0.5)*intensity;
    if (r < 0)    r = 0;    if (r > 255)    r = 255;
    if (g < 0)    g = 0;    if (g > 255)    g = 255;
    if (b < 0)    b = 0;    if (b > 255)    b = 255;
    return (r<<16)+(g<<8)+b;
}