/**
 * Copyright testertester ( http://wonderfl.net/user/testertester )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aq24
 */

// forked from kihon's flash on 2010-4-13
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
 
	public class Main extends Sprite
	{
		private var circle:Sprite; // 中央の光
		private var lines:Array = new Array(); // 光に集まる線を保持するための配列
		private var count:int = 0;	// 線を出すタイミング
 
		public function Main()
		{
			// 画面を真っ暗にする
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, 465, 465);
			graphics.endFill();
 
			//　半径35px、白色の円を描く
			circle = new Sprite();
			circle.graphics.beginFill(0xFFFFFF);
			circle.graphics.drawCircle(0, 0, 35);
			circle.graphics.endFill();
			addChild(circle);
 
			// 位置を真ん中に移動
			circle.x = circle.y = 232;
 
			// ブラーをかける
			circle.filters = [new GlowFilter(0x009AD6, 1, 130, 130), new BlurFilter(25, 25)];
 
			var t:ITween = BetweenAS3.tween(circle, { scaleX:0.8, scaleY:0.8 }, null, 2.0);
			t = BetweenAS3.serial(t, BetweenAS3.reverse(t)); // 0.8にした後、逆再生で元に戻す
			t.stopOnComplete = false; // トゥイーン処理を延々と再生させる
			t.play();
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			// 3フレーム毎
			if (count++ % 3 == 0)
			{
				var line:Line = new Line();
				addChildAt(line, 0); // 線を表示リストに加えるときは、光の下側にする
				lines.push(line);
 
				// アルファ値を0にしておき、2秒掛けて1.0まで戻す
				line.alpha = 0.0;
				BetweenAS3.tween(line, { alpha:1.0 }, null, 2.0).play();
			}
 
			for (var i:int = 0; i < lines.length; i++)
			{
				// 線の位置を角度と同じ方向に配置させる
				lines[i].x = 232 + Math.cos(lines[i].rotation * Math.PI / 180) * lines[i].distance;
				lines[i].y = 232 + Math.sin(lines[i].rotation * Math.PI / 180) * lines[i].distance;
 
				// 距離を縮め、だんだんと近づけさせる
				lines[i].distance -= lines[i].speed;
 
				// 中央まで来たら線を削除
				if (lines[i].distance < -10)
				{
					removeChild(lines[i]); 	// 表示リストから削除
					lines.splice(i, 1);		// 配列から削除
					i--;
				}
			}
		}
	}
}
 
import flash.display.Sprite;
import flash.filters.GlowFilter;
 
class Line extends Sprite
{
	public var distance:Number = 30 + 100 * Math.random(); // 中央からの距離
	public var speed:Number = 1.5;	// スピード
 
	public function Line()
	{
		//　線の太さはランダム、色は白に近い色(好きな色で構わないです)
		graphics.lineStyle(Math.random() * 3, 0xEFEFEF);
 
		// 線の長さもランダム
		graphics.lineTo(10 + Math.random() * 20, 0);
 
		// 角度もランダム
		rotation = Math.random() * 360;
 
		// 青色に光るフィルターをかけておく
		this.filters = [new GlowFilter(0x009AD6, 1, 20, 20)];
	}
}
