/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/apny
 */

// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
        private var _label:MyTextField;

        public function FlashTest() {
            addEventListener(Event.ADDED, addedHandler);
			// ボタンを作成
            _build();
            
            // 自分流のイベントハンドラを記述ください
        }
		/*
		 * Flash IDEで開発する場合は、
		 * nameプロパティを利用してリスナー登録とかします。
		 */
		private function addedHandler(e:Event):void 
		{
			var btn:MyButton = e.target as MyButton;
			if (btn) {
				var name:String = btn.name.split('_')[1];
				name = "set" + name.substr(0,1).toUpperCase() + name.substr(1);
				if (this[name] is Function) {
					this[name](btn);
				}else {
					setDefaultBehavior(btn);
				}
			}	
		}
		private function  setBehaviourA(btn:MyButton):void 
		{
			btn.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void { 
				_label.text = "A がクリックされました";
			} );
			btn.addEventListener(MouseEvent.ROLL_OVER, function(e:MouseEvent):void { 
				_label.text = "A ロールオーバーされました";
			} );
		}
		private function setBehaviourB(btn:MyButton):void {
			btn.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void { 
				_label.text = "B がクリックされました";
			} );
			btn.addEventListener(MouseEvent.ROLL_OVER, function(e:MouseEvent):void { 
				_label.text = "B ロールオーバーされました";
			} );

		}
		private function setBehaviourC(btn:MyButton):void {
			btn.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void { 
				_label.text = "C がクリックされました";
			} );
			btn.addEventListener(MouseEvent.ROLL_OVER, function(e:MouseEvent):void { 
				_label.text = "C ロールオーバーされました";
			} );
		}
		private function  setDefaultBehavior(btn:MyButton):void 
		{
			throw new Error('no behavior');
		}
        /**
        * インターフェースを作る
        */
        private function _build():void {
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);

            _btnA = new MyButton();
			_btnA.name = "btnA_behaviourA";
            _btnA.text = "Button A"; 
            _btnA.x = 70; _btnA.y = 230;
            addChild(_btnA);
            
            _btnB = new MyButton();
			_btnB.name = "btnB_behaviourB";
            _btnB.text = "Button B";
            _btnB.x = 190; _btnB.y = 230;
            addChild(_btnB);
   
            _btnC = new MyButton();
            _btnC.name = "btnC_behaviourC";
            _btnC.text = "Button C";
            _btnC.x = 310; _btnC.y = 230;
            addChild(_btnC);
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}