/**
 * Copyright nash ( http://wonderfl.net/user/nash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aphj
 */

package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.ui.Mouse;
    import flash.utils.Timer;
    
    public class FlashTest extends Sprite {
        private var elements:Vector.<Ball> = new Vector.<Ball>();
        private var called:int = 0;
        private var square:Sprite = new Sprite();
        private var matrix:Matrix = new Matrix();
        private var startColor:uint = 0x00000;
        private var endColor:uint = 0x000033;
        private var startRatio:int = 64;
        private var endRatio:int = 127;
        
        public function FlashTest() {
            matrix.createGradientBox(455, 455, Math.PI / 2, 0, 0);
            square.graphics.beginGradientFill("linear", [startColor, endColor], [1.0, 1.0], [startRatio, endRatio], matrix);
            square.graphics.drawRect(0, 0, 455, 455);
            square.graphics.endFill();
            addChild(square);
            transform.perspectiveProjection.projectionCenter = new Point(232, 232);
            
            var timer:Timer = new Timer(30, 1800);
            timer.addEventListener(TimerEvent.TIMER, onTick); 
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete); 
            timer.start();
            
            addEventListener(MouseEvent.CLICK, onClicked);
        }
        
        private function onClicked(e:MouseEvent):void {
            transform.perspectiveProjection.projectionCenter = new Point(e.stageX, e.stageY);
        }
        
        private function onTick(e:TimerEvent = null):void {
            called++;
            
            if ((1800 - called) / 1800 > Math.random()) {
                var ball:Ball = new Ball();
                addChild(ball);
                elements.push(ball);
            }
            
            for (var i:int = 0; i<elements.length; i++) {
                elements[i].z += elements[i].speed;
                if (elements[i].z > 3000) {
                    removeChild(elements[i]);
                    elements.splice(i--, 1);
                }
            }
            
            var red:uint = endColor >> 16 & 0xFF;
            var green:uint = endColor >> 8 & 0xFF;
            var blue:uint = endColor & 0xFF;
            var color:uint = 0;
            
            if (called < 600) {
                blue = uint(((600 - called) / 600) * 33);
            } else if (called >= 600 && called < 1200) {
                red = uint(153 - ((1200  - (called - 600)) / 1200) * 153);
                green = uint(255 - ((1200 - (called - 600)) / 1200) * 255);
                blue = uint(255 - ((1200 - (called - 600)) / 1200) * 255);
                startRatio= uint(86 - ((1200 - (called - 600)) / 1200) * 86);
            }
            
            color += red   << 16;
            color += green <<  8;
            color += blue;

            endColor = color;

            
            square.graphics.beginGradientFill("linear", [startColor, endColor], [1.0, 1.0], [startRatio, endRatio], matrix);
            square.graphics.drawRect(0, 0, 455, 455);
            square.graphics.endFill();
            
        }
        
        private function onTimerComplete(e:TimerEvent = null):void {
            for (var i:int = 0; i<elements.length; i++) {
                removeChild(elements[i]);
                elements.splice(i--, 1);
            }
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
    public var speed:int = Math.random() * 100 + 10;
    
    public function Ball() {
        graphics.beginFill(0x1000000 * Math.random());
        graphics.drawCircle(0, 0, 10);
        graphics.endFill();
        x = Math.random() * 465;
        y = Math.random() * 465;
    }
}