/**
 * Copyright takawo ( http://wonderfl.net/user/takawo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/apHt
 */

// forked from bkzen's forked from: 100,000 Particles forked from: 250,000 Particles
// forked from bkzen's 100,000 Particles forked from: 250,000 Particles
// forked from bkzen's 250,000 Particles
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	import net.hires.debug.Stats;
	
	/**
	 * じゃぶじゃぶ
	 * アクティブ時：マウスの位置で動きが変わります。
	 * 非アクティブ時：マウスに関係なくジャブジャブします。
	 * @author jc at bk-zen.com
	 */
	[SWF (backgroundColor = "0x000000", width = "465", height = "465", frameRate = "60")]
	public class ParticleTest4 extends Sprite
	{
		private const NUM_PARTICLE: int = 50000;
		private var bmp: Bitmap;
		private var bmd: BitmapData;
		private var first: Particle;
		private var bmdRect: Rectangle;
		private var mem: ByteArray;
		private var colorTf: ColorTransform;
		private var mxy: Particle;
		private var isActivate: Boolean;
		private var cnt: int;
		
		public function ParticleTest4() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e: Event = null): void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//
			
			stage.quality = StageQuality.LOW;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			//
			bmd = new BitmapData(465, 465, false, 0x000000);
			var forceMap: BitmapData = new BitmapData(465, 465, false);
			forceMap.perlinNoise(
				116, 116, 2, Math.random() * 0xFFFFFF, false, true, BitmapDataChannel.RED | BitmapDataChannel.GREEN
			);
			bmp = new Bitmap(bmd, "auto", true);
			addChild(bmp);
			var prev: Particle = first = new Particle();
			var p: Particle, i: int;
			while (i++ <= NUM_PARTICLE)
			{
				p = new Particle();
				p.x = Math.random() * 465;
				p.y = Math.random() * 465;
				var rg: uint = Math.random() * 0xCC + 0x33;
				p.color = (rg << 16) | (rg << 8) | 0xFF;
				prev.next = p;
				prev = p;
			}
			bmdRect = bmd.rect;
			
			mem = forceMap.getPixels(forceMap.rect);
			i = 0;
			prev = mxy = new Particle();
			prev.x = 232 + 210 * Math.cos(i * Math.PI / 180);
			prev.y = 232 + 210 * Math.sin(i * Math.PI / 180);
			prev.y = ((prev.y >> 1) << 2) * 465;
			prev.x = ((prev.x >> 1) << 2) + prev.y;
			while ((i+=2) < 360)
			{
				p = new Particle();
				p.x = 232 + 210 * Math.cos(i * Math.PI / 180);
				p.y = 232 + 210 * Math.sin(i * Math.PI / 180);
				p.y = ((p.y >> 1) << 2) * 465;
				p.x = ((p.x >> 1) << 2) + p.y;
				prev.next = p;
				prev = p;
			}
			p.next = mxy;
			//colorTf = new ColorTransform(1, 1, 1, 1, -32, -16, -8);
			colorTf = new ColorTransform(1, 1, 1, 1, -32, -16, -8);
			addEventListener(Event.ENTER_FRAME, loop);
			addChild(new Stats());
			stage.addEventListener(Event.ACTIVATE, onActivate);
			stage.addEventListener(Event.DEACTIVATE, onDeactivate);
			mouseEnabled = mouseChildren = false;
		}
		
		private function loop(e:Event):void 
		{
			var p: Particle = first, address: int, offset: int, b: Boolean = (cnt++ % 3 == 0);
			if (b)
			{
				if (isActivate)
				{
					var mx: int = stage.mouseX, my: int = stage.mouseY;
					if (mx < 0) mx = 0;
					else if (mx > 465) mx = 456;
					if (my < 0) my = 0;
					else if (my > 465) my = 456;
					offset = ((my >> 1) << 2) * 465 + ((mx >> 1) << 2);
				}
				else 
				{
					mxy = Math.random() < 0.5 ? mxy.next : mxy;
					offset = mxy.x;
				}
			}
			bmd.lock();
			bmd.colorTransform(bmdRect, colorTf);
			while (p)
			{
				if (b)
				{
					address = ((p.y >> 1) << 2) * 465 + ((p.x >> 1) << 2) + offset;
					p.vx = p.vx * 0.40 + (( mem[address + 1] - 128) * p.m);
					p.vy = p.vy * 0.40 + (( mem[address + 2] - 128) * p.m);
				}
				p.x += p.vx;
				p.y += p.vy;
				if (p.x < 0 || p.x > 465 || p.y < 0 || p.y > 465) 
				{
    					p.x = Math.random() * 465;
    					p.y = Math.random() * 465;
    				}
				// if (p.x < 0) p.x += 465 * Math.random();
				// else if (p.x > 465) p.x -= 465 * Math.random();
				// if (p.y < 0) p.y += 465 * Math.random();
				// else if (p.y > 465) p.y -= 465 * Math.random();
				bmd.setPixel(p.x, p.y, p.color);
				p = p.next;
			}
			bmd.unlock();
		}
		
		private function onDeactivate(e: Event): void { isActivate = false; }
		private function onActivate(e: Event): void { isActivate = true; }
	}
}
class Particle
{
	public var  x: Number = 0,  y: Number = 0;
	public var vx: Number = 0, vy: Number = 0;
	//public var m: Number = Math.random() * 0.004 + 0.004;
	public var m: Number = Math.random() * 0.01 + 0.005;
	public var color: uint = 0xFFFFFF;
	public var next: Particle;
	
	function Particle() { }
}