/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aoXK
 */

/*
Notes:
More vectors, movable vectors
-->entity with tail, using cmd: curveTo and property: controlPoint
-->entity, enemy of player
-->mitochondria

Bugs:
entities creation outside boundaries.
entities position outside boundaries (>W + >H).
entities do not move (sometimes).
*/
package
{
    import flash.text.StyleSheet;
    import flash.events.MouseEvent;
    import flash.ui.Mouse;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(frameRate='125', backgroundColor='0x0044FF')]
    
    public class oneLife extends Sprite
    {
        public var debug:TextField;
        
        public var color:Array        =    new Array();
        public var world:world        =    new world();
        
        public var p:Array            =    new Array();
        public var center:Point       =    new Point(465/2, 465/2);
        public var worldsize:Point    =    new Point(2000, 2000);
        
        public var MAX_ENTITIES:int   =    59;
        
        
        public function oneLife() { init(); }
        
        public function init():void
        {
            /* initialize colors */
            color['bg']       =    0x0044FF;
            color['player']   =    0xFFFFFF;
            color['chain']    =    0xFFFFFF;
            color['virus']    =    0xFFFFFF;
            color['life']     =    0x00FF00;
            color['virus']    =    0x770077;
            color['enemy']    =    0xFF0000;
            color['cell']     =    0x0044FF;
            

            /* clear mouse */
            Mouse.hide();

            /* Build world */
            world.createWorld(color['bg'], worldsize.x, worldsize.y);
            addChild(world.getWorld);
            
            /* Build player entity */
            p[0]             =    world.createEntity(7, color['player'], 2, 3);
            world.getWorld.removeChild(p[0]);
            addChild(p[0]);
            p[0].x           =    center.x;
            p[0].y           =    center.y;
            p[0].drawPlayer();
            p[0].addEventListener(Event.ENTER_FRAME, function():void { moveTo(p[0], mouseX, mouseY, true); if (Math.random()<.007) drawBreath(); });
            //stage.addEventListener(Event.EXIT_FRAME, function():void { moveTo(p[0], p[0].x, p[0].y, false); });

            
            //drawBackground();
            
            /* stage runs */
            stage.addEventListener(Event.ENTER_FRAME, onRun);
            
            /* debugging only */
            debug     =    mainframe();
            var pos:TextField    =    mainframe();
            
            stage.addEventListener(MouseEvent.CLICK, drawBreath);
            
            var bg:Sprite    =    new Sprite();
            bg.graphics.beginFill(color['bg']);
            bg.graphics.drawRect(0, 0, stage.width, stage.height);
            bg.graphics.endFill();
            stage.addChildAt(bg, 0);
        }
        
        public function onRun(e:Event):void
        {
            if (world.obj.length <5) createLife();
            
            debug.text
            ="<h1><b>Number of objects:</b> " + world.obj.length
            +"\n<b>Mouse(</b>" + f(mouseX) + "<b>,</b> " + f(mouseY) + "<b>)</b> "
            +"\t<b>Player(</b>" + f(world.getWorld.x) + "<b>,</b> " + f(world.getWorld.y) + "<b>)</b> "
            +"\t<b>Target(</b>" + f(world.obj[2].x)+"<b>,</b> " + f(world.obj[2].y) + "<b>)</b></h1>"
            ;
            
            if (world.obj.length <= MAX_ENTITIES)
            {
                if (Math.random()<.05)    createRandom();
            }
            
        }
        
        public function drawBackground():void
        {
            for (var i:int=0; i<=300; i++)
            {
                var e:entity    =    createEntity(50, color['cell'], 10, 10);
                e.drawCell(p[0].x, p[0].y, 0.5);
                var r:Point=randomPoint();
                
                e.x    =    r.x;
                e.y    =    e.y;
                //addChild(e);
            }
        }

        
        public function zoom(pwr:int):void
        {
            //pwr is from 1 to 12
            //scale/p is from 0.5 to 1.6
            
            var o:Sprite;
            var p:Number=pwr+world.getWorld.scaleX;
            
            setScale(world.getWorld, p);
            
            for each(o in world.obj)
            {
                p=pwr+o.scaleX;
                setScale(o, pwr);
            }
        }
        
        public function setScale(o:Sprite, i:Number):void
        {
            o.scaleY=i;
            o.scaleX=i;
        }
        
        public function f(x:*):int { return x.toFixed(0); }

        public function createRandom():void
        {
            if (Math.random()<.8)
            {
                createLife();
            }else if (Math.random()<.4)
            {
                createVirus();
            }else{
                createRibosome();
            }
        }

        
        public function drawChain():void
        {
            var i:int=p.length+1;
            
            p[i]             =    world.createEntity(7, color['chain'], 0, 5);
            world.getWorld.removeChild(p[i]);
            addChild(p[i]);
            
            //var e:entity    =    createEntity(10, color['chain'], 10, 2);
            p[i].graphics.lineStyle(1, 0xDDDDDD);
            p[i].graphics.drawCircle(p[0].x, p[0].y, 5);

            p[i].x=p[i-1].x + rand(2);
            p[i].y=p[i-1].y + rand(2);
            
            p[i].addEventListener(Event.ENTER_FRAME, function(evt:Event):void
            {
                var e:*=evt.currentTarget;
                
                moveTo(e, p[i-1].x, p[i-1].y);
                
            });
        }

        public function drawBreath(e:MouseEvent=null):void
        {
            var b:Sprite    =    new Sprite();
            var pwr:Number  =    Math.random()*2;
            
            b.graphics.lineStyle(1, 0xDDDDDD, pwr);
            b.graphics.drawCircle(p[0].x, p[0].y, 1+pwr);
            
            b.addEventListener(Event.ENTER_FRAME, function():void
            {
                b.width+=0.01;
                b.height+=0.01;
                
                b.x=p[0]-rand(4);
                b.y-=Math.random()*5;
                b.alpha-=0.01;
                
                if (Math.random()<.001)    removeChild(b);
            });

            
            addChildAt(b, this.numChildren);
        }
        
        public function createLife():void
        {
            var e:entity    =    createEntity(7, color['life'], 1, 5);
            e.graphics.beginFill(e.color);
            e.graphics.drawCircle(e.x, e.y, e.size);
            e.graphics.endFill();
            
            e.goto=randomPoint();
            e.blur(10, 10, 1);
            
            e.addEventListener(Event.ENTER_FRAME, function(evt:Event):void
            {
                var e:*=evt.currentTarget;
                
                moveTo(e, e.goto.x, e.goto.y);
                
                if ( moveTo(e, e.goto.x, e.goto.y) == false)
                {
                    e.goto    =    randomPoint();
                }
            });
        }
        
        public function createVirus():void
        {
            var e:entity    =    createEntity(10, color['virus'], 1, 15);
            e.graphics.lineStyle(1, e.color);
            
            e.graphics.drawRect(0, 0, e.size, e.size);
            e.rotation+=45;

            e.goto=randomPoint();
            
            e.addEventListener(Event.ENTER_FRAME, function(evt:Event):void
            {
                var e:*=evt.currentTarget;
                moveTo(e, e.goto.x, e.goto.y);
                
                e.rotation+=1;
            });
        }
        
        public function createRibosome():void
        {
            var e:entity    =    createEntity(20, 0xFFFFFF, 0, 5);
            e.graphics.beginFill(e.color);
            e.graphics.drawCircle(e.x, e.y, 2);
            e.graphics.drawCircle(e.x, e.y+5, 2);
            e.graphics.drawCircle(e.x, e.y+10, 2);
            e.graphics.endFill();

            e.goto=randomPoint();
            
            e.rotation=Math.random()*180;
            e.addEventListener(Event.ENTER_FRAME, function(evt:Event):void
            {
                var e:*=evt.currentTarget;
                moveTo(e, e.goto.x, e.goto.y);
                
                if (Math.random()<.4)    e.goto    =    randomPoint();
            });
        }
        
        public function createEntity(_S:int, _c:uint, _s:int, _m:int):entity
        {
            var e:entity    =    world.createEntity(_S, _c, _s, _m);
            
            var p:Point    =    randomPoint();
            e.x      = p.x;
            e.y      = p.y;
            e.goto   = p;
            
            return e;
        }
        
        public function randomPoint():Point
        {
            var e:Point=new Point();
            e.x      = world.getWorld.x - (Math.random()*(worldsize.x));
            e.y      = world.getWorld.y - (Math.random()*(worldsize.y));
            
            return e;
        }
        
        public function moveTo(e:entity, x:int, y:int, panTo:Boolean=false):*
        {
            var dir:Number    =    Math.atan2(y-e.y, x-e.x)*180/Math.PI;

            var perc:Number;
            var getX:Number;
            var getY:Number;
            var disX:Number;
            var disY:Number;
            
            disX=(x-e.x<0)? Math.sqrt((x-e.x)*-1) : Math.sqrt(x-e.x);
            disY=(y-e.y<0)? Math.sqrt((y-e.y)*-1) : Math.sqrt(y-e.y);
            
            perc=Math.pow(disX+disY, 2) / 400;
            perc=(perc>1.2)? 1.2 : perc;
            
            getX = (Math.cos(dir*Math.PI/180) * (perc*e.speed));
            getY = (Math.sin(dir*Math.PI/180) * (perc*e.speed));
            
            var newx:Number    =    e.x + getX;
            var newy:Number    =    e.y + getY;
            
            var w:int    =    world.getWorld.x + world.getWorld.width;
            var h:int    =    world.getWorld.y + world.getWorld.height;
            
            var hit:*
            hit    =    world.hitAny(e);
            
            if (hit != false && !panTo)
            {
                dir      = Math.atan2(hit.y-e.y, hit.x-e.x)*180/Math.PI;
                getX     = (Math.cos(dir*Math.PI/180) * (hit.speed));
                getY     = (Math.sin(dir*Math.PI/180) * (hit.speed));
                
                e.x-=getX;
                e.y-=getY;
                return;
            }

            if (panTo)
            {
                e.x           =    center.x;
                e.y           =    center.y;
                e.rotation    =    135 + dir;
                
                if (e.x < world.getWorld.x)        world.getWorld.x     -=    worldsize.x;
                if (e.y < world.getWorld.y)        world.getWorld.y     -=    worldsize.y;
                
                if (e.x > world.getWorld.x+worldsize.x)    world.getWorld.x     +=    worldsize.x;
                if (e.y > world.getWorld.y+worldsize.y)    world.getWorld.y     +=    worldsize.y;
                     
                var zoomLevel:Number=(perc*e.size)/e.size;
                zoomLevel=(zoomLevel<1)? 1:zoomLevel;
                setScale(e, zoomLevel);
                
                world.getWorld.x-=getX;
                world.getWorld.y-=getY;
            }
            else{
                /*
                if (newx<0)                                            world.destroyEntity(e);
                if (newy<0)                                            world.destroyEntity(e);
                if (newx>0+worldsize.x)                                world.destroyEntity(e);
                if (newy>0+worldsize.y)                                world.destroyEntity(e);
                */
                if (e.x < world.getWorld.x)                                            e.x+=worldsize.x;
                if (e.y < world.getWorld.y)                                            e.y+=worldsize.y;
                if (e.x > world.getWorld.x+worldsize.x)                                e.x=1;
                if (e.y > world.getWorld.y+worldsize.y)                                e.y=1;
                
                if (e.x >= x+e.margin || e.x <= x-e.margin){
                if (e.y >= y+e.margin || e.y <= y-e.margin){
                    var result:Boolean=world.hitAny(e);
                    
                    e.x=newx;
                    e.y=newy;
                    
                }else{ return false; }
                }else{ return false; }
            }
        }
       
       public function rand(i:int=0):int { return (Math.random()>.5)? Math.random()*i : Math.random()*i; }

       private function collision():Boolean
       {
           /*
           search collision in every created entity.
           to create this effect: create a subclass that connects the main class + the entity class.
           u can create multiple entities, but you can only create ONE subclass.
           this subclass contains every entity ever created.
           
           using hittestObject u can see whether a certain object has touched something.
           it results FALSE if it hasnt touched anything;
           it results an object if it has touched the resulting object
           */
           return false;
       }

        private function mainframe():TextField
        {
            /*
            creates a textfield for debugging (mainframe).
            */
            var mainframe:TextField   =    new TextField();
            mainframe.width           =    stage.width;
            mainframe.height          =    100;
            mainframe.x               =    0;
            mainframe.y               =    0;
            
            var css:StyleSheet        =    new StyleSheet();
            css..parseCSS("h1 {font-family:Tahoma; color:#FFFFFF;}");
            mainframe.styleSheet      =    css;
           
            mainframe.mouseEnabled    =    false;
            addChild(mainframe);
            
            return mainframe;
        }
    }
}
import flash.filters.BlurFilter;

class world
{
    public var obj:Array    =    new Array();
    public var getWorld:Sprite;
    
    public function createWorld(_c:uint, _w:int, _h:int):Sprite
    {
        var w:Sprite    =    new Sprite();
        w.graphics.beginFill(_c);
        w.graphics.drawRect(0, 0, _w, _h);
        w.graphics.endFill();
        
        /* create offset */
        w.graphics.lineStyle(2, 0xFF0000, 0.1);
        for (var i:int=0; i<=_w; i+=100)
        {
            w.graphics.moveTo(i,1);
            w.graphics.lineTo(i, 2000);
            
            w.graphics.moveTo(1,i);
            w.graphics.lineTo(2000, i);
        }
        
        
        getWorld=w;
        return w
    }

    public function createEntity(_size:int=0, _color:uint=0, _speed:int=0, _margin:int=0):entity
    {
        var e:entity    =    new entity(_size, _color, _speed, _margin);
        getWorld.addChild(e);
        obj.push(e);
        
        return e;
    }
    
    public function hitAny(e:entity):*
    {
        for (var i:int=0; i<=obj.length-1; i++)
        {
            if (e == obj[i]) continue;
            
            if (e.hitTestObject(obj[i]))
            {
                return obj[i];
            }
        }
        return false;
    }
    
    public function destroyEntity(e:entity):void
    {
        getWorld.removeChild(e);
        obj.splice(obj.indexOf(e), 1);
    }
}


import flash.geom.Point;
import flash.display.Sprite;
class entity extends Sprite
{
    public var color:uint  =    0xFFFFFF;

    public var size:int    =    1;
    public var speed:int   =    0;
    public var margin:int  =    3;
    public var goto:Point  =    new Point(0, 0);
    
    public function entity(_size:int=0, _color:uint=0, _speed:int=0, _margin:int=0):void
    {
        this.size     =    (_size!=0)?   _size   : this.size;
        this.color    =    (_color!=0)?  _color  : this.color;
        this.speed    =    (_speed!=0)?  _speed  : this.speed;
        this.margin   =    (_margin!=0)? _margin : this.margin;
    }
    
    public function drawPlayer():void
    {
        this.graphics.lineStyle(2, color);
        
        this.graphics.lineTo(size, 0);
        this.graphics.moveTo(0, 0);
        this.graphics.lineTo(0,size);
        
        this.graphics.moveTo(size+(size/4), 0);
        this.graphics.lineTo(size+(size/4)+(size/2), 0);
        
        this.graphics.moveTo(0, size+(size/4));
        this.graphics.lineTo(0, size+(size/4)+(size/2));
    }
    
    public function drawChain():void
    {
        this.graphics.lineStyle(1, color);
        this.graphics.drawCircle(0, 0, 5);
    }
    
    public function blur(x:int, y:int, q:int):void
    {
        var blur:BlurFilter = new BlurFilter(x, y, q);
        this.filters           =    new Array(blur);
    }
    
    public function drawCell(x:int, y:int, q:Number):void
    {
        this.graphics.lineStyle(3, this.color*1.2);
        this.graphics.beginFill(this.color*1.5, q);
        this.graphics.drawCircle(x, y, this.size);
        blur(x, y, q);
    }
}

