/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aoJl
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    [ SWF( width=465, height=465, backgroundColor=0, framerate=60 ) ]
    public class FlashTest extends Sprite {
        
        private var grid: Array;
        private var sizeX: int = 200;
        private var sizeY: int = 200;
        private var bitmap: BitmapData = new BitmapData( sizeX, sizeY, true, 0 );
        private var background: BitmapData = new BitmapData( sizeX, sizeY, false, 0 );
        
        private var history: Array = [new State()];
        private var timesteps: Array = [];
        private var label: TextField;
        
        public function FlashTest() {
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            var bitmapInstance: Bitmap = new Bitmap(background);
            addChild(bitmapInstance);
            bitmapInstance.scaleX = bitmapInstance.scaleY = 465.0 / sizeX;
            
            bitmapInstance = new Bitmap(bitmap);
            addChild(bitmapInstance);
            bitmapInstance.scaleX = bitmapInstance.scaleY = 465.0 / sizeX;
            
            var format: TextFormat = new TextFormat();
            format.align = TextFormatAlign.LEFT;
            format.bold = true;
            format.font = "Arial";
            format.size = 20;
            
            label = new TextField();
            label.width = 400;
            label.x = 20;
            label.height = 100;
            label.y = 20;
            label.wordWrap = false;
            label.type = TextFieldType.DYNAMIC;
            label.textColor = 0x000000;
            label.selectable = false;
            label.mouseEnabled = false;
            label.defaultTextFormat = format;
            label.text = "";
            addChild( label );
            
            var i: int, j: int;
            
            grid = [];
            for (i = 0; i < sizeX; i++) {
                grid[ i ] = [];
                for (j = 0; j < sizeY; j++) {
                    var gx: Number = (i / sizeX) * 10.0;
                    var gy: Number = ((j / sizeY) * 2.0 - 1.0) * 5.0;
                    var difference: Number = Math.sin(gx) - gy;
                    grid[i][j] = Math.abs(difference) > 0.5;
                }
            }
            
            for (i = 0; i < sizeX; i++) {
                for (j = 0; j < sizeY; j++) {
                    background.setPixel(i, j, grid[i][j] ? 0xff0000 : 0xffffff);
                }
            }
        }
        
        public function onEnterFrame(event: Event): void {
            var i: int, j: int;
            
            for (j = 0; j < 100; j++) {
                var current: State = new State(history[history.length - 1]);
                
                if (history.length > timesteps.length) {
                    current.dir = Math.random() * 9;
                } else {
                    current.dir = timesteps[history.length-1].choose();
                }
                
                current.vel[0] += int(current.dir % 3) - 1;
                current.vel[1] += int(current.dir / 3) - 1;
                current.pos = add(current.pos, current.vel);
                history.push(new State(current));
                if (collided(current)) {
                    var utility: int = Math.max(current.pos[0], 0);
                    for (i = 1; i < history.length; i++) {
                        var timeIndex: int = i - 1;
                        if (timeIndex >= timesteps.length) {
                            timesteps[timeIndex] = new TimeStepRecord();
                        }
                        timesteps[timeIndex].utilitySum[history[i].dir] += utility;
                        timesteps[timeIndex].runCount[history[i].dir]++;
                    }
                    
                    history = [new State()];
                }
            }
            
            bitmap.lock();
            bitmap.fillRect(bitmap.rect, 0);
            for (i = 0; i < history.length; i++) {
                var s: State = history[i];
                bitmap.setPixel32(s.pos[0], s.pos[1], 0xff0000ff);
                bitmap.setPixel32(s.pos[0], s.pos[1] + 1, 0xff0000ff);
                bitmap.setPixel32(s.pos[0] + 1, s.pos[1], 0xff0000ff);
                bitmap.setPixel32(s.pos[0] + 1, s.pos[1] + 1, 0xff0000ff);
            }
            bitmap.unlock();
            
            //label.text = "" + timesteps[0].utilitySum;
        }
        
        public function collided(s: State): Boolean {
            if (s.pos[0] < 0) return true;
            if (s.pos[0] >= sizeX - 1) return true;
            if (s.pos[1] < 0) return true;
            if (s.pos[1] >= sizeY) return true;
            if (grid[s.pos[0]][s.pos[1]]) return true;
            return false;
        }
    }
}

class State {
    public var pos: Vector.<int> = new <int>[0, 100];
    public var vel: Vector.<int> = new <int>[0, 0];
    public var dir: int = 4;
    public function State(other: State = null): void {
        if ( other != null ) {
            pos = new <int>[other.pos[0], other.pos[1]]; vel = new <int>[other.vel[0], other.vel[1]]; dir = other.dir;
        }
    };
}

class TimeStepRecord {
    public var utilitySum: Vector.<int> = new <int>[1,1,1,1,1,1,1,1,1];
    public var runCount: Vector.<int> = new <int>[0,0,0,0,0,0,0,0,0];
    public function choose(): int {
        var i: int;
        var totalWeight: Number = 0.0;
        var weights: Vector.<Number> = new <Number>[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
        
        var tryStart: int = Math.random() * 9;
        for (i = 0; i < 9; i++) {
            var tryChoice: int = (tryStart + i) % 9;
            if (runCount[tryChoice] == 0) return tryChoice;
            var weight: Number = utilitySum[tryChoice] / runCount[tryChoice];
            weights[tryChoice] = weight;
            totalWeight += weight;
        }
        
        var selector: Number = Math.random() * totalWeight;
        for (i = 0; i < 9; i++) {
            selector -= weights[i];
            if (selector < 0.0) return i;
        }
        return 0;
    }
}

function add( a: Vector.<int>, b: Vector.<int> ): Vector.<int> { return new <int>[ a[ 0 ] + b[ 0 ], a[ 1 ] + b[ 1 ] ]; }
function subtract( a: Vector.<int>, b: Vector.<int> ): Vector.<int> { return new <int>[ a[ 0 ] - b[ 0 ], a[ 1 ] - b[ 1 ] ]; }
function multiply( a: Vector.<int>, b: int ): Vector.<int> { return new <int>[ a[ 0 ] * b, a[ 1 ] * b ]; }