/**
 * Copyright takashi08 ( http://wonderfl.net/user/takashi08 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ao1p
 */

// forked from seanhellwig's Circle Preloader
package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.net.URLRequest;

    [SWF(width="550", height="400", backgroundColor="#FFFFFF", frameRate="30")]
    public class CircleLoader extends Sprite {
        
            private var _loader:Loader = new Loader();
        private var _text:TextField;
            private var _circle:Sprite;
            private var _centerX:Number;
            private var _centerY:Number;
            private var _angle:Number = 0;
            private static const RADIUS:int = 50;
            
        //test image found on google images, using it because it is large in filesize.
            private static const TEST_IMAGE:String = "http://mms.space.swri.edu/MMSposter-large.jpg";

        
        public function CircleLoader() {
                _centerX =550 / 2;
                _centerY = 400 / 2;
    
            _circle = new Sprite();
                this.addChild(_circle);
            
            _text = new TextField()
            _text.htmlText = "000%";
            _text.autoSize = TextFieldAutoSize.LEFT;
            _text.x = _centerX - (_text.textWidth / 2);
            _text.y = _centerY - (_text.textHeight / 2);
            this.addChild(_text);
            
            
                _loader.contentLoaderInfo.addEventListener(Event.OPEN, onOpen);
                _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onProgress);
                _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
                //extra url query string added for no caching purposes
                _loader.load(new URLRequest(TEST_IMAGE+"?"+new Date().toString()));
        
            
        }
        
        private function onOpen(e:Event):void{
                _circle.graphics.clear();
              _circle.graphics.lineStyle(5.0, 0xFF0000);
            _circle.graphics.moveTo(_centerX + RADIUS, _centerY);
                
            trace("init");
                
        }
        
        
          private function onProgress(e:ProgressEvent):void {

            _angle = Math.round(360 * (e.bytesLoaded / e.bytesTotal));
            
            _angle = _angle * Math.PI / 180;
            
            var newX:Number = _centerX + Math.cos(_angle) * RADIUS;
            var newY:Number = _centerY + Math.sin(_angle) * RADIUS;
            if (!isNaN(newY) && !isNaN(newX)){
            
                _circle.graphics.lineTo(newX, newY);
            }
        
             _text.htmlText = Math.round((e.bytesLoaded / e.bytesTotal) * 100) + "%";
          }
          
          
          private function onComplete(e:Event):void{
            trace("load completed");
          }
    }
}