/**
 * Copyright moriyak ( http://wonderfl.net/user/moriyak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/anW2
 */

package 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 *　Quicksilverのアルゴリズムのjs移植(http://rails-oceania.googlecode.com/svn/lachiecox/qs_score/trunk/qs_score.js)
	 * のAS3移植。
	 * "hateb"とか
	 * "fladev"とか通ります。
	 */
	public class Main extends Sprite 
	{
		private var _applicationArray:Array;
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			_applicationArray = ["Flash", "FlashDevelop", "Photoshop", "Illustrator", "Quicksilver", "iTunes", "Word", "Excel", "PowerPoint", "RememberTheMilk", "Twitter", "Tumblr", "Emacs", "Meadow", "Firefox", "Thunderbird", "becky!", "Opera", "Safari", "Skype", "Google Chrome", "Chromium", "Flex Builder", "Evernote", "Gyazz", "Outlook", "Eclipse", "Dreamweaver", "NetBeans", "Vim", "CSSEdit", "xyzzy", "Hidemaru Editor", "Sakura Editor", "InDesign", "Fireworks", "GIMP", "Pages", "Keynote", "Numbers", "Mail", "VMWare Fusion", "Terminal", "VML Mmedia Player", "GOM Player", "Windows Media Player", "QuickTime Player", "KMPlayer", "foobar2000", "World of Warcraft ", "Warcraft III", "Teaam Fortress", "Spider Solitaire", "Call of Duty", "The Sims 3", "Half-Life 2", "Grand Theft Auto", "FaceBook", "Window Explorer", "Internet Explorer", "Window Live Messenger", "Gmail", "Youtube", "Google Reader", "Livedoor Reader", "Finder", "VisualStudio", "Adium", "Notepad++", "Notepad", "TextMate", "Coda", "SQL Server Management", "Xcode", "TextEdit", "GEdit", "ZendStudioClient", "Google Code", "FrientFeed", "Last.fm", "Digg", "MySpace", "Delicious", "Wonderfl", "Beautifl", "LoveJournal", "mixi", "Vimeo", "Ustream.tv", "Blip.fm", "Hatena Diary", "Hatena Bookmark", "Favotter", "FFFFOUND!", "We heart it", "Kotonoha", "Wassr", "Fastladder", "Windows Live Hotmail", "WebKit", "GEdit", "Zend Studio Client", "PSPad", "CodeGear RAD Studio", "EditPlus", "phpDesigner", "Visual C#", "Geany", "UltraEdit", "EmEditor", "Komodo IDE/Edit", "Notepad2", "MacVim", "CSSEdit", "BBEdit", "MOEditor", "Media Player Classic", "Winamp", "Zune", "DVD Player", "Hulu", "SMPlayer", "MPlayer", "RealPlayer", "Premiere Pro", "Front Row", "Totem", "Plex", "FL Studio", "wakoopa", "Nico Nico Douga", "Flash Player", "Miro", "boxee", "Dailymotion", "GNOME MPlayer", "Sleipnir", "Jane View", "Lunascape", "Netscape Navigator", "gikoNavi", "Craving Explorer", "Live2ch", "Jane Style", "ChromePlus", "TweetDeck", "Tweetie", "twhirl", "Prism", "Gmail Notifier", "Twit", "Google Notebook", "QWit", "AniDB", "MiniTwitter", "Facedesk", "Google Search", "Google Image Search", "eBay", "Bing", "Yandex", "Baidu", "Yahoo! Search", "Google Book Search", "Twitter Search", "Internet Archive", "Google Blog Search", "@nifty", "goo", "Technorati", "SAGOOL", "Flickr", "pixiv", "Yelp", "Hatena AnonymouseDiary", "Jaiku", "iddy", "zoome", "OKWave", "Wikipedia", "UncycloPedia", "WinSCP", "FlashGet", "Cyberduck", "Transmit", "Orbit Downloader", "SmartFTP", "FFFTP", "GNU wget", "Iria", "Irvine", "Bloglines", "FeedReader", "Vienna", "Feed43", "OpenOffice", "Google Docs", "Adobe Acrobat", "iCal", "Google Calendar", "Sticky", "Dictionary", "Automator", "PowerDVD", "DAEMON Tools", "A Bone", "Dropbox", "NTEmacs", "Xen", "Pixia", "Painter", "SAI", "Irfan View", "Afx", "cfiler", "GarageBand", "MacKeyHoleTV", "Camino"];
			var bg:Shape = new Shape();
			bg.graphics.beginFill(0x000000);
			bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			bg.graphics.endFill();
			this.addChild(bg);
			
			var sf:SearchField = new SearchField();
			sf.x = (stage.stageWidth - sf.width) / 2;
			sf.y = (stage.stageHeight - sf.height) / 2;
			this.addChild(sf);
			for each(var name:String in _applicationArray) {
				var tt:TargetText = new TargetText(name);
				sf.addTarget(tt);
				this.addChild(tt);
				do{
				tt.x = (stage.stageWidth-tt.width) * Math.random();
				tt.y = (stage.stageHeight - tt.height) * Math.random();
				} while (tt.hitTestObject(sf));
			}
			
			stage.focus = sf;
			
		}	
	}
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.events.TimerEvent;
import flash.filters.GlowFilter;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFieldType;
import flash.utils.Timer;
import flash.ui.Keyboard;
import caurina.transitions.Tweener;

//
// スコア算出クラス
//
//  http://rails-oceania.googlecode.com/svn/lachiecox/qs_score/trunk/qs_score.js
// Copyright (c) 2008 Lachie Cox
//
// の移植
//
class QSScore
{
	public static function evaluate(abbreviation:String, target:String, offset:Number=0 ):Number
	{
		var target:String = target.toLowerCase();
		var abbreviation:String = abbreviation.toLowerCase();
		if (abbreviation.length == 0) return 0.9;
		if (abbreviation.length > target.length) return 0.0;
		
		for (var i:int = abbreviation.length; i > 0; i--) {
			var subAbbreviation:String = abbreviation.substring(0, i);
			var index:int = target.indexOf(subAbbreviation);
			
			if (index < 0) continue;
			if (index + abbreviation.length > target.length + offset) continue;
			
			var nextString:String = target.substring(index + subAbbreviation.length);
			var nextAbbreviation:String  = null;
			
			if (i >= abbreviation.length) {
				nextAbbreviation = "";
			} else {
				nextAbbreviation = abbreviation.substring(i);
			}
			
			var remainingScore:Number = QSScore.evaluate(nextAbbreviation, target, offset + index);
			if (remainingScore > 0) {
				var score:Number = target.length - nextString.length;
				if (index != 0) {
					var c:Number = target.charCodeAt(index - 1);
					if (c == 32 || c == 9) {
						for (var j:int = (index - 2); j >= 0; j--) {
							c = target.charCodeAt(j);
							score -= ((c == 32 || c == 9) ? 1 : 0.15);
						}
					} else {
						score -= index;
					}
				}
				
				score += remainingScore * nextString.length;
				score /= target.length;
				return score;
			}
		}
		
		return 0.0;
	}
}

class SearchField extends TextField
{
	private var _resetTimer:Timer;
	private var _waitTimer:Timer;
	private var _targetArray:Array;
	
	public function SearchField()
	{
		_targetArray = new Array();
		
		this.addEventListener(KeyboardEvent.KEY_DOWN, _onKeyDown);
		
		_initTimer();
		_initFace();
	}
	
	private function _initTimer():void
	{
		_resetTimer = new Timer(5000);
		_waitTimer = new Timer(50);
		
		_resetTimer.addEventListener(TimerEvent.TIMER, _onReset);
		_waitTimer.addEventListener (TimerEvent.TIMER, _onWait);
	}
	
	private function _initFace():void
	{
		this.type = TextFieldType.INPUT;
		this.background = true;
		this.backgroundColor = 0x222222;
		
		var format:TextFormat = new TextFormat();
		format.color = 0xFFFFFF;
		format.bold = true;
		format.size = 25;
		format.align = "center";
		
		
		this.defaultTextFormat = format;
		this.height = this.textHeight + 10;
		this.width = 200;
		
	}
	
	private function _onKeyDown(e:KeyboardEvent):void
	{
		if ( !this.text ) return;

		_resetTimer.reset();
		_waitTimer.reset();
		
		if (e.keyCode == Keyboard.ENTER) {
			Tweener.removeAllTweens();
			this.text = "";
			
			var max:TargetText = _targetArray[0];
			for (var i:int = 1; i < _targetArray.length; i++) {
				var current:TargetText = _targetArray[i];
				if (max.score < current.score) {
					max = current;
					if (max.score == 1) break;
				}
			}
			max.scaleX = max.scaleY = 1.6;
			var origX:int = max.x;
			var origY:int = max.y;
			max.x -= max.width / 4;
			max.y -= max.height / 4;
			Tweener.addTween(max, { scaleX:1, scaleY:1, x:origX, y:origY, time:2, onComplete:update } );
			return;
		}

		_resetTimer.start();
		_waitTimer.start();
	}
	
	private function _onReset(e:Event):void
	{
		_resetTimer.stop();
		this.text = "";
		this.update();
	}
	
	private function _onWait(e:Event):void
	{
		_waitTimer.stop();
		this.update();
	}
	
	public function update():void
	{
		for (var i:int = 0; i < _targetArray.length; i++) {
			var target:TargetText = _targetArray[i];
			target.score = QSScore.evaluate(this.text, target.title);
			target.update();
		}
	}
	
	public function addTarget(t:TargetText):void
	{
		_targetArray.push(t);
	}
}

class TargetText extends Sprite
{
	private var _name:String;
	private var _score:Number;
	private var _needUpdate:Boolean;
	private var _face:Bitmap;
	
	public function TargetText(name:String)
	{
		this._name = name;
		this.alpha = 0.2;
		
		_initFace();
	}
	
	private function _initFace():void
	{
		var tf:TextField = new TextField();
		tf.text = this._name;
		tf.autoSize = TextFieldAutoSize.LEFT;
		tf.background = false;
		
		var format:TextFormat = new TextFormat();
		format.color = 0xFFFFFF;
	
		tf.setTextFormat(format);
		tf.filters = [new GlowFilter(0x888888)];

		var faceData:BitmapData = new BitmapData(tf.width, tf.height, true, 0x00000000);
		faceData.draw(tf);
		
		this._face = new Bitmap(faceData);
		this.addChild(_face);
	}
	
	
	public function update():void
	{
		if (this._needUpdate) {
			Tweener.addTween(this, { alpha:_score, time:0.4 } );
			_needUpdate = false;
		}
	}
	
	public function get title():String { return _name; }
	
	public function set score(value:Number):void 
	{
		if (value == _score) return;
		
		_score = (value == 0.9) ? 0.2 : value;
		_needUpdate = true;
	}
	
	public function get score():Number { return _score; }
}