/**
 * Copyright Cao ( http://wonderfl.net/user/Cao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/amQv
 */

package 
{
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.*;
import flash.media.Camera;
import flash.media.Video;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.text.TextField;

public class AS3EdgeAndMotion extends Sprite
{
    private var video:Video;
    private var motionBM:Bitmap;
    private var edgeBM:Bitmap; // the output bitmap for the gradient filter    
    var prevBitmapData:BitmapData;
    
    // these are just labels
    private var inputTxt:TextField;
    private var edgeTxt:TextField;
    private var motionTxt:TextField;
    private var errTxt:TextField;
    private var msgTxt:TextField;
    
    
    public function AS3EdgeAndMotion()
    {
        stage.scaleMode = StageScaleMode.EXACT_FIT;
        stage.align = StageAlign.TOP_LEFT;
        
        try {
        var camera:Camera = Camera.getCamera();
        camera.setMode(256, 196, 15);
        if (camera != null)
        {
               // setup camera and bitmaps
            video = new Video(camera.width, camera.height);
            video.attachCamera(camera);
            video.x = 8;
            video.y = 8;
            addChild(video);
            video.addEventListener(Event.ENTER_FRAME, update);
            
            motionBM = new Bitmap();
            addChild(motionBM);
            motionBM.x = video.x + video.width + 8;
            motionBM.y = video.y;
            
            
            edgeBM = new Bitmap();
            addChild(edgeBM);
            edgeBM.x = video.x;
            edgeBM.y = video.y + video.height+ 8;
            
            prevBitmapData = new BitmapData(video.width, video.height);
            
            // setup labels
            inputTxt = new TextField();
            inputTxt.x = video.x+10;
            inputTxt.y = video.y+10;
            inputTxt.htmlText = "<font face='Arial'>Input Video</font>";
            addChild(inputTxt);
            
            edgeTxt = new TextField();
            edgeTxt.x = edgeBM.x+10;
            edgeTxt.y = edgeBM.y+10;
            edgeTxt.textColor = 0xFFFFFF;
            edgeTxt.htmlText = "<font face='Arial'>Edge Detector</font>";
            addChild(edgeTxt);

            motionTxt = new TextField();
            motionTxt.x = motionBM.x+10;
            motionTxt.y = motionBM.y+10;
            motionTxt.textColor = 0xFFFFFF;
            motionTxt.htmlText = "<font face='Arial'>Motion Detector</font>";
            addChild(motionTxt);

            }
        else { showErrMsg();}} 
        catch (e:*){ showErrMsg(); }
        
        msgTxt = new TextField;
        msgTxt.x = 280;
        msgTxt.y = 220;
        msgTxt.textColor = 0x0;
        msgTxt.width = 200;
        msgTxt.multiline = true;
        msgTxt.wordWrap = true;
        msgTxt.htmlText = "<font face='Arial'>If you can't see any video, Flash can't find your camera. If you have a camera, check your Flash Player settings.</font>";
        addChild(msgTxt);
    }
    
    private function showErrMsg():void
    {
        errTxt = new TextField();
        errTxt.x = 100;
        errTxt.y = 100;
        errTxt.textColor = 0xFF0000;
        errTxt.htmlText = "<font face='Arial'>No Camera Detected!!!</font>";
        addChild(errTxt);
    }
    
    private function update(e:Event):void
    {
        var x:int;
        var y:int;
        var p:uint;
        var p2:uint;
        var p3:uint;
        var r:int;
        var g:int;
        var b:int;
        var r2:int;
        var g2:int;
        var b2:int;
        var r3:int;
        var g3:int;
        var b3:int;
        var outR:int;
        var outG:int;
        var outB:int;
        var diff:int;
        
        var inputBitmap:BitmapData = new BitmapData(video.width, video.height);
        inputBitmap.draw(video);
        
        var newMotionBM:BitmapData = new BitmapData(video.width, video.height);
        var newEdgeBM:BitmapData = new BitmapData(video.width, video.height);
        
        // motion detector
        for(y = 0; y < inputBitmap.height; ++y)
        {
            for(x = 0; x < inputBitmap.width; ++x)
            {
                p = inputBitmap.getPixel(x, y);
                r = (p & 0xFF0000) >> 16;
                g = (p & 0x00FF00) >> 8;
                b = (p & 0x0000FF);
                
                p2 = prevBitmapData.getPixel(x, y);
                r2 = (p2 & 0xFF0000) >> 16;
                g2 = (p2 & 0x00FF00) >> 8;
                b2 = (p2 & 0x0000FF);
                
                diff = Math.min(255, (2 * Math.abs(r - r2) + 2 * Math.abs(g - g2) + 2 * Math.abs(b - b2)) / 3);
                
                outR = diff;
                outG = diff;
                outB = diff;
                
                newMotionBM.setPixel(x, y, (outR << 16) + (outG << 8) + outB);
            }
        }
        
        // edge detector
        for(y = 0; y < inputBitmap.height -1; ++y)
        {
            for(x = 0; x < inputBitmap.width -1; ++x)
            {
                p = inputBitmap.getPixel(x, y);
                r = (p & 0xFF0000) >> 16;
                g = (p & 0x00FF00) >> 8;
                b = (p & 0x0000FF);
            
                p2  = inputBitmap.getPixel(x +1, y);
                r2 = (p2 & 0xFF0000) >> 16;
                g2 = (p2 & 0x00FF00) >> 8;
                b2 = (p2 & 0x0000FF);
                
                p3  = inputBitmap.getPixel(x, y + 1);
                r3 = (p3 & 0xFF0000) >> 16;
                g3 = (p3 & 0x00FF00) >> 8;
                b3 = (p3 & 0x0000FF);
                
                diff = Math.min(255, (2 * Math.abs(r - r2) + 2 * Math.abs(g - g2) + 2 * Math.abs(b - b2)) / 3);
                diff += Math.min(255, (2 * Math.abs(r - r3) + 2 * Math.abs(g - g3) + 2 * Math.abs(b - b3)) / 3);
            
                if( diff > 100 ) 
                    newEdgeBM.setPixel(x, y,0xFFFFFF);
                else
                    newEdgeBM.setPixel(x, y, 0x0);
            }
        }
        
        motionBM.bitmapData = newMotionBM;
        edgeBM.bitmapData = newEdgeBM;
        prevBitmapData = inputBitmap.clone(); 
    }
}}