/**
 * Copyright seikimaiii ( http://wonderfl.net/user/seikimaiii )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/amLq
 */

package
{
    import flash.utils.ByteArray;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.system.Security;
    import frocessing.color.ColorHSV;
    import flash.filters.BlurFilter;
    
    [SWF(frameRate="30",backgroundColor=0xFFFFFF)]
    
    public class AudioVisualizer extends MovieClip
    {
        private var _sound:Sound;
        private var _channel:SoundChannel;
        
        private var _timer:Timer;
        
        private var _resolution:Number = 16;
        private var _steps:Number;
        private var _width:Number;
        
        private var _bytes:ByteArray;
        
        private var _heights:Array;
        private var _freqs:Array;        
        
        //                                         h - [0, 360]
        //                                            s - [0, 1]
        //                                               v - brightness [0, 1]
        private var _color:ColorHSV = new ColorHSV(300, 1, 1);
        
        public function AudioVisualizer()
        {
            Security.loadPolicyFile("http://music.lunchbin.com/crossdomain.xml");
            
            _heights = new Array();
            _freqs = new Array();
            _bytes = new ByteArray();
            
            _steps = 256/_resolution;
            _width = 400/_resolution;
            
            for (var i:uint = 0; i < _steps; i++)
            {
                _heights[i] = 0;
            }
            
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, OnLoadComplete);
            _sound.load(new URLRequest("http://music.lunchbin.com/demo/mad_wasd - PWSteal.mp3"));
            
            _timer = new Timer(33.33); //30fps
            _timer.addEventListener(TimerEvent.TIMER, Tick);
            _timer.start();
        }
        
        public function OnLoadComplete(e:Event):void
        {
            _channel = _sound.play(0, 100, null);
        }

        // Main loop
        public function Tick(e:TimerEvent):void
        {
            if (_channel != null)
            {
                graphics.clear();              
                
                _bytes.position = 0;
                SoundMixer.computeSpectrum(_bytes, true);
                
                for (var i:uint = 0; i < _steps; i++)
                {
                    var l:Number = 0;
                    var r:Number = 0;
                    
                    //if (i < _steps/2)
                    //{
                    //    l = GetAvg(_bytes, i*_resolution*4, _resolution);
                    //    r = GetAvg(_bytes, i*_resolution*4 + 1024, _resolution);
                    //}
                    //else
                    //{
                        l = GetMax(_bytes, i*_resolution*4, _resolution);
                        r = GetMax(_bytes, i*_resolution*4 + 1024, _resolution);
                    //}
                    
                    var avg:Number = (l + r) / 2;
                    var n:Number = (avg * 200);
                    
                    if (n > _heights[i])
                    {
                        _heights[i] = n;
                    }
                    else
                    {
                        if (_heights[i] > 0)
                        {
                            _heights[i] -= (_heights[i]) * 0.05;
                        }
                        if (_heights[i] < 0)
                        {
                            _heights[i] = 0;
                        }
                    }
                    
                    _color.h = int((_heights[i]/200) * 360);
                    //_color.v = (_heights[i]/200) + 0.5;
                    
                    //graphics.beginFill(0xFFFFFF, (_heights[i]/200));
                    graphics.beginFill(_color.value);
                    graphics.drawRect(i*_width, 200, _width, -1 * _heights[i]);
                    graphics.endFill();
                }
            }
        }
        
        public function GetAvg(bytes:ByteArray, start:Number, length:Number):Number
        {
            var avg:Number = 0;
            bytes.position = start;
            for (var i:uint = 0; i < length; i++)
            {
                avg += bytes.readFloat();
            }
            avg /= length;
            return avg;
        }
        
        public function GetMax(bytes:ByteArray, start:Number, length:Number):Number
        {
            var max:Number = 0;
            bytes.position = start;
            for (var i:uint = 0; i < length; i++)
            {
                var test:Number = bytes.readFloat();
                if (test > max)
                {
                    max = test;
                }
            }
            return max;
        }

    }
}
















