/**
 * Copyright IPFix ( http://wonderfl.net/user/IPFix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/amL7
 */

// forked from Gobelins_IPFix's alternativa test01b : change fillmaterial
// forked from Gobelins_IPFix's alternativa test01 : box, fillmaterial and "cellshading"
package {
    import flash.events.MouseEvent;
    
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    import frocessing.color.ColorHSV;
    
    [SWF(backgroundColor="#DDDDDD", width="465", height="465", frameRate="60")]
    public class HelloAlternativa3D extends Sprite {
        
        private var rootContainer:Object3DContainer = new DistanceSortContainer();
        
        private var camera:Camera3D;
        private var color:ColorHSV;
        
        private var boxs:Vector.<Box>;
        
        public function HelloAlternativa3D() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            color = new ColorHSV(0);  
            
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            camera.rotationX = -120*Math.PI/180;
            camera.y = -800;
            camera.z = 600;
            rootContainer.addChild(camera);
            
            boxs = new Vector.<Box>();
            var material:FillMaterial = new FillMaterial(color.value, 1, 1,0xFFFFFF);
            for( var i:int = 0; i < 10; i++ ){
                for( var j:int = 0; j < 10; j++ ){
                    var box:Box = new Box(200, 200, 200, 1, 1, 1);
                    box.x = -1200+260*i;
                    box.y = 260*j;
                    boxs.push( box );
                    box.setMaterialToAllFaces(material);
                    rootContainer.addChild(box);
                }
            }
            
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
            
            camera.render();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var colortmp:int = color.h;
            for( var i:int = 0; i < 10; i++ ){
                for( var j:int = 0; j < 10; j++ ){
                    var material:FillMaterial = new FillMaterial(color.value, 1, 1,0xFAFAFA);
                    var box:Box = boxs[i+j*10];
                    //box.rotationX +=.04;
                    box.setMaterialToAllFaces(material);
                    color.h++;
                }
            }
            rootContainer.rotationY++;
            color.h = colortmp+=2;
            camera.render();
        }

        
        private function onMove(e:MouseEvent):void {
          //  camera.x = (e.stageX/stage.stageWidth)*1600-1600;
            camera.z = (e.stageX/stage.stageWidth)*600+600;
            camera.y = -900-(e.stageY/stage.stageHeight)*900;
            //render on enterframe 
            //camera.render();
        }
    }
}
