/**
 * Copyright Merd ( http://wonderfl.net/user/Merd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/alRA
 */

// forked from Merd's 3ARM DRAWING
// forked from matacat's forked from: flash on 2011-2-4
package
{
    import flash.display.AVM1Movie;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    
    import com.bit101.components.*;
    
    //[SWF(width="800",height="600",frameRate=60)]
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite
    {
        private const D2R:Number = Math.PI / 180;

        private var canvas:Sprite     = new Sprite();
        private var canvasBitmap:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
        
        private var myCenterX:Number = stage.stageWidth/2;
        private var myCenterY:Number = stage.stageHeight/2;
        
        private var myDot:Dot;
         
        private var myOuterCircle:Circle;
        private var myInnerCircle:Circle;
        
        private var R:Number = 150;
        private var r:Number = 20;
        private var d:Number = 50;
        
        private var Angle:Number = 0;
        private var Omega:Number = 2;
        private var myDotRadius:Number = 2;
        private var myDotColor:uint = 0xFFFFFF;
        
        private var myMatrix:Matrix = new Matrix;        
        
        private var canvasIsBlurred:Boolean = false;
        
        private var myUIPanel:Panel;
        private var myDSlider:HUISlider;
        private var myRSlider:HUISlider;
        private var myrSlider:HUISlider;
        private var myDotRadiusSlider:HUISlider;
        private var myColorChooser:ColorChooser;
        private var myResetButton:PushButton;
        
        /*
        private var myArm1OmegaSlider:HUISlider;
        
        private var myArm2LengthSlider:HUISlider;
        private var myArm2OmegaSlider:HUISlider;
        
        private var myArm3LengthSlider:HUISlider;
        private var myArm3OmegaSlider:HUISlider;
        
        private var myArmWidthSlider:HUISlider;
        private var myRandomizeColorsButton:PushButton;
        private var myBlurToggleButton:PushButton;
        
        */
        
        public function FlashTest()
        {
            canvas.addChild(new Bitmap(canvasBitmap));
            addChild(canvas);
            
            myOuterCircle = new Circle( myCenterX, myCenterY, R);
            myInnerCircle = new Circle( myCenterX, myCenterY, r);
            
            canvas.addChild(myOuterCircle);
            canvas.addChild(myInnerCircle);
            
            myDot = new Dot(myDotRadius, myDotColor);
            addChild(myDot);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
         
             initControls();
        }
        
        private function initControls():void
        {
            myUIPanel = new Panel(this,0,0);
            myUIPanel.color = 0x222222;
            myUIPanel.width = 200;
            myUIPanel.height = stage.stageHeight;
            myUIPanel.alpha = .25;

            myDSlider = new HUISlider(myUIPanel,0,0,"d", updateProperties);
            myDSlider.minimum = 0;
            myDSlider.maximum = 200;
            myDSlider.value = d;
            
            myRSlider = new HUISlider(myUIPanel,0,0,"R", updateProperties);
            myRSlider.minimum = 0;
            myRSlider.maximum = 200;
            myRSlider.y = 20;
            myRSlider.value = R;
            
            myrSlider = new HUISlider(myUIPanel,0,0,"r", updateProperties);
            myrSlider.minimum = 0;
            myrSlider.maximum = 200;
            myrSlider.y = 40;
            myrSlider.value = r;
            
            myColorChooser = new ColorChooser(myUIPanel,0,0,myDotColor, updateProperties);
            myColorChooser.y = 100;
            myColorChooser.usePopup = true;
            
            myDotRadiusSlider = new HUISlider(myUIPanel,0,0,"Dot R", updateProperties);
            myDotRadiusSlider.minimum = 1;
            myDotRadiusSlider.maximum = 25;
            myDotRadiusSlider.y = 60;
            myDotRadiusSlider.value = myDotRadius;
            
            
            /*
            myArmWidthSlider = new HUISlider(myUIPanel,0,60,"Arm Width", updateArmProperties);
            myArmWidthSlider.minimum = 1;
            myArmWidthSlider.maximum = 32;
            myArmWidthSlider.value = lineWidth;
            
            myRandomizeColorsButton = new PushButton(myUIPanel,0,80,"Rand Colors", randomizeColors);
            myBlurToggleButton = new PushButton(myUIPanel,150,80,"Blur", toggleBlur);
            */
            
            myResetButton = new PushButton(myUIPanel,0,80,"RESET", resetHandler);
            
            
        }
        
        private function onEnterFrame(e:Event):void
        {
            
            //myDot.graphics.clear();
            //myDot.graphics.moveTo(myCenterX, myCenterY);
            
           
            
            /*
            moveArm(myCenterDot, myArm1Dot);
            moveArm(myArm1Dot, myArm2Dot);
            moveArm(myArm2Dot, myArm3Dot);
            
            canvasBitmap.draw(line, null, null, BlendMode.ADD);
            */
            
            moveCircle(myInnerCircle);
            
            //myDot.graphics.clear();
          
            //canvasBitmap.draw(myDot, null, null, BlendMode.ADD);
            
            var tmpShape:Sprite = new Sprite();
            //tmpShape.graphics.lineStyle(1,0xFFFFFF);
            tmpShape.graphics.beginFill(myDot.color,.5);
            tmpShape.graphics.drawCircle(myDot.x,myDot.y,myDotRadius);
            
            
            //addChild(tmpShape);
            
            canvasBitmap.draw(tmpShape,null,null, BlendMode.ADD);
            
            //myMatrix.translate(myDot.x,myDot.y);
            
            //canvasBitmap.draw(myDot,myMatrix,null,BlendMode.ADD);
            
        }
        
        
        private function resetHandler(e:Event):void
        {
            canvasBitmap.fillRect(canvasBitmap.rect,0xFF000000);
        }

        
        private function toggleBlur(e:Event):void
        {
            if(canvasIsBlurred == false)
            {
                canvas.filters = [new BlurFilter(2, 2)];
                canvasIsBlurred = true;
            }
            else {
                canvasIsBlurred = false;
                canvas.filters = [new BlurFilter(0, 0)];
            }

 
        }

         /*
        private function randomizeColors(e:Event):void
        {
            myArm1Dot.color = Math.random() * 0xFFFFFF;
            myArm2Dot.color = Math.random() * 0xFFFFFF;
            myArm3Dot.color = Math.random() * 0xFFFFFF;
        }
        */
        
        private function updateProperties(e:Event):void
        {
            d = myDSlider.value;
            R = myRSlider.value;
            r = myrSlider.value;
            
            myDotRadius = myDotRadiusSlider.value; 
            myDot.color = myColorChooser.value;
            
            myOuterCircle.redrawCircle(R);
            myInnerCircle.redrawCircle(r);
        }


        public function moveCircle( whatCircle:Circle ):void
        {
            
            var radian:Number = Angle * D2R;
            
            myDot.x = (Math.cos(radian)*(R-r)) + (d*Math.cos( ((R-r)/r)*radian ));
            myDot.y = (Math.sin(radian)*(R-r)) + (d*Math.sin( ((R-r)/r)*radian ));
            
            myDot.x += myCenterX;
            myDot.y += myCenterY;
            
            whatCircle.x = (Math.cos(radian)*(R-r)) + myCenterX;
            whatCircle.y = (Math.sin(radian)*(R-r)) + myCenterY;
         
            Angle += Omega;
            
        }
    
    }
}

import flash.display.Shape;

class Dot extends Shape
{
    public var radius:Number;
    public var color:uint;
    
    public function Dot(radius:Number, color:uint)
    {
        this.radius = radius;
        this.color = color;
        
        graphics.beginFill(color, 1);
        graphics.drawCircle(0, 0, radius);
    }
}

import flash.display.Shape;

class Circle extends Shape
{
    public var startingX:Number;
    public var startingY:Number;
    public var radius:Number;  
    
    public function Circle(startingX:Number, startingY:Number, radius:Number)
    {
        this.x = startingX;
        this.y = startingY;
        
        this.startingX  = startingX;
        this.startingY  = startingY;
        this.radius  = radius;
        
        graphics.lineStyle(1,0xFFFFFF,0.1,false);
        graphics.beginFill(0xFFFFFF, 0.1);
        graphics.drawCircle(0, 0, radius);
    }
    
    public function redrawCircle( radius:Number ):void
    {
        this.graphics.clear();
        graphics.lineStyle(1,0xFFFFFF,0.1,false);
        graphics.beginFill(0xFFFFFF, 0.1);
        graphics.drawCircle(0, 0, radius);
    }

}