/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/alKJ
 */

// forked from kazutoyo's Bubbles
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.GradientType;
	import flash.events.StatusEvent;
	import flash.geom.Matrix;
	
	/**
	 * ...
	 * @author kazutoyo@富山商船コンピュータ部
	 * 富山高専に合併したので、富山高専(射水)コンピュータ部になりました。
	 */
	public class Main extends Sprite 
	{
		private const w:Number = stage.stageWidth;
		private const h:Number = stage.stageHeight;
		private const bigBubbleNum:int = 8;
		private var background:Sprite = new Sprite();
		private var bubbles:Array = new Array();
		private var count:int = 0;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			//背景を描くよ
			var gradType:String = GradientType.LINEAR;
			var colors:Array = [0x61cbf3, 0x12276a];
			var alphas:Array = [1, 1];
			var ratios:Array = [127, 255];
			var angle:Number = 90 * Math.PI / 180;
			var mtx:Matrix = new Matrix();
			mtx.rotate(angle);
			background.graphics.beginGradientFill(gradType, colors, alphas, ratios, mtx);
			background.graphics.drawRect(0, 0, w, h);
			this.addChildAt(background,0);
			this.initBubbles();
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		//泡々つくる
		private function initBubbles():void {
			var n:int = 20;
			var i:int;
			for (i = 0; i < n; i++) {
				//大きいのと小さいのつくる
				if(i < bigBubbleNum){
					bubbles[i] = makeBubble(Math.random() * w, Math.random() * h);
				}else {
					bubbles[i] = makeCircle(0xffffff,
										  0,
										  0,
										  Math.random() * 10+5);
					bubbles[i].x = Math.random() * w;
					bubbles[i].y = Math.random() * h;
					background.addChild(bubbles[i]);
				}
			}
		}
		
		private function onEnterFrame(e:Event):void {
			var n:int = bubbles.length;
			var i:int;
			for (i = 0; i < n; i++) {
				bubbles[i].y -= bubbles[i].width / 20;
				//適当にうごかすちょ
				if ( i < bigBubbleNum) bubbles[i].x += Math.cos(count / bubbles[i].width) * 5;
				//泡が上までいったとき
				if (bubbles[i].y + bubbles[i].height < 0) {
					if (i < bigBubbleNum) {
						background.removeChild(bubbles[i]);
						bubbles[i] = makeBubble(0, 0);
					}
					bubbles[i].y = h;
					bubbles[i].x = Math.random() * w;
					bubbles[i].alpha = 1.0;
				}
			}
			count += 1;
			if (count >= 360) count = 0;
		}
		
		private function makeBubble(x:Number, y:Number ):Sprite {
			var n:int = Math.random() * 8 + 2;
			var i:int;
			var s:Sprite = makeCircle(0x009bf4, 0, 0, n * 10);
			s.x = x;
			s.y = y; 
			background.addChild(s);
			for (i = n; i > 0; i--) {
				var bb:Sprite;
				if (i % 2 != 0) {
					bb = makeCircle(0x009bf4, 0, 0, initSize(i, n));
					bb.x = 0;
					bb.y = 0;
					s.addChildAt(bb, s.numChildren);
				}else {
					bb = makeCircle(0xffffff, 0, 0, initSize(i, n));
					bb.x = 0;
					bb.y = 0;
					s.addChildAt(bb, s.numChildren);
				}
			}
			return s;
		}
		
		private function initSize(i:int, n:int):Number {
			var size:Number = i * 5 + Math.random() * i * 5;
			if (size < 5) size = i * 5 + Math.random() * i * 5; //半径5より小さいとだめ！
			if (size > n*2) size = i * 5 + Math.random() * i * 5; //大きすぎてもだめ！
			return size;
		}
		
		//円をつくるよー
		private function makeCircle(color:uint = 0x000000, x:Number = 0, y:Number = 0, radius:Number = 0, alpha:uint = 1.0):Sprite {
			var b:Sprite = new Sprite();
			b.graphics.beginFill(color, alpha);
			b.graphics.drawCircle(x, y, radius);
			b.graphics.endFill();
			
			return b;
		}
		
	}
	
}