/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/akq9
 */

// forked from makc3d's glowing arcs + mp3
package {
    import com.bit101.components.CheckBox;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.filters.BlurFilter;
    import flash.display.*;
    /**
     * Another normalizer test.
     */
    [SWF(backgroundColor=0)]
    public class Swirling extends Sprite {
        public var mp3:ClientMP3Loader;
        public var song:SoundChannel;
        public var lt:Sprite, rt:Sprite;
        public var useNormalizers:CheckBox;
        public function Swirling () {
            mp3 = new ClientMP3Loader;
            mp3.addEventListener (Event.COMPLETE, loaded);

            addChild (lt = new Sprite).x = 232; lt.y = 232;
            addChild (rt = new Sprite).x = 232; rt.y = 232;

            stage.addEventListener (MouseEvent.CLICK, click);
            stage.addEventListener (Event.ENTER_FRAME, loop);

            useNormalizers = new CheckBox (this, 10, 10, "USE NORMALIZATION", function (e:Event):void {
                e.stopImmediatePropagation ();
            });

            graphics.beginFill (0); graphics.drawRect (0, 0, 465, 465);
        }
        public function click (e:MouseEvent):void {
            mp3.load ();
        }
        public function loaded (e:Event):void {
            if (song) song.stop ();
            song = mp3.sound.play (0, int.MAX_VALUE);
        }
        public var ba:ByteArray = new ByteArray;
        public var bn:Vector.<Normalizer> = new Vector.<Normalizer> (256);
        public function loop (e:Event):void {
            SoundMixer.computeSpectrum (ba, true);
            var blurr:BlurFilter = new BlurFilter(6,6,3);
            var n:int = 3, r:int = 2, a:Number, da:Number, v:Number;
            var i_lt:int = 0;
            var i_rt:int = 0;
            this.filters = [blurr];
            this.blendMode = BlendMode.ADD;
            this.
            lt.graphics.clear ();
            rt.graphics.clear ();
            while ((i_lt < 128) || (i_rt < 128)) {
                a = n; da = 2 * Math.PI / n;
                for (var j:int = 0; j < n; j++) {
                    a += da;
                    if ((r % 2 > 0) && (i_lt < 128)) {
                        ba.position = 4 * i_lt;
                        v = ba.readFloat ();
                        if (bn [i_lt] == null) bn [i_lt] = new Normalizer;
                        if (useNormalizers.selected) v = bn [i_lt].f (v);
                        drawArc (lt, a - 0.4 * da, a + 0.4 * da, 20 * r - 5, 20 * r + 5, hsl2rgb (r * 30, v)); i_lt++;
                    } else if (i_rt < 128) {
                        ba.position = 4 * (i_rt + 256);
                        v = ba.readFloat ();
                        if (bn [i_rt + 128] == null) bn [i_rt + 128] = new Normalizer;
                        if (useNormalizers.selected) v = bn [i_rt + 128].f (v);
                        drawArc (rt, a - 0.4 * da, a + 0.4 * da, 20 * r - 5, 20 * r + 5, hsl2rgb (r * 30, v)); i_rt++;
                    }
                }
                r++; n += r;
            }
            lt.rotation++;
            rt.rotation--;
        }
        public function drawArc (s:Sprite, a1:Number, a2:Number, r1:Number, r2:Number, c:uint = 0xFFFFFF, al:Number = 1):void {
            var n:int = Math.max (2, (a2 - a1) / 0.1);
            s.graphics.beginFill (c, al);
            for (var i:int = 0; i <= n; i++) {
                var ai:Number = a1 + i * (a2 - a1) / n;
                var xi:Number = r1 * Math.cos (ai);
                var yi:Number = r1 * Math.sin (ai);
                if (i == 0)
                    s.graphics.moveTo (xi, yi);
                else
                    s.graphics.lineTo (xi, yi);
            }
            for (i = 0; i <= n; i++) {
                ai = a2 + i * (a1 - a2) / n;
                xi = r2 * Math.cos (ai);
                yi = r2 * Math.sin (ai);
                s.graphics.lineTo (xi, yi);
            }
            s.graphics.endFill ();
        }
        /**
         * There's some bug with L ~ 1 :(
         * @see http://wonderfl.net/c/iIDv
         */
        private function hsl2rgb(h:Number, l:Number, s:Number=1):uint {

            if (h == 360){ h = 0;}

            //
            // based on C code from http://astronomy.swin.edu.au/~pbourke/colour/hsl/
            //

            while (h < 0){ h += 360; }
            while (h > 360){ h -= 360; }
            var r :Number, g :Number, b :Number;
            if (h < 120){
                r = (120 - h) / 60;
                g = h / 60;
                b = 0;
            }else if (h < 240){
                r = 0;
                g = (240 - h) / 60;
                b = (h - 120) / 60;
            }else{
                r = (h - 240) / 60;
                g = 0;
                b = (360 - h) / 60;
            }

            r = Math.min(r, 1);
            g = Math.min(g, 1);
            b = Math.min(b, 1);

            r = 2 * s * r + (1 - s);
            g = 2 * s * g + (1 - s);
            b = 2 * s * b + (1 - s);

            if (l < 0.5){
                r = l * r;
                g = l * g;
                b = l * b;
            }else{
                r = (1 - l) * r + 2 * l - 1;
                g = (1 - l) * g + 2 * l - 1;
                b = (1 - l) * b + 2 * l - 1;
            }

            return int (r * 255) * 65536 + int (g * 255) * 256 + int (b * 255);
        }
    }
}

/**
 * 2nd draft of Normalizer class.
 */
class Normalizer {
    /** Damping. */
    public var d:Number = 0.9;
    /** Maximum minimum. */
    public var e:Number = 0.1;

    private var avg:Number = 0.5;
    private var val:Number = 0;

    public function average ():Number { return avg; }
    public function lastValue ():Number { return val; }

    public function f (x:Number):Number {
        avg = d * avg + (1 - d) * x;

        // f(x)=1-exp(ax); f(avg)=0.5; a=?
        var a:Number = - Math.LN2 / Math.max (avg, e);

        val = 1 - Math.exp (a * x);
        return val;
    }
}

    import com.codeazur.as3swf.SWF;
    import com.codeazur.as3swf.SWFData;
    import com.codeazur.as3swf.data.SWFScene;
    import com.codeazur.as3swf.data.SWFSymbol;
    import com.codeazur.as3swf.data.consts.SoundCompression;
    import com.codeazur.as3swf.data.consts.SoundRate;
    import com.codeazur.as3swf.data.consts.SoundSize;
    import com.codeazur.as3swf.data.consts.SoundType;
    import com.codeazur.as3swf.tags.TagDefineSceneAndFrameLabelData;
    import com.codeazur.as3swf.tags.TagDefineSound;
    import com.codeazur.as3swf.tags.TagDoABC;
    import com.codeazur.as3swf.tags.TagEnd;
    import com.codeazur.as3swf.tags.TagFileAttributes;
    import com.codeazur.as3swf.tags.TagSetBackgroundColor;
    import com.codeazur.as3swf.tags.TagShowFrame;
    import com.codeazur.as3swf.tags.TagSymbolClass;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.media.Sound;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import flash.utils.ByteArray;
    /**
     * This loads MP3 from HDD.
     * 
     * @see http://wiki.github.com/claus/as3swf/play-mp3-directly-from-bytearray
     * @see http://github.com/claus/as3swf/raw/master/bin/as3swf.swc
     */
    class ClientMP3Loader extends EventDispatcher {

        /**
         * Use this object after Event.COMPLETE.
         */
        public var sound:Sound;

        /**
         * Call this to load MP3 from HDD.
         */
        public function load ():void {
            file = new FileReference;
            file.addEventListener (Event.CANCEL, onUserCancelled);
            file.addEventListener (Event.SELECT, onFileSelected);
            file.addEventListener (Event.COMPLETE, onFileLoaded);
            file.browse ([ new FileFilter ("MP3 files", "*.mp3") ]);
        }

        private var file:FileReference;
        private function onUserCancelled (e:Event):void { dispatchEvent (new Event (Event.CANCEL)); }
        private function onFileSelected (e:Event):void { file.load (); }
        private function onFileLoaded (e:Event):void {
            // Wrap the MP3 with a SWF
            var swf:ByteArray = createSWFFromMP3 (file.data);
            // Load the SWF with Loader::loadBytes()
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            loader.loadBytes(swf);
        }

        private function initHandler(e:Event):void {
            // Get the sound class definition
            var SoundClass:Class = LoaderInfo(e.currentTarget).applicationDomain.getDefinition("MP3Wrapper_soundClass") as Class;
            // Instantiate the sound class
            sound = new SoundClass() as Sound;
            // Report Event.COMPLETE
            dispatchEvent (new Event (Event.COMPLETE));
        }

        private function createSWFFromMP3(mp3:ByteArray):ByteArray
        {
            // Create an empty SWF
            // Defaults to v10, 550x400px, 50fps, one frame (works fine for us)
            var swf:SWF = new SWF();
            
            // Add FileAttributes tag
            // Defaults: as3 true, all other flags false (works fine for us)
            swf.tags.push(new TagFileAttributes());

            // Add SetBackgroundColor tag
            // Default: white background (works fine for us)
            swf.tags.push(new TagSetBackgroundColor());
            
            // Add DefineSceneAndFrameLabelData tag 
            // (with the only entry being "Scene 1" at offset 0)
            var defineSceneAndFrameLabelData:TagDefineSceneAndFrameLabelData = new TagDefineSceneAndFrameLabelData();
            defineSceneAndFrameLabelData.scenes.push(new SWFScene(0, "Scene 1"));
            swf.tags.push(defineSceneAndFrameLabelData);

            // Add DefineSound tag
            // The ID is 1, all other parameters are automatically
            // determined from the mp3 itself.
            swf.tags.push(TagDefineSound.createWithMP3(1, mp3));
            
            // Add DoABC tag
            // Contains the AS3 byte code for the document class and the 
            // class definition for the embedded sound
            swf.tags.push(TagDoABC.create(abc));
            
            // Add SymbolClass tag
            // Specifies the document class and binds the sound class
            // definition to the embedded sound
            var symbolClass:TagSymbolClass = new TagSymbolClass();
            symbolClass.symbols.push(SWFSymbol.create(1, "MP3Wrapper_soundClass"));
            symbolClass.symbols.push(SWFSymbol.create(0, "MP3Wrapper"));
            swf.tags.push(symbolClass);
            
            // Add ShowFrame tag
            swf.tags.push(new TagShowFrame());

            // Add End tag
            swf.tags.push(new TagEnd());
            
            // Publish the SWF
            var swfData:SWFData = new SWFData();
            swf.publish(swfData);
            
            return swfData;
        }
        
        private static var abcData:Array = [
            0x10, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x19, 0x07, 0x6d, 0x78, 0x2e, 0x63, 0x6f, 0x72, 0x65, 
            0x0a, 0x49, 0x46, 0x6c, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x0a, 0x53, 0x6f, 0x75, 0x6e, 
            0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x0b, 0x66, 0x6c, 0x61, 0x73, 0x68, 0x2e, 0x6d, 0x65, 0x64, 
            0x69, 0x61, 0x05, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x6d, 0x78, 0x2e, 0x63, 0x6f, 0x72, 0x65, 
            0x3a, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x00, 0x15, 0x4d, 0x50, 0x33, 
            0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x61, 
            0x73, 0x73, 0x0a, 0x4d, 0x50, 0x33, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x0d, 0x66, 0x6c, 
            0x61, 0x73, 0x68, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x06, 0x53, 0x70, 0x72, 0x69, 
            0x74, 0x65, 0x0a, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x05, 0x43, 0x6c, 
            0x61, 0x73, 0x73, 0x2a, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x61, 
            0x64, 0x6f, 0x62, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x32, 0x30, 0x30, 0x36, 0x2f, 0x66, 0x6c, 
            0x65, 0x78, 0x2f, 0x6d, 0x78, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x07, 0x56, 
            0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x06, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x07, 0x33, 0x2e, 
            0x30, 0x2e, 0x30, 0x2e, 0x30, 0x0b, 0x6d, 0x78, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 
            0x6c, 0x06, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x0c, 0x66, 0x6c, 0x61, 0x73, 0x68, 0x2e, 0x65, 
            0x76, 0x65, 0x6e, 0x74, 0x73, 0x0f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x61, 
            0x74, 0x63, 0x68, 0x65, 0x72, 0x0d, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x62, 0x6a, 
            0x65, 0x63, 0x74, 0x11, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 
            0x62, 0x6a, 0x65, 0x63, 0x74, 0x16, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x62, 0x6a, 
            0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x0a, 0x16, 0x01, 0x16, 
            0x04, 0x18, 0x06, 0x16, 0x07, 0x18, 0x08, 0x16, 0x0a, 0x18, 0x09, 0x08, 0x0e, 0x16, 0x14, 0x03, 
            0x01, 0x01, 0x01, 0x04, 0x14, 0x07, 0x01, 0x02, 0x07, 0x01, 0x03, 0x07, 0x02, 0x05, 0x09, 0x02, 
            0x01, 0x07, 0x04, 0x08, 0x07, 0x04, 0x09, 0x07, 0x06, 0x0b, 0x07, 0x04, 0x0c, 0x07, 0x04, 0x0d, 
            0x07, 0x08, 0x0f, 0x07, 0x04, 0x10, 0x07, 0x01, 0x12, 0x09, 0x03, 0x01, 0x07, 0x04, 0x13, 0x07, 
            0x09, 0x15, 0x09, 0x08, 0x02, 0x07, 0x06, 0x16, 0x07, 0x06, 0x17, 0x07, 0x06, 0x18, 0x0d, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x05, 0x00, 0x02, 0x00, 0x02, 0x03, 0x09, 0x03, 0x01, 
            0x04, 0x05, 0x00, 0x05, 0x02, 0x09, 0x05, 0x00, 0x08, 0x00, 0x06, 0x07, 0x09, 0x07, 0x00, 0x0b, 
            0x01, 0x08, 0x00, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 0x01, 0x0a, 0x06, 0x01, 0x0b, 0x11, 0x01, 
            0x07, 0x00, 0x0a, 0x00, 0x05, 0x00, 0x01, 0x0c, 0x06, 0x00, 0x00, 0x08, 0x08, 0x03, 0x01, 0x01, 
            0x04, 0x00, 0x00, 0x06, 0x01, 0x02, 0x04, 0x00, 0x01, 0x09, 0x01, 0x05, 0x04, 0x00, 0x02, 0x0c, 
            0x01, 0x06, 0x04, 0x01, 0x03, 0x0c, 0x00, 0x01, 0x01, 0x01, 0x02, 0x03, 0xd0, 0x30, 0x47, 0x00, 
            0x00, 0x01, 0x00, 0x01, 0x03, 0x03, 0x01, 0x47, 0x00, 0x00, 0x03, 0x02, 0x01, 0x01, 0x02, 0x0a, 
            0xd0, 0x30, 0x5d, 0x04, 0x20, 0x58, 0x00, 0x68, 0x01, 0x47, 0x00, 0x00, 0x04, 0x02, 0x01, 0x05, 
            0x06, 0x09, 0xd0, 0x30, 0x5e, 0x0a, 0x2c, 0x11, 0x68, 0x0a, 0x47, 0x00, 0x00, 0x05, 0x01, 0x01, 
            0x06, 0x07, 0x06, 0xd0, 0x30, 0xd0, 0x49, 0x00, 0x47, 0x00, 0x00, 0x06, 0x02, 0x01, 0x01, 0x05, 
            0x17, 0xd0, 0x30, 0x5d, 0x0d, 0x60, 0x0e, 0x30, 0x60, 0x0f, 0x30, 0x60, 0x03, 0x30, 0x60, 0x03, 
            0x58, 0x01, 0x1d, 0x1d, 0x1d, 0x68, 0x02, 0x47, 0x00, 0x00, 0x07, 0x01, 0x01, 0x06, 0x07, 0x03, 
            0xd0, 0x30, 0x47, 0x00, 0x00, 0x08, 0x01, 0x01, 0x07, 0x08, 0x06, 0xd0, 0x30, 0xd0, 0x49, 0x00, 
            0x47, 0x00, 0x00, 0x09, 0x02, 0x01, 0x01, 0x06, 0x1b, 0xd0, 0x30, 0x5d, 0x10, 0x60, 0x0e, 0x30, 
            0x60, 0x0f, 0x30, 0x60, 0x03, 0x30, 0x60, 0x02, 0x30, 0x60, 0x02, 0x58, 0x02, 0x1d, 0x1d, 0x1d, 
            0x1d, 0x68, 0x05, 0x47, 0x00, 0x00, 0x0a, 0x01, 0x01, 0x08, 0x09, 0x03, 0xd0, 0x30, 0x47, 0x00, 
            0x00, 0x0b, 0x02, 0x01, 0x09, 0x0a, 0x0b, 0xd0, 0x30, 0xd0, 0x60, 0x05, 0x68, 0x08, 0xd0, 0x49, 
            0x00, 0x47, 0x00, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x08, 0x23, 0xd0, 0x30, 0x65, 0x00, 0x60, 0x0e, 
            0x30, 0x60, 0x0f, 0x30, 0x60, 0x11, 0x30, 0x60, 0x12, 0x30, 0x60, 0x13, 0x30, 0x60, 0x07, 0x30, 
            0x60, 0x07, 0x58, 0x03, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x68, 0x06, 0x47, 0x00, 0x00
        ];

        private static function abcDataToByteArray():ByteArray {
            var ba:ByteArray = new ByteArray();
            for (var i:uint = 0; i < abcData.length; i++) {
                ba.writeByte(abcData[i]);
            }
            return ba;
        }
        
        private static var abc:ByteArray = abcDataToByteArray();
    }