/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/akaV
 */

// forked from JohnBrookes's forked from: How to fix my FIVe3D code?
// forked from makc3d's How to fix my FIVe3D code?
// This code worked in FIVe3D 2.1
// What's wrong now?
// :p
package {

	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	// We import the FIVe3D classes needed.
	import flash.display.DisplayObject;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import net.badimon.five3D.display.DynamicText3D;
	import net.badimon.five3D.display.Scene3D;
	import net.badimon.five3D.display.Sprite3D;
	import net.badimon.five3D.typography.HelveticaBold;

	public class Main extends Sprite {

		private var cubes:Sprite3D;

		public function Main() {
			
			// We define the Stage scale mode.
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			// We create a new Scene3D named "scene", center it and add it to the display list.
			var scene:Scene3D = new Scene3D();
			scene.x = 300;
			scene.y = 200;
			addChild(scene);
			
			// We create a new Sprite3D and turn children sorting on.
			cubes = new Sprite3D ();
			cubes.childrenSorted = true;

			for (var i:int = 0; i < 20; i++) {
				var cube:DisplayObject = makeCube (30, i);
				cube.rotationX = Math.random()*100-50;
				cube.rotationY = Math.random()*100-50;
				cube.rotationZ = Math.random()*100-50;
				cube.x = Math.random()*400-200;
				cube.y = Math.random()*400-200;
				cube.z = Math.random()*400-200;

				cube.addEventListener (Event.ENTER_FRAME, cubeSpinner);
				cubes.addChild (cube);
			}

			cubes.addEventListener (Event.ENTER_FRAME, cubeSpinner);
			scene.addChild(cubes);
		}


		private function cubeSpinner(event:Event):void {
			event.target.rotationX += 2;
			event.target.rotationY += 2;
		}
		
		private function makeCube (S:Number, j:int):Sprite3D {
			var cube:Sprite3D = new Sprite3D ();
			cube.childrenSorted = true;
			for (var i:int = 0; i < 6; i++)
				cube.addChild (makeCubeSide (i, S, j));
			return cube;
		}
		
		private function makeCubeSide (i:int, S:Number, j:int):Sprite3D {
			var T:Array = ["F", "I", "V", "E", "3", "D"];
			var X:Array = [+1,  0, -1,  0,  0,  0];
			var Y:Array = [ 0,  0,  0,  0, +1, -1];
			var Z:Array = [ 0, +1,  0, -1,  0,  0];
			var side:Sprite3D = new Sprite3D();
			side.graphics3D.beginFill(10*i + 50 + j*2560, 1);
			side.graphics3D.drawRect(-S, -S, 2*S, 2*S);
			side.graphics3D.endFill();
			var world:DynamicText3D = new DynamicText3D(HelveticaBold.instance);
			//world.typography = five3D.typography.HelveticaBold;
			world.size = S;
			world.color = 0x800000 + 0x100000 * (i+1);
			world.text = T [i];
			side.addChild(world);
			side.x = S * X [i]; side.rotationY = -90 * X [i];
			side.y = S * Y [i]; side.rotationX = +90 * Y [i];
			side.z = S * Z [i]; side.rotationZ = +90 * Z [i];
			return side;
		}

	}

}