/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aixz
 */

package {

    import flash.net.*;
    import flash.text.*;
    import flash.events.*;
    import flash.display.*;
    import flash.system.System;
    public class FlashTest extends Sprite {

        private var text1:TextField = new TextField();
        private var txt2:TextField = new TextField();
        private var txt3:TextField = new TextField();
        private var scrTxt:TextField = new TextField();
        
        private var file:FileReference = new FileReference();
        private var base:Sprite = new Sprite();
        private var playBtn:IconBtn;
        private var mask1:Sprite = new Sprite();
        
        public function FlashTest() {
            System.useCodePage = true;//UNICODE以外のテキストファイルをロードする場合 true
            
            
            mask1.graphics.beginFill(0xff0000,1);
            mask1.graphics.drawRect(40,0,100,20);
            mask1.graphics.endFill();
            addChild(mask1);
            
            scrTxt.mask = mask1;
            
            scrTxt.text= "test ";
            scrTxt.appendText(scrTxt.scrollH.toString()+" ");
            scrTxt.appendText(scrTxt.maxScrollV.toString());
            scrTxt.width = 100;
            scrTxt.x =100;
            addChild(scrTxt);
            scrTxt.addEventListener(Event.ENTER_FRAME,scrollText);
            
            addChild(base);
            
            
            
            
            //base.addEventListener(
            //base.startDrag();
            
            //base.addChild(text1);
            text1.text = "test\taaa ";
            
            
            text1.width =400;
            text1.height=400;
            //text1.addEventListener(MouseEvent.CLICK,onClick);
            file.addEventListener(Event.COMPLETE,onLoaded2);
            file.addEventListener(Event.SELECT,onSelect);
            
            txt2.width =400;
            txt2.height =400;
            txt2.border = true;
            txt2.type = "input";
            
            txt3.type = "dynamic";
            txt3.selectable = false;
            txt3.border = true;
            txt3.x = 300;
            txt2.addEventListener(KeyboardEvent.KEY_DOWN,onClick2);
            
            base.addChild(txt2);
            addChild(txt3);
            
            //ボタン設定
            playBtn = new IconBtn(PlayIcon);
            addChild(playBtn);
            playBtn.x = 95;
            playBtn.y = 380;
            playBtn.init({width: 40});
            playBtn.addEventListener(MouseEvent.CLICK, onClick);
            addChild(playBtn);
        }
        
        private function scrollText(e:Event):void{
            scrTxt.x--;
            if(scrTxt.x+scrTxt.width < 30)scrTxt.x = 200;
            //if(50 < scrTxt.x)scrTxt.width = 100-scrTxt.x;

        }

        
        private function onClick2(e:KeyboardEvent):void{
            txt3.text = String(txt2.caretIndex);
            txt3.appendText(" "+String(e.keyCode));
            txt3.appendText("\r"+String(txt2.text.length)+" ");
            txt3.appendText("\r"+String(func1(txt2.text))+" ");
            txt3.text = CSVarea(txt2.text);

        }
        
        
        //改行コードの統一 (CR+LF or CR) → LF
        private function unifyLineFeedCode(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            return str;
        }
        
        //CSVデータの開始行と終了行を調べる
        private function CSVarea(source:String):String {
            var n:int = 0;
            var pre:int =0;
            var st:int;
            var end:int;
            var sw:Boolean;
            var CR:String = String.fromCharCode(13);
            var out:String = "";
            var src:Array = source.split(CR);
            for(var i:int =0;i<src.length;i++){
                var str:String = src[i];
                var sub:Array = str.split(",");
                n = sub.length;
                if(sw == false){//開始行の探索
                    if(0<n){
                        if(pre==n){//開始行の発見
                            sw = true;
                            st = i-1;
                        }
                        else pre = n;

                    }
                }
                else {//終了行の探索
                    if(n!=pre){//終了
                        sw = false;
                        end = i;
                        //行数が少ない場合は無視
                        if(3 < end-st)out += String(st)+","+ String(end-st)+"\r";
                        pre = 0;
                    }

                }

            }

            return out;
        }

        

        
        //行数のカウント
        private function func1(str:String):int{
            var n:int = 0;
            var LF:String = String.fromCharCode(13);
            for(var i:int = 0;i<str.length;i++){
                //i = str.indexOf(LF,i);
                //if(0<i)n++;
                //else break;
                if(str.charAt(i) == LF)n++;
            }
            return n;
        }


        
        //ファイル選択　①
        private function onClick(e:MouseEvent):void{
            file.browse();              
        }
        
        //ロード開始　②
        private function onSelect(e:Event):void{
            file.load();
        }
        
        private function onLoaded2(e:Event):void{
            var byte:int = file.data.length;
            var byte2:uint;
            
            //txt2.text = String(file.data);
            txt2.text = unifyLineFeedCode(file.data.toString());//改行コード統一
            text1.text = "byte:"+byte+"\r";
            text1.appendText("name:["+file.name+"]");
            text1.appendText(" \r\n");
            text1.appendText("endian:"+file.data.endian+"\r\n");
            text1.appendText("type:["+file.type+"]\r\n");
            text1.appendText("作成日:["+file.creationDate+"] \r\n");
            text1.appendText("更新日:["+file.modificationDate+"]\r\n");
            
            //データ読み込みフェーズ
            for(var i:int =0;i<byte;i++){
                //file.data.position = i;
                text1.appendText("pos:"+file.data.position+" ");
                byte2=file.data.readInt();
                text1.appendText("0x"+byte2.toString(16)+" ");
                text1.appendText("pos:"+file.data.position+" ");
                text1.appendText("\r\n");
                if(200<i)break;
            }

            
        }

        

        
        //ロードデータ --> テキスト　③
        private function onLoaded(e:Event):void{
            var str:String = String(file.data);
            var sub:Array;
            var str2:String;
            var i:int;
            var j:int =0;
            var k:int =0;
            text1.text= "";
            text1.text= "str.length:"+String(str.length);
            var tab:int =0;
            
            //j=str.indexOf("\0",0);
            j=str.length;
            text1.text = String(j+str.charAt(j));
            //文字検索
            for(i=0;i<str.length;i++){
                //if(str.charAt(i)==" ")continue;
                //else if(str.charAt(i)=="\n")continue;
                //else if(str.charAt(i)=="\r")continue;
                
                j = str.indexOf(":",i);
                
                //k = str.indexOf(":",i);
                //if(k<j)j=k;
                /*k = str.indexOf("{",i);
                if(k<j && 0<k)j=k;
                k = str.indexOf("}",i);
                if(k<j && 0<k)j=k;*/
 
                
                if(j==i){
                    str2 = str.substring(i,str.length);
                    text1.text = str.substring(i,str.length);
                    //sub.push(String(str2));
                    break;
                }
                else{
                                        
                    str2 = str.substring(i,j+1);
                    //sub.push(String(str2));
                    for(var i2:int=0;i2<tab;i2++){
                        text1.appendText("["+tab+"]");
                    }
                    text1.appendText(str2+"\r\n");
                    i=j;
                    if(str.charAt(j)=="{")tab++;
                    if(str.charAt(j)=="}")tab--;
                    
                }
                
            }
            
            /*text1.text= "sub.length:"+String(sub.length);
            for(i=0;i<sub.length;i++){
                text1.appendText(sub[i]+"\r\n");
            }
            */


            //text1.text = String(file.data);
            
        }
  
    }
}


//////////////////////////////////////////////////
// IconBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class IconBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var icon:Shape;
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var cColor:uint = 0x0099FF;
    private var colorGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function IconBtn(Icon:Class) {
        icon = new Icon();
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.color != undefined) cColor = option.color;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        colorGlow = new GlowFilter(cColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(icon);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, cColor);
        light.filters = [colorGlow];
        createBase(base, _width, _height, corner, bColor);
        icon.y = -1;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        icon.y = -1;
        icon.transform.colorTransform = upColorTrans;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        icon.y = -1;
        icon.transform.colorTransform = overColorTrans;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        icon.y = 0;
        icon.transform.colorTransform = overColorTrans;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        icon.y = 0;
        icon.transform.colorTransform = offColorTrans;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        if (_clicked) {
            _down();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
        } else {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Iconクラス
//////////////////////////////////////////////////

import flash.display.Shape;
//import sketchbook.graphics.GraphicsHelper;

class PlayIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PlayIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-4, -6);
        graphics.lineTo(-4, 6);
        graphics.lineTo(8, 0);
        graphics.endFill();
    }

}

class PauseIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PauseIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 4, 10);
        graphics.endFill();
        graphics.beginFill(bColor);
        graphics.drawRect(3, -5, 4, 10);
        graphics.endFill();
    }

}

class StopIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function StopIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 10, 10);
        graphics.endFill();
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}
