/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aiwf
 */

//forked from: Libspark Threading example, english - including ThreadStepProcessor
package 
{
    import org.libspark.thread.*; 
    import flash.display.*;
    public class ThreadLibraryExample extends Sprite 
    {
        public function ThreadLibraryExample()
        {
            Wonderfl.capture_delay(7);
            Thread.initialize(new EnterFrameThreadExecutor());
            var setup : SetupThread = new SetupThread(this);
            setup.start();
        }
    }
}
import flash.utils.getQualifiedClassName;
import org.libspark.thread.Thread;
import org.libspark.thread.step.StepThread;
import org.libspark.thread.threads.display.LoaderThread;
import org.libspark.thread.threads.net.URLLoaderThread;
import org.libspark.thread.utils.Progress;
import org.libspark.thread.utils.IProgress;
import org.libspark.thread.utils.events.ProgressEvent;
import org.libspark.thread.utils.ParallelExecutor;
import org.libspark.thread.utils.IProgressNotifier;
import flash.net.navigateToURL;
import flash.display.*;
import flash.errors.IOError;
import flash.events.Event;
import flash.net.URLRequest;
import flash.text.*;
import flash.system.Security;
import flash.events.MouseEvent;
class SetupThread extends Thread 
{
    private var _container : DisplayObjectContainer;
    private var _configLoader : URLLoaderThread;
    private var _allImagesLoader : ParallelExecutor;
    private var _messageDisplay : MessageDisplay;
    private var _pseudoThread : PseudoThread;
    public function SetupThread(container : DisplayObjectContainer) 
    {
        _container = container;
    }
    override protected function run() : void 
    {
        _configLoader = new URLLoaderThread(new URLRequest("http://search.twitter.com/search.atom?q=jk"));
        _configLoader.start();
        _configLoader.join();
        error(IOError, handleError);
        error(SecurityError, handleError);
        next(loadImagesOfTwitterFeed);
    }
    private function handleError(error : Error, thread : Thread) : void 
    {
        message(error.message, true);
        interrupt();
    }
    private function loadImagesOfTwitterFeed() : void 
    {
        if (!isInterrupted) 
        {
            var xml : XML = new XML(_configLoader.loader.data);
            var images : XMLList = xml..(xml.namespace())::link.(@type == "image/png" || @type == "image/jpeg" || @type == "image/jpg" || @type == "image/gif");
            _allImagesLoader = new ParallelExecutor();
            for each(var image : XML in images) 
            {
                _allImagesLoader.addThread(new LoaderThread(new URLRequest(image.@href)));
            }
            _allImagesLoader.start();
            _allImagesLoader.join();
            error(IOError, handleError);
            error(SecurityError, handleError);
            next(addImages);
        }
    }
    private function addImages() : void 
    {
        if (!isInterrupted) 
        {
            var stageWidth : int = _container.stage.stageWidth;
            var maxHeight : int = 0;
            var x : int = 0;
            var y : int = 0;
            for (var i : int = 0; i< _allImagesLoader.numThreads; ++i) 
            {
                var content : DisplayObject = LoaderThread(_allImagesLoader.getThreadAt(i)).loader;
                if (x + content.width > stageWidth) 
                {
                    x = 0;
                    y += maxHeight;
                }
                content.x = x;
                content.y = y;
                if (content.height > maxHeight) 
                {
                    maxHeight = content.height;
                }
                x += content.width;
                _container.addChild(content);
            }
            message("click me in the next 5 seconds");
            event(_container.stage, MouseEvent.MOUSE_DOWN, startPseudoThread);
            //wait(5000);
            //timeout(showClickFailed);
        }
    }
    private function showClickFailed() : void 
    {
        message("You were too slow!", true);
    }
    private function startPseudoThread(event : Event = null) : void 
    {
        message("Starting pseudo thread");
        _pseudoThread = new PseudoThread();
        _pseudoThread.start();
        _pseudoThread.join();
        _pseudoThread.progress.addEventListener(ProgressEvent.UPDATE, showPercentage);
        error(Error, handleError);
        next(finish);
    }
    private function showPercentage(event : ProgressEvent) : void 
    {
        message(int(_pseudoThread.progress.percent * 100) + "%");
    }
    private function finish() : void 
    {
        message("pseudo thread finished");
    }
    override protected function finalize() : void 
    {
        _container = null;
        _configLoader = null;
        _allImagesLoader = null;
        _messageDisplay = null;
    }
    internal function message(message : String, error : Boolean = false) : void 
    {
        if (_messageDisplay) 
        {
            _container.removeChild(_messageDisplay);
            _messageDisplay = null;
        }
        if (message) 
        {
            _container.addChild(_messageDisplay = new MessageDisplay(message, error));
        }
    }
}
class PseudoThread extends StepThread implements IProgressNotifier 
{
    private static const MAX : int = 50000000;
    private var _progress : Progress = new Progress();
    private var _i : int;
    override protected function init() : void 
    {
        _progress.start(MAX);
        _i = 0;
    }
    override protected function process() : Boolean 
    {
        ++_i;
        return _i >= MAX;
    }
    override protected function updateState() : void 
    {
        _progress.progress(_i);
    }
    public function get progress() : IProgress 
    {
        return _progress;
    }
}
class MessageDisplay extends Sprite 
{
    private var _text : TextField;
    public function MessageDisplay(message : String, error : Boolean) 
    {
        addChild(_text = new TextField());
        _text.defaultTextFormat = new TextFormat("Verdana", 10, 0xFFFFFF);
        _text.autoSize = TextFieldAutoSize.LEFT;
        _text.text = message;
        with (graphics) 
        {
            beginFill(error ? 0xAC0000 : 0x00AC00);
            drawRoundRect(0, 0, _text.textWidth + 10, _text.textHeight + 10, 5);
            endFill();
        }
        addEventListener(Event.ADDED_TO_STAGE, render);
    }
    private function render(event : Event) : void 
    {
        x = stage.stageWidth / 2 - width / 2;
        y = stage.stageHeight / 2 - height / 2;
    }
}
