/**
 * Copyright brane7 ( http://wonderfl.net/user/brane7 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aiv5
 */

// forked from yd_niku's forked from: 渦巻
// forked from okoi's 渦巻
//
//	渦、台風っぽく
//	高速化しないと重いな
//	ブラーもかけたいかも
//	じっと見てると目をまわします
//
package 
{
	import flash.display.*;
	import flash.geom.*;
	import flash.events.Event;
	import net.hires.debug.*;
	
	/**
	 * ...
	 * @author okoi
	 */
	import flash.filters.BlurFilter;
	import flash.events.MouseEvent;
	import flash.accessibility.Accessibility;
	[SWF(frameRate=60)]
	public class Main extends Sprite 
	{
		private var spire:Spire;
		private static const POWDER_NUM:int = 10;
		
		private var _container:Bitmap;
		private var _firstPowder:Powder;
		private var _canvas:BitmapData;
		private var _origin:BitmapData;
		private var _filters:Array;
		private var _gain:ColorTransform;
		
		[SWF(frameRate=60)]
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// entry point
			spire = new Spire();
			
			_origin = new BitmapData(1,1,false,0xFFFFFF);
			
			_container = new Bitmap();
			_container.scaleX = _container.scaleY = 2;
			addChild( _container );
			
			_filters = [ new BlurFilter(2,2) ];
			_gain = new ColorTransform(0.97,0.97,0.99,1, -2, -2, 4 );
			
			setupDisplay();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP,mouseHandler);
			addEventListener( Event.ENTER_FRAME, EnterFrame );
			stage.addEventListener(Event.RESIZE,resizeHandler);
			
			addChild(new Stats());
		}
		
		private function mouseHandler(e:MouseEvent):void {
			switch(e.type) {
				case MouseEvent.MOUSE_UP:
					Powder.speed = 1;
				break;
				case MouseEvent.MOUSE_DOWN:
					Powder.speed = 6;
				break;
				case MouseEvent.MOUSE_MOVE:
					Powder.speed++;
				break;
			}
		
		}
		
		private function EnterFrame(e:Event):void {
			spire.Update( stage.mouseX, stage.mouseY );
			
			var powder:Powder = _firstPowder;//powders[0];
			do{
				powder.Move( spire );
			}
			while( (powder = powder.next) != null );
			
			powder = _firstPowder;//powders[0];
			
			var r:uint, g:uint, b:uint, c:uint;
			var p:Point = new Point(), o:Point = p.clone();
			
			_canvas.lock();
			//_canvas.fillRect( _canvas.rect, 0x00 );
			_canvas.colorTransform( _canvas.rect, _gain );
			do{
				p.x = powder.posX>>1; p.y = powder.posY>>1;
				_canvas.setPixel(p.x, p.y, 0xffffff);
//				_canvas.copyPixels( _origin, _origin.rect, p );
			}
			while( (powder = powder.next) != null );
			_canvas.applyFilter( _canvas, _canvas.rect, o, _filters[0] );
			_canvas.unlock();
		}
		
		private function resizeHandler(e:Event):void{
			setupDisplay();
		}
		
		private function setupDisplay():void{
			_firstPowder = null;
			
			var powder:Powder, pre:Powder;
			var sw:Number = stage.stageWidth;
			var sh:Number = stage.stageHeight;
			
			for ( var i:int = 0; i < POWDER_NUM; i++ )
			{
				var x:Number = Math.random() * sw;
				var y:Number = Math.random() * sh;
				powder = new Powder(x, y, int(Math.random() * 1000));
				if( !_firstPowder ) _firstPowder = powder; 
				if( pre ) pre.next = powder;
				pre = powder;
			}
			if( _canvas ) {
				_canvas.dispose();
				_canvas = null;
			}
			_canvas = new BitmapData( sw>>1, sh>>1, false, 0 );
			_container.bitmapData = _canvas;
		}
		
	}
	
}
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
import flash.display.Stage;

/**
 * 渦エネルギー
 */
class Spire {
	
	public var centerX:int;
	public var centerY:int;
	
	public	var	rotatePower:Number = 10;
	public var cRotate : Number = Math.cos((90+rotatePower/2)/180*Math.PI);
	public var sRotate : Number = Math.sin((90+rotatePower/2)/180*Math.PI);
	
	/**
	 * 更新
	 * @param	_x
	 * @param	_y
	 */
	public	function Update(_x:int, _y:int):void 
	{
		centerX = _x;
		centerY = _y;
	}
}

/**
 * 渦エネルギーの犠牲となる粉
 */
class Powder {
	
	public var next:Powder;
	
	public	var posX:Number;
	public	var posY:Number;
	public	var defX:Number;
	public	var defY:Number;
	
	public	var life:int;
	public	var alpha:Number = 0;
	
	public static var speed:Number = 2.0;
	
	public	function Powder(_x:Number, _y:Number, _l:int)
	{
		Set(_x, _y, _l);
	}
	
	public	function Set(_x:Number, _y:Number, _l:int):void
	{
		posX = _x;
		posY = _y;
		life = _l;
		defX = _x;
		defY = _y;
		alpha = 1;
	}
	
	public	function Move(s:Spire):void 
	{
		var rnd:Number = (Math.random()-0.5)*2;
		var vecX:Number = (posX - s.centerX);
		var vecY:Number = (posY - s.centerY); 
		/*
		var theta : Number = (90 + s.rotatePower / 2) / 180 * Math.PI;
		var cos : Number = Math.cos(theta);
		var sin : Number = Math.sin(theta); 
		var vx : Number = vecX * cos + vecY * -sin;
		var vy : Number = vecX * sin + vecY * cos;
		*/
		var vx : Number = vecX * s.cRotate + vecY * -s.sRotate;
		var vy : Number = vecX * s.sRotate + vecY * s.cRotate;
		var r : Number = Math.sqrt(vx * vx + vy * vy);
		
		vx /= r; vy /= r;
		
		posX += vx * 4 * speed + rnd;
		posY += vy * 1 * speed + rnd;
	
		life--;
		if ( life <= 0 )
		{
			posX = defX;
			posY = defY;
			life = 1000 + Math.random()*100>>0;
			alpha = 0;
		}
		if ( alpha < 1 )	alpha += 0.1;
			}
}
