/**
 * Copyright axcel_work ( http://wonderfl.net/user/axcel_work )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aiLH
 */

package {
    import com.bit101.components.PushButton;

    import org.si.sion.SiONDriver;
    import org.si.sion.SiONVoice;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;

    /**
     * @author axcelwork
     */
    public class Index extends Sprite {
        private var driver:SiONDriver = new SiONDriver();
        private var source1:Sound = new Sound();
        private var source2:Sound = new Sound();
        
        /**
         * 
         */
        public function Index() {
            
            if(stage) this.atInit();
            else this.addEventListener(Event.ADDED_TO_STAGE, atInit);
        }
        
        private function atInit(e:Event = null):void {
            trace("[Info] スタート");
            
            driver.play();
            
            var pushbutton1:PushButton = new PushButton(this, 20, 20, "", sound1NoteOn);
            pushbutton1.label = "Sound1 : noteOn";
            
            var pushbutton2:PushButton = new PushButton(this, 140, 20, "", sound1NoteOff);
            pushbutton2.label = "Sound1 : noteOff";
            
            var pushbutton3:PushButton = new PushButton(this, 20, 60, "", sound1Play);
            pushbutton3.label = "Sound1 : play()";
            
            var pushbutton4:PushButton = new PushButton(this, 140, 60, "", sound1Stop);
            pushbutton4.label = "Sound1 : stop()";
            
            
            
            
            var pushbutton5:PushButton = new PushButton(this, 20, 180, "", sound2NoteOn);
            pushbutton5.label = "Sound2 : noteOn";
            
            var pushbutton6:PushButton = new PushButton(this, 140, 180, "", sound2NoteOff);
            pushbutton6.label = "Sound2 : noteOff";
            
            var pushbutton7:PushButton = new PushButton(this, 20, 220, "", sound2Play);
            pushbutton7.label = "Sound2 : play()";
            
            var pushbutton8:PushButton = new PushButton(this, 140, 220, "", sound2Stop);
            pushbutton8.label = "Sound2 : stop()";
            
            
        }
        
        private function sound1NoteOn(e:MouseEvent):void{
            this.source1 = new Sound();
            this.source1.load(new URLRequest("http://shift-style.org/labo/alert_002.mp3"));
            this.source1.addEventListener(Event.COMPLETE, _onComplete1);
        }
        
        private function _onComplete1(e:Event) : void {
            driver.setSamplerSound(60,source1,true,2,2000000);
            driver.noteOn(60, new SiONVoice(10));
        }
        
        private function sound1NoteOff(e:MouseEvent):void {
            driver.noteOff(60);
        }
        
        
        private function sound1Play(e:MouseEvent):void{
            this.source1 = new Sound();
            this.source1.load(new URLRequest("http://shift-style.org/labo/alert_002.mp3"));
            this.source1.addEventListener(Event.COMPLETE, _onComplete3);
        }
        
        private var ch1:SoundChannel;
        private function _onComplete3(e:Event) : void {
            ch1 = source1.play();
        }
        
        private function sound1Stop(e:MouseEvent):void {
            ch1.stop();
        }

 
        
        private function sound2NoteOn(e:MouseEvent):void{
            this.source2 = new Sound();
            this.source2.load(new URLRequest("http://shift-style.org/labo/tamsp13kai.mp3"));
            //this.source2.load(new URLRequest("../assets/tamsp13kai.mp3"));
            this.source2.addEventListener(Event.COMPLETE, _onComplete2);
        }
        
        private function _onComplete2(e:Event) : void {
            driver.setSamplerSound(61,source2,true,2,2000000);
            driver.noteOn(61, new SiONVoice(10));
        }
        
        private function sound2NoteOff(e:MouseEvent):void {
            driver.noteOff(61);
        }
        
        
        private function sound2Play(e:MouseEvent):void{
            this.source2 = new Sound();
            this.source2.load(new URLRequest("http://shift-style.org/labo/tamsp13kai.mp3"));
            this.source2.addEventListener(Event.COMPLETE, _onComplete4);
        }
        
        private var ch2:SoundChannel;
        private function _onComplete4(e:Event) : void {
            ch2 = source2.play();
        }
        
        private function sound2Stop(e:MouseEvent):void {
            ch2.stop();
        }


    }
}
