/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aiBH
 */

//  inspired by
//    単純なタイムカウンター by meat18
//    http://wonderfl.net/code/30bfd97212e7fc7c27a496b63938af1efa147460
//
//  Z ...... start
//  X ...... pause
//  C ...... stop
//  UP ..... increase cycle
//  DOWN ... decrease cycle
//
//  The inner circle takes 1000 msec to wane, 1000 msec to wax.
//  So the cycle of the inner circle is 2000 msec/rev.

package
{
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;

    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x869CA7")]

    public class TimeCircle extends Sprite
    {
        public function TimeCircle()
        {
            var tc1:TC = new TC(10000, 120, 80, [ 0xFF0000, 0x3F0000 ], 6, 15);
            tc1.x = tc1.y = 232;
            addChild(tc1);

            var tc2:TC = new TC(2000, 65, 25, [ 0x3F0000, 0xFF0000 ]);
            tc2.x = tc2.y = 232;
            addChild(tc2);

            var f:String = "Times New Roman";
            var s:Number = 48;
            var c:uint   = 0x3F3F3F;

            var cytf:TextField = new TextField();
            var cyfm:TextFormat = new TextFormat(f, s, c);
            cytf.autoSize = cyfm.align = "right";
            cytf.defaultTextFormat = cyfm;
            cytf.selectable = false;
            cytf.htmlText = tc1.cycle + "<font size='" + s / 2 + "'> msec/rev</font>";
            cytf.x = 455 - cytf.width;
            cytf.y = 465 - cytf.height;
            addChild(cytf);

            var sttf:TextField = new TextField();
            var stfm:TextFormat = new TextFormat(f, s, c);
            sttf.autoSize = stfm.align = "left";
            sttf.defaultTextFormat = stfm;
            sttf.selectable = false;
            sttf.text = "STOP";
            sttf.x = 10;
            addChild(sttf);

            stage.addEventListener(KeyboardEvent.KEY_UP, function(e:KeyboardEvent):void
            {
                switch (e.keyCode) {
                    case 90:  // Z
                        tc1.start();
                        tc2.start();
                        sttf.text = "PLAY";
                        break;
                    case 88:  // X
                        tc1.pause();
                        tc2.pause();
                        sttf.text = "PAUSE";
                        break;
                    case 67:  // C
                        tc1.stop();
                        tc2.stop();
                        sttf.text = "STOP";
                        break;
                    case 38:  // UP
                        tc1.cycle += 500;
                        cytf.htmlText = tc1.cycle + "<font size='" + s / 2 + "'> msec/rev</font>";
                        break;
                    case 40:  // DOWN
                        tc1.cycle -= 500;
                        cytf.htmlText = tc1.cycle + "<font size='" + s / 2 + "'> msec/rev</font>";
                }
            });
        }
    }
}


import flash.display.BlendMode;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix;
import flash.utils.getTimer;

class TC extends Sprite
{
    private var eraserR:Shape;
    private var eraserL:Shape;
    private var hole:Shape;
    private var l:int;

    private var bt:int;
    private var et:int;
    private var c:int;
    private var h:int;
    private var q:int;

    private var isStopped:Boolean;
    private var isPaused:Boolean;


    public function TC(cycle:int            = 2000,  // msec/rev
                       circleRadius:Number  = 60,
                       holeRadius:Number    = 30,
                       circleColor:*        = 0xFF0000,
                       cutLines:int         = 0,
                       lineThickness:Number = 10 )
    {
        blendMode = BlendMode.LAYER;

        if (circleColor is int) {
            graphics.beginFill(circleColor);
        } else if (circleColor is Array
                   && circleColor.length == 2
                   && circleColor[0] is int
                   && circleColor[1] is int) {
            var m:Matrix = new Matrix();
            m.createGradientBox(1, circleRadius * 2, Math.PI / 2, 0, -circleRadius);
            graphics.beginGradientFill("linear", circleColor, [ 1, 1 ], [ 0, 255 ], m);
        } else {
            graphics.beginFill(0xFF0000);
        }
        graphics.drawCircle(0, 0, circleRadius);

        eraserR = new Shape();
        eraserR.graphics.beginFill(0);
        eraserR.graphics.drawRect( -circleRadius - 1, -circleRadius - 1, circleRadius + 1, circleRadius + 1 << 1);
        eraserR.blendMode = BlendMode.ERASE;
        addChild(eraserR);

        var maskR:Shape = new Shape();
        maskR.graphics.beginFill(0);
        maskR.graphics.drawRect(0, -circleRadius - 1, circleRadius + 1, circleRadius + 1 << 1);
        eraserR.mask = maskR;
        addChild(maskR);

        eraserL = new Shape();
        eraserL.graphics.beginFill(0);
        eraserL.graphics.drawRect(0, -circleRadius - 1, circleRadius + 1, circleRadius + 1 << 1);
        eraserL.blendMode = BlendMode.ERASE;
        addChild(eraserL);

        var maskL:Shape = new Shape();
        maskL.graphics.beginFill(0);
        maskL.graphics.drawRect( -circleRadius - 1, -circleRadius - 1, circleRadius + 1, circleRadius + 1 << 1);
        eraserL.mask = maskL;
        addChild(maskL);

        hole = new Shape();
        hole.graphics.beginFill(0);
        hole.graphics.drawCircle(0, 0, holeRadius);
        hole.blendMode = BlendMode.ERASE;
        addChild(hole);

        if (cutLines > 0) {
            hole.graphics.endFill();
            hole.graphics.lineStyle(lineThickness);
            var pi2:Number    = Math.PI * 2;
            var halfPi:Number = Math.PI / 2;
            for (var i:int = 0; i < cutLines; i++) {
                hole.graphics.moveTo(0, 0);
                hole.graphics.lineTo((circleRadius + 1) * Math.cos(pi2 * i / cutLines - halfPi),
                                     (circleRadius + 1) * Math.sin(pi2 * i / cutLines - halfPi));
            }
        }
        l = cutLines;

        c = cycle > 0 ? cycle : 2000;
        h = c >> 1;
        q = c >> 2;

        isStopped = true;
        isPaused  = false;
    }

    public function get cycle():int { return c; }
    public function set cycle(val:int):void
    {
        if (val > 0) {
            bt += et * (1 - val / c);
            et *= val / c;
            c   = val;
            h   = c >> 1;
            q   = c >> 2;
        }
    }

    public function start():void
    {
        if (isStopped) {
            isStopped = false;
            bt = getTimer();
            et = 0;
            addEventListener(Event.ENTER_FRAME, update);
            if (l > 0) addEventListener(Event.ENTER_FRAME, updateLine);
        } else if (isPaused) {
            isPaused = false;
            bt = getTimer() - et;
            addEventListener(Event.ENTER_FRAME, update);
        }
    }

    public function pause():void
    {
        removeEventListener(Event.ENTER_FRAME, update);
        isPaused = true;
    }

    public function stop():void
    {
        removeEventListener(Event.ENTER_FRAME, update);
        removeEventListener(Event.ENTER_FRAME, updateLine);
        eraserR.rotation = eraserL.rotation = hole.rotation = 0;
        isStopped = true;
        isPaused = false;
    }

    private function update(e:Event):void
    {
        if (et < h) {
            if (et < q) {
                eraserR.rotation = 180 * et / q;
                eraserL.rotation = 0;
            } else {
                eraserL.rotation = 180 * (et / q - 1);
                eraserR.rotation = 180;
            }
        } else {
            if (et < q * 3) {
                eraserR.rotation = 180 * (3 + et / q);
                eraserL.rotation = 180;
            } else {
                eraserL.rotation = 180 * (4 + et / q);
                eraserR.rotation = 0;
            }
        }

        et = getTimer() - bt;
        if (et > c) {
            bt = getTimer();
            et %= c;
        }
    }

    private function updateLine(e:Event):void { hole.rotation += 2; }
}