/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/agpu
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.*;
  public class ch39ex2 extends Sprite {
    protected var perspective:PerspectiveProjection;
    protected var viewMatrix:Matrix3D;
    protected var modelMatrix:Matrix3D;
    protected var model:Plot3D;

    protected var projectedPoints:Vector.<Number> = new Vector.<Number>();
    protected var texturePoints:Vector.<Number> = new Vector.<Number>();
    protected var drawCommands:Vector.<int>;
    public function ch39ex2() {
      stage.quality = StageQuality.MEDIUM;
      this.x = stage.stageWidth/2;
      this.y = stage.stageHeight/2;
      perspective = new PerspectiveProjection();
      perspective.fieldOfView = 50;
      perspective.projectionCenter = new Point(0, 0);
      viewMatrix = new Matrix3D();
      viewMatrix.appendTranslation(0, 4, 11);
      viewMatrix.appendRotation(26, Vector3D.X_AXIS);
      viewMatrix.append(perspective.toMatrix3D());
      modelMatrix = new Matrix3D();
      model = new Plot3D();
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      model.tOffset-=0.3;
      model.plot(new Rectangle(-3, -3, 6, 6), 41);
      modelMatrix.appendRotation(0.5, Vector3D.Y_AXIS);
      var concatenatedMatrix:Matrix3D = modelMatrix.clone();
      concatenatedMatrix.append(viewMatrix);
      Utils3D.projectVectors(concatenatedMatrix, model.vertices, projectedPoints, texturePoints);
      graphics.clear();
      graphics.lineStyle(0, 1);
      if (!drawCommands) {
        drawCommands = new Vector.<int>();
        for (var i:int = 0; i < projectedPoints.length / 2; i++) {
          drawCommands.push((i % model.resolution == 0)? GraphicsPathCommand.MOVE_TO : GraphicsPathCommand.LINE_TO);
        }
      }
      graphics.drawPath(drawCommands, projectedPoints);
    }
  }
}
import flash.geom.Rectangle;
import flash.geom.Vector3D;
class Plot3D {
  public var vertices:Vector.<Number>;
  public var tOffset:Number = 0;
  public var resolution:Number;
  public function plot(xzBounds:Rectangle, resolution:Number = 200):void {
    vertices = new Vector.<Number>();
    this.resolution = resolution;
    var r:Rectangle = xzBounds;
    for (var z:Number = r.top; z < r.bottom; z += r.height/resolution) {
      for (var x:Number = r.left; x < r.right; x += r.width/resolution) {
        var y:Number = Math.sin(Math.pow(x, 2) + Math.pow(z, 2) + tOffset);
        vertices.push(x, y, z);
      } 
    }
  }
}