/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/afLC
 */




package {
    import flash.filters.GlowFilter;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=40)]
    
    public class Liquid extends Sprite {
        private const NUM_PARTICLES:uint = 2000;
        private var particles:Vector.<Particle> = new Vector.<Particle>(NUM_PARTICLES, true);
        private var screen:BitmapData;
        private var densityMap:BitmapData;
        private var timer:Timer;
        private var seed:Number = Math.floor(Math.random() * 0xFFFFFF);
        private var offset:Array = [new Point(), new Point()];
        private var colotTrans:ColorTransform = new ColorTransform(0.8, 0.8, 0.8);
        private var blurr:BlurFilter = new BlurFilter( 6, 6, 3 );
        private var gloww:GlowFilter = new GlowFilter( 0xffffffff*Math.random(), 1.0, 3, 3, 3, 3 );    

                
        public function Liquid() {
            for (var i:uint=0; i<NUM_PARTICLES; i++) {
                particles[i] = new Particle(Math.random() * 465, Math.random() * 465);
            }
            densityMap = new BitmapData(233, 233, false, 0xFF);
            screen = new BitmapData(465, 465, false, 0xffffffff);
            addChild(new Bitmap(screen));
            addEventListener(Event.ENTER_FRAME, loop);
            timer = new Timer(100, 0);
            timer.addEventListener(TimerEvent.TIMER, reset);
            timer.start();
            reset();
        }
        private function loop(event:Event):void {
            screen.lock();
//            screen.colorTransform(screen.rect, colotTrans);
            screen.colorTransform(screen.rect, colotTrans);
            for each (var p:Particle in particles) {
                var c:uint = densityMap.getPixel(p.px >> 1, p.py >> 1);
                p.px += p.vx += p.ax += ((0xFF & c     ) - 0x80) * 0.0005;
                p.py += p.vy += p.ay += ((0xFF & c >> 8) - 0x80) * 0.0005;
                p.ax *= 0.96; p.ay *= 0.96;
                p.vx *= 0.92; p.vy *= 0.92;
                screen.setPixel(
                    p.px = ((p.px > 464) ? 0 : (p.px < 0) ? 464 : p.px),
                    p.py = ((p.py > 464) ? 0 : (p.py < 0) ? 464 : p.py),
                    0xFFFFFF);
                this.filters = [blurr];
                screen.scroll(.9,.9);
               // this.filters = [gloww];

            }
            screen.unlock();
        }
        private function reset(event:Event=null):void {
            densityMap.perlinNoise(117, 117, 2, seed, false, true, 6, false, offset);
            offset[0].x += 1.5;
            offset[1].y += 1.5;
            colotTrans.redMultiplier  = Math.cos(timer.currentCount * 0.0131) * 0.2 + 0.7;
            colotTrans.blueMultiplier = Math.sin(timer.currentCount * 0.0572) * 0.2 + 0.7;
        }
    }
}
 
class Particle {
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var px:Number;
    public var py:Number;
    public function Particle(px:Number, py:Number) {
        this.px = px;
        this.py = py;
    }
}

