/**
 * Copyright takashi08 ( http://wonderfl.net/user/takashi08 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/afHu
 */

// forked from takashi08's flash on 2010-12-23
package {
    import flash.display.*;
    import flash.events.*;
    
     import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.*;
    import org.libspark.betweenas3.easing.*;
    
    //カメラ
    
    public class PV3D extends Sprite{
        
        private var camera:Camera3D;
        private var scene:Scene3D;
        private var viewport  :Viewport3D;
        private var renderer  :BasicRenderEngine;
        
        //camera orbit
        private var isDragging:Boolean;
        private var mouseDownX:Number;
        private var mouseDownY:Number;
        private var cameraPitch:Number;
        private var cameraYaw:Number;
        
        
        private var cube:Cube;
        private var cube2:Cube;
        
        public function PV3D():void{
            //カメラ
            camera = new Camera3D();
            camera.x = 0;
            camera.y = 0;
            camera.z = -2000;
            //シーン／ビューボート／レンダラーを作成
            scene = new Scene3D();
            viewport = new Viewport3D( stage.stageWidth, stage.stageHeight, false, true );
            renderer = new BasicRenderEngine();
            addChild(viewport);
         
         //お好みでライトも()
         var light:PointLight3D = new PointLight3D(false);
         light.x = 0;
         light.y = 0;
         light.z = -1000;
         //フラットシェードマテリアル:HIKISUU light,lightColor,ambientColor,specularLevel    
         var material :FlatShadeMaterial = new FlatShadeMaterial(light, 0xD7261C );
         material.interactive = true;
         
         var materials :MaterialsList = new MaterialsList( { all : material } );
         cube = new Cube( materials );
         cube.x = 0;
         cube.y = 0;
         cube.z = 0;
         //２こめのキューブ
         cube2 = new Cube( materials );
         cube2.x = 550;
         cube2.y = 550;
         cube2.z = 550;
         
         //マウスイベントはInteractiveScene3DEventをつかう
         //cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK,cubeClickHandler);
         //シーンにcubeをaddChild
         scene.addChild(cube);
         //２こめのキューブを設置
         scene.addChild(cube2);
         
         
         addEventListener( Event.ENTER_FRAME, onEnterFrame );
         
         //camera orbit 
         stage.addEventListener(MouseEvent.MOUSE_DOWN,onDownHandler);
         stage.addEventListener(MouseEvent.MOUSE_UP,onUpHandler);
         stage.addEventListener(MouseEvent.MOUSE_MOVE,onMoveHandler);
  
        }
        
        private function onDownHandler(event:MouseEvent):void{
            //camera.target = cube2;//カメラの対象を変更
            var blurtween:ITween;
            //blurtween = BetweenAS3.tween(cube, { _blurFilter:{blurX:30, blurY:30}, alpha:0.0 }, null, 1.0);
            //blurtween = BetweenAS3.tween(cube, { x:1000}, null, 1.0);
            //blurtween.play();
            
            //カメラをbetweenでうごかす
            var cameraTween:ITween;
            cameraTween = BetweenAS3.tween(camera,{x:cube.x,y:cube.y + 500,z:cube.z},null,2,Bounce.easeOut);
            cameraTween.play();
        }
        private function onUpHandler(event:MouseEvent):void{
            //camera.target = cube;//カメラの対象を変更
        }
        private function onMoveHandler(event:MouseEvent):void{
            
        }
        
        public function onEnterFrame(e:Event): void {
            //cube.rotationY += ( mouseX - stage.stageWidth /2 ) / 200;
            //cube.rotationX += ( mouseY - stage.stageHeight/2 ) / 200;
            //レンダラーがないと描画されない
            renderer.renderScene( scene, camera, viewport );
        }
        
        
    }

    
}

