/**
 * Copyright Karnix ( http://wonderfl.net/user/Karnix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aebW
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author Karnix Ip
     */
    public class InteractiveTextFieldTest2 extends Sprite
    {
        private var mReal_spt:Sprite = null;
        private var mFake_spt:Sprite = null;
        private var mDisplay_spt:Sprite = null;
        private var mReal_txt:TextField = null;
        private var mFake_bmp:Bitmap = null;
        private var mFake_bmd:BitmapData = null;
        private var mFrameRate_int:int = 0;
        private var mFontSize_int:int = 0;
        private var mQuality_int:int = 0;
        private var mPixelUnit_num:Number = NaN;
        private var mCurveRaduis_num:Number = NaN;
        private var mEmbedFont_bol:Boolean = false;
        private var mDefaultFont_str:String = null;
        
        public function InteractiveTextFieldTest2() 
        {
            //CHANGE THE FOLLOWING VALUES TO ADJUST THE TEXT FIELD//
            mFrameRate_int = 30;
            mFontSize_int = 16;
            mQuality_int = 2;
            mPixelUnit_num = 5;
            mCurveRaduis_num = 75;
            mEmbedFont_bol = false;
            mDefaultFont_str = "_sans";
            ////////////////////////////////////////////////////////
            
            this.stage.frameRate = mFrameRate_int;
            
            mReal_spt = new Sprite();
            mFake_spt = new Sprite();
            mDisplay_spt = new Sprite();
            mReal_txt = new TextField();
            mFake_bmp = new Bitmap();
            
            //mReal_txt.antiAliasType = AntiAliasType.ADVANCED;
            mReal_txt.autoSize = TextFieldAutoSize.LEFT;
            //mReal_txt.alwaysShowSelection = true;
            //mReal_txt.background = true;
            //mReal_txt.backgroundColor = 0xffff00;
            //mReal_txt.border = true;
            mReal_txt.selectable = true;
            //mReal_txt.multiline = false;
            mReal_txt.type = TextFieldType.INPUT;
            //mReal_txt.maxChars = 20;
            
            //this.addChild(mFake_spt);
            this.addChild(mDisplay_spt);
            this.addChild(mReal_spt);
            mReal_spt.y = 0;
            mFake_spt.y = 100;
            mDisplay_spt.y = 200;
            mReal_spt.addChild(mReal_txt);
            mFake_spt.addChild(mFake_bmp);
            
            mDisplay_spt.x = 200;
            mDisplay_spt.y = 200;
            
            mReal_txt.text = "Real TextField.";
            
            var textFormat:TextFormat = new TextFormat();
            textFormat.size = mFontSize_int * mQuality_int;
            textFormat.font = mDefaultFont_str;
            if (mEmbedFont_bol)
            {
                mReal_txt.embedFonts = true;
            }
            mReal_txt.setTextFormat(textFormat);
            
            mFake_bmd = new BitmapData(mReal_spt.width + 0, mReal_spt.height + 3, true, 0x00ff0000);
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            this.stage.addChild(new Stats());
            
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, onActivate);
        }
        
        private function onActivate(pEvent:Event):void
        {
            this.stage.removeEventListener(MouseEvent.MOUSE_DOWN, onActivate);
            this.stage.focus = mReal_txt;
        }
        
        private function onEnterFrame(pEvent:Event):void
        {
            var fakeWidth_int:int = Math.ceil(mReal_spt.width / mPixelUnit_num) * mPixelUnit_num;
            var fakeHeight_int:int = Math.ceil(mReal_spt.height);
            
            var vertices:Vector.<Number> = new Vector.<Number>();
            var indices:Vector.<int> = new Vector.<int>();
            var uvtData:Vector.<Number> = new Vector.<Number>();
            
            var unitAngle_num:Number = mPixelUnit_num / mCurveRaduis_num;
            
            var segments_int:int = 0;
            
            var i:int = 0;
            var realX_int:int = 0;
            var posX_num:Number = NaN;
            var posY_num:Number = NaN;
            
            var mouseX_num:Number = mDisplay_spt.mouseX;
            var mouseY_num:Number = mDisplay_spt.mouseY;
            var mirrorX_num:Number = ((Math.atan2(mouseY_num, mouseX_num) * 180 / Math.PI) + 90 + 360) % 360;
            var mirrorY_num:Number = (Math.sqrt((mouseX_num * mouseX_num) + (mouseY_num * mouseY_num)) / mQuality_int) - mCurveRaduis_num - (fakeHeight_int / mQuality_int);
            
            var offsetX_num:Number = (mirrorX_num / 360) * (2 * Math.PI * mCurveRaduis_num * mQuality_int);
            var offsetY_num:Number = mirrorY_num;
            
            mReal_spt.x = (mDisplay_spt.x + (mouseX_num / mQuality_int)) - offsetX_num;
            mReal_spt.y = (mDisplay_spt.y + (mouseY_num / mQuality_int)) + (offsetY_num * mQuality_int);
            
            mDisplay_spt.scaleX = 1;
            mDisplay_spt.scaleY = 1;
            mReal_txt.alpha = 1;
            
            mFake_bmd.dispose();
            
            mFake_bmd = new BitmapData(fakeWidth_int, fakeHeight_int, true, 0x00ff0000);
            mFake_bmd.draw(mReal_spt, new Matrix(1, 0, 0, 1, 0, 0), null, null, null, true);
            mReal_txt.alpha = 0;
            mFake_bmp.bitmapData = mFake_bmd;
            
            segments_int = mFake_bmd.width / mPixelUnit_num;
            
            while (realX_int <= fakeWidth_int)
            {
                uvtData.push((vertices.length / 4) / segments_int, 1);
                uvtData.push((vertices.length / 4) / segments_int, 0);
                
                posX_num = mCurveRaduis_num * Math.sin((vertices.length / 4) * (unitAngle_num / mQuality_int)) * mQuality_int;
                posY_num = -mCurveRaduis_num * Math.cos((vertices.length / 4) * (unitAngle_num / mQuality_int)) * mQuality_int;
                vertices.push(posX_num, posY_num);
                
                if (vertices.length > 4)
                {
                    indices.push((vertices.length / 2) - 3);
                    indices.push((vertices.length / 2) - 2);
                    indices.push((vertices.length / 2) - 1);
                }
                
                posX_num = (mCurveRaduis_num + (fakeHeight_int / mQuality_int)) * Math.sin(((vertices.length - 2) / 4) * (unitAngle_num / mQuality_int)) * mQuality_int;
                posY_num = -(mCurveRaduis_num + (fakeHeight_int / mQuality_int)) * Math.cos(((vertices.length - 2) / 4) * (unitAngle_num / mQuality_int)) * mQuality_int;
                vertices.push(posX_num, posY_num);
                
                if (vertices.length > 4)
                {
                indices.push((vertices.length / 2) - 3);
                indices.push((vertices.length / 2) - 2);
                indices.push((vertices.length / 2) - 1);
                }
                
                realX_int += mPixelUnit_num;
            }
            
            var graphics:Graphics = mDisplay_spt.graphics;
            graphics.clear();
            graphics.beginBitmapFill(mFake_bmd);
            graphics.drawTriangles(vertices, indices, uvtData);
            graphics.endFill();
            graphics.lineStyle(0, 0x0000ff, 1);
            graphics.drawCircle(0, 0, mCurveRaduis_num * mQuality_int);
            
            mDisplay_spt.scaleX = 1 / mQuality_int;
            mDisplay_spt.scaleY = 1 / mQuality_int;
        }
    }
}