/**
 * Copyright matsu4512 ( http://wonderfl.net/user/matsu4512 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ad59
 */


package
{
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	
	public class Particle_circle extends Sprite
	{
		private const WIDTH:Number = 465;
		private const HEIGH:Number = 465;
		
		private var _particles:Vector.<Particle>;
		private var _canvas:BitmapData;
		private var _glow:BitmapData;
		private var _rect:Rectangle;
		private var cTra:ColorTransform;
		private var timer:Timer;
		
		private var p_vec:Vector.<Particle>;
		
		private var sx:Number;
		private var sy:Number;
		
		
		public function Particle_circle()
		{
			init();
		}
		
		private function init():void
		{
			_particles = new Vector.<Particle>();
			p_vec = new Vector.<Particle>(10);
			var p:Particle;
			for(var i:uint = 0; i < p_vec.length; i++){
				p = new Particle();
				p.x = Math.random()*WIDTH;
				p.y = Math.random()*HEIGH;
				p.vx = -Math.random()*10 - 2;
				p.vy = Math.random()*10 - 5;
				p_vec[i] = p;
				
			}
			_canvas = new BitmapData(WIDTH, HEIGH, false, 0x0);
			addChild(new Bitmap(_canvas)) as Bitmap;
			
			_glow = new BitmapData(WIDTH/4, HEIGH/4, false, 0x0);
			var bm:Bitmap = addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap;
			bm.scaleX = bm.scaleY = 4;
			bm.blendMode = BlendMode.ADD;
			
			_rect = new Rectangle(0, 0, WIDTH, HEIGH);
			cTra = new ColorTransform(0.8, 0.8, 0.9, 1);
			
			this.stage.addEventListener(Event.ENTER_FRAME, enterframeHandler);
			
			timer = new Timer(30);
			timer.addEventListener(TimerEvent.TIMER, resetFunc);
			timer.start();
		}
		
		private function resetFunc(e:TimerEvent):void
		{
			(cTra.redMultiplier > 0.5)? cTra.redMultiplier = 0.0 : cTra.redMultiplier += 0.01;
			
			hanabi();
		}
		
		private function hanabi():void 
		{
			var i:int = 50;
			for(var j:uint = 0; j < p_vec.length; j++){
				sx = p_vec[j].x;
				sy = p_vec[j].y;
				while (i--) createParticle();
				i = 10;
			}
		}
		
		private function createParticle():void {
			var p:Particle = new Particle();
			p.x = sx;
			p.y = sy;
			p.vx = 5*Math.random();
			p.vy = 5*Math.random();
			_particles.push(p);
		}
		
		private function enterframeHandler(e:Event):void
		{
			update();
		}
		
		private function update():void {
			_canvas.lock();
			_canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(2, 2));
			_canvas.colorTransform(_rect, cTra);
			var i:int = _particles.length;
			while (i--) {
				var p:Particle = _particles[i];
				p.vy += 0.1;
				p.x += p.vx;
				p.y += p.vy;
				_canvas.setPixel32(p.x, p.y, p.c);
				if ((p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01)
				{
					this._particles.splice(i, 1);
				}
			}
			_canvas.unlock();
            var mat:Matrix = new Matrix();
            mat.scale(0.25, 0.25);
			_glow.draw(_canvas, mat);
			
			for(i = 0; i < p_vec.length; i++){
				p = p_vec[i];
				p.x += p.vx;
				p.y += p.vy;
				if(p.x < 0)
					p.x = WIDTH;
				else if(p.x > WIDTH)
					p.x = 0;
				if(p.y > HEIGH)
					p.y = 0;
				else if(p.y < 0)
					p.y = HEIGH;
			}
		}
	}
}
	

class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var c:uint;
	
	public function Particle()
	{
		this.x = 0;
		this.y = 0;
		this.vx = 0;
		this.vy = 0;
		this.c = 0xFFFFFFFF;
	}
}
