/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/acxq
 */

// forked from enecre's 牌効率テスト（プロトタイプ）
package {
    import flash.display.*;
    import flash.net.URLRequest;
    import flash.events.*;
    import flash.display.BitmapData;
    import flash.system.LoaderContext;
    import com.bit101.components.PushButton;
    import flash.net.*;
    import flash.text.*;
    import caurina.transitions.Tweener;
    import flash.utils.escapeMultiByte;
    [SWF(width = 465, height = 465, frameRate = 60)]
    public class FlashTest extends Sprite {
        
        private const len_TEHAI:int = 14;
            
            private var _haiga:Vector.<Haiga>;
            private var _timer:CountDown;
            private var tf_Level:TextField;
            private var tf_Score:TextField;
            private var tf_pt:TextField;
            private var congradulations:TextField;
            
            private var normalStart:PushButton;
            private var hardStart:PushButton;
            private var deathStart:PushButton;
            private var tweetButton:PushButton;
            
            private var positions:Vector.<int>;
            private var tehai:Vector.<Hai>;
            private var dora:Hai;
            private var questionList:Vector.<Question>;
            private var currentQuestion:Question;
            
            private var maru:Maru;
            private var batsu:Batsu;
            
            private var currentLevel:int;
            private var currentScore:int;
            private var currentMode:int;
            
        public function FlashTest() {
                //牌の表示位置の初期化
            positions = new Vector.<int>();
            var beginX:int = (465 - len_TEHAI * 31) / 2;
                for (var i:int=0;i<len_TEHAI;i++){
                    positions[i] = beginX + i * 31;
                }
               //牌画読み込み 
             _haiga = new Vector.<Haiga>();
             for(var j:int=0;j<37;j++){
                _haiga[j] = new Haiga(j);
             }
             tehai = new Vector.<Hai>();
             
             //問題集の読み込み
             questionList = new Vector.<Question>();
             var urlLoader:URLLoader = new URLLoader();
             var req:URLRequest = new URLRequest("http://tenhoulab.sakura.ne.jp/uploads/questions.xml");
             urlLoader.addEventListener(Event.COMPLETE,function(e:Event):void{
                 var xml:XML = new XML((e.target as URLLoader).data);
                 for each(var element:Object in xml.question){
                     questionList.push(new Question(element.@tehai,element.@dora,element.@answer));
                 }
             });
             urlLoader.load(req);
             
             //背景
             var bg:Shape = new Shape();
             bg.graphics.beginFill(0xaaaaff);
             bg.graphics.drawRect(0,0,465,465);
             bg.graphics.endFill();
             addChild(bg);
             
             //Rectangle
             var rect1:Sprite= new Sprite();
             var g1:Graphics = rect1.graphics;
             g1.lineStyle(5,0x3737a6);
             g1.beginFill(0xd0d0ff);
             g1.drawRoundRect(0,0,300,100,10);
             rect1.x = 10;
             rect1.y = 10;
             addChild(rect1);
             
             var rect2:Sprite = new Sprite();
             var g2:Graphics = rect2.graphics;
             g2.lineStyle(5,0x3737a6);
             g2.beginFill(0xd0d0ff);
             g2.drawRoundRect(0,0,120,180,10);
             rect2.x = 330;
             rect2.y = 10;
             addChild(rect2);
             
             tweetButton = new PushButton(rect2,10,150,"Tweet",onTweet);
             tweetButton.enabled = false;
             
             var tf2:TextField = new TextField();
             tf2.text = "レベル";
             tf2.x = 25;
             tf2.y = 35;
             rect2.addChild(tf2);
             
             tf_Level = new TextField();
             var fmt_Level:TextFormat = new TextFormat("Times New Roman",50);
             tf_Level.defaultTextFormat = fmt_Level;
             tf_Level.text = "1";
             tf_Level.x = 70;
             tf_Level.y = 5;
             rect2.addChild(tf_Level);

            tf_Score = new TextField();
            var fmt_Score:TextFormat = new TextFormat("TypeWriter",30);
            tf_Score.defaultTextFormat = fmt_Score;
            tf_Score.text = "0 / 5";
            tf_Score.x = 35;
            tf_Score.y = 60;
            tf_Score.autoSize = TextFieldAutoSize.LEFT;
            rect2.addChild(tf_Score)             
             
             tf_pt = new TextField();
             tf_pt.width = 77;
             tf_pt.height = 50;
             tf_pt.x = 16;
             tf_pt.y = 90;
             var fmt_pt:TextFormat = new TextFormat("TypeWriter",50);
             fmt_pt.align = "right";
             tf_pt.defaultTextFormat = fmt_pt;
             tf_pt.text = "0";
             rect2.addChild(tf_pt);
             
             
             //TextFieldの設置
             var tf1:TextField = new TextField();
             var fmt1:TextFormat = new TextFormat("Meiryo",40);
             tf1.defaultTextFormat = fmt1;
             tf1.text = "牌効率テスト";
             tf1.x = 20;
             tf1.y = 25;
             tf1.autoSize = TextFieldAutoSize.LEFT;
             rect1.addChild(tf1);
             var tf3:TextField = new TextField();
             var fmt3:TextFormat = new TextFormat("Meiryo",16);
             tf3.defaultTextFormat = fmt3;
             tf3.text = "ドラ";
             tf3.x = 330;
             tf3.y = 220;
             addChild(tf3);
             
             var tf4:TextField = new TextField();
             tf4.text = "点";
             tf4.x = 95;
             tf4.y = 120;
             rect2.addChild(tf4);
             ////////
             
             //true に設定されている場合、デバイスフォントと埋め込みフォントの両方を含む、すべてのフォントのリストが返されます。
            /*trace("デバイスフォントと埋め込みフォントの両方を含む、すべてのフォントのリスト------------------------------");
            var allFonts:Array = Font.enumerateFonts(true);
            allFonts.sortOn("fontName", Array.CASEINSENSITIVE);
            for(var i:int=0;i<allFonts.length;i++){
                trace(allFonts[i].fontName);
            }*/
          
             //////
             
             //×マーク、○マークの初期化
             batsu = new Batsu();
             batsu.x = 465/2 - batsu.width/2;
             batsu.y = 340;
             batsu.visible = false;
             addChild(batsu);
             
             maru = new Maru();
             maru.x = 465/2 - maru.width/2;
             maru.y = 340;
             maru.visible = false;
             addChild(maru);
             //ボタン配置
             normalStart = new PushButton(this,positions[0],320,"NORMAL",init);
             hardStart = new PushButton(this,positions[0],340,"HARD",init);
             deathStart = new PushButton(this,positions[0],360,"DEATH",init);
             //カウントダウンタイマー設置
             _timer = new CountDown();
             _timer.x = 10;
             _timer.y = 140;
             _timer.addEventListener(CountDown.TIME_UP,onTimer);
             _timer.addEventListener(CountDown.ONESECOND,tweenTehai);
             addChild(_timer);
             //おめでとう！
             congradulations = new TextField();
             var fmt_cong:TextFormat = new TextFormat("Meiryo",40,0xff0000);
             congradulations.defaultTextFormat = fmt_cong;
             congradulations.autoSize = TextFieldAutoSize.LEFT;
             congradulations.text = "クリア！おめでとう！";
             congradulations.x = 465/2 - congradulations.width/2;
             congradulations.y = 465/2 - congradulations.height/2;
        }
        
        private function init(e:Event):void{
                try{removeChild(congradulations);}catch(e:Error){}
                normalStart.enabled = false;
                hardStart.enabled = false;
                deathStart.enabled = false;
                tweetButton.enabled = false;
                batsu.visible = false;
                //モードの設定
                switch(e.currentTarget){
                    case normalStart: currentMode = 0;break;
                    case hardStart: currentMode = 1;break;
                    case deathStart: currentMode = 3;break;
                }
                currentScore = 0;
                tf_Score.text = "0 / 5"
                currentLevel = 1;
                tf_Level.text = "1";
                next(int(Math.random() * questionList.length));
        }
        
         private function next(numQuestion:int):void{
             if(tehai.length)removeAllTehai();
             
             tf_pt.text = String(calculate());
             maru.visible = false;
             maru.alpha = 1.0;
             
             currentQuestion = questionList[numQuestion];
             
             //When level2 #no ripai
             var shuffle:Vector.<int> = ExArray.shuffle(positions);
             
             var length:int = currentQuestion.tehai.length;
             for(var i:int = 0; i < length; i++){
                 tehai[i] = new Hai(_haiga[currentQuestion.tehai[i]]);
                 var target:Hai = tehai[i];
                 if(currentLevel >= 3 && (currentMode&1))target.x = shuffle[i];
                 else target.x = positions[i];
                 target.y = 270;
                 target.addEventListener(MouseEvent.CLICK,onClick);
                 addChild(target);
             }
             
             dora = new Hai(_haiga[currentQuestion.dora]);
             dora.x = 370;
             dora.y = 210;
             dora.removeAllEventListener();
             addChild(dora);
             
             _timer.reset();
             _timer.start();
         }
        
        private function onClick(e:MouseEvent):void{
                _timer.stop();
                var length:int = tehai.length;
               for(var i:int = 0; i < length; i++){
                    tehai[i].removeAllEventListener();
                    tehai[i].removeEventListener(MouseEvent.CLICK,onClick)
                }
                if((e.target as Hai).hai36 == currentQuestion.answer){
                    onCorrect();
                }
                else{
                    onIncorrect();
                }
        }
        
        private function onTimer(e:Event):void{
                var length:int = tehai.length;
               for(var i:int = 0; i < length; i++){
                    tehai[i].removeAllEventListener();
                    tehai[i].removeEventListener(MouseEvent.CLICK,onClick)
                }
                onIncorrect();
        }
        
        private function onCorrect():void{
                maru.visible = true;
                addEventListener(Event.ENTER_FRAME,function(e:Event):void{
                    maru.alpha -= 0.05;
                    if(maru.alpha <= 0){
                        removeEventListener(Event.ENTER_FRAME,arguments.callee);
                        if(!scorePlus()){
                            onClear();
                        }
                        else next(int(Math.random() * questionList.length));
                    }    
                });
        }
        
        private function onIncorrect():void{
                batsu.visible = true;
                tweetButton.enabled = true;
                normalStart.enabled = true;
                hardStart.enabled = true;
                deathStart.enabled = true;
        }
            private function removeAllTehai():void{
                var length:int = tehai.length;
                for(var i:int = 0; i < length; i++){
                    var target:Hai = tehai[i];
                    target.removeEventListener(MouseEvent.CLICK,onClick);
                    removeChild(target);
                    target = null;
                    }
            }
            private function scorePlus():Boolean{
                currentScore++;
                tf_Score.text = String(currentScore) + " / 5";
                if(currentScore == 5){
                    currentLevel++;
                    currentScore = 0;
                    if(currentLevel == 6)return false;
                    tf_Level.text = String(currentLevel);
                    tf_Score.text = "0 / 5";
                    
                }
                return true;
            }
            private function onClear():void{
                tf_pt.text = String(calculate());
                addChild(congradulations);
                normalStart.enabled = true;
                hardStart.enabled = true;
                deathStart.enabled = true;
                tweetButton.enabled = true;
            }
            
            private function tweenTehai(e:Event):void{
                if(currentLevel != 5 || !(currentMode&2))return;
                var length:int = tehai.length;
                for(var i:int = 0; i < length; i++){
                    Tweener.addTween(tehai[i],{x:((stage.width-150) * Math.random() + 50), y:((stage.height-150) * Math.random() + 50), time:0.8});
                }
            }
            
            private function onTweet(e:Event):void{
                var str:String = "あなたの牌効率は" + calculate() + "点です！ http://wonderfl.net/c/acxq/ #hkr_test";
                var r:String = "http://twitter.com/home/?status=" + escapeMultiByte(str);
             navigateToURL(new URLRequest(r), "_blank");
            }
            
            private function calculate():int{
                var l:int= currentLevel;
                var s:int = currentScore;
                var ret:int = 0;
                while(l--){
                    while(s--){
                        ret += 4;
                        if(currentMode&1 && l>=2){
                            ret += 10;
                        }
                        if(currentMode&2 && l>=4){
                            ret+=50;
                        }
                    }
                    s = 5;
                }
                return ret;
            }
    }
}
import flash.display.*;
import flash.net.URLRequest;
import flash.events.Event;
import flash.system.LoaderContext;
class Haiga extends BitmapData{
    private static const haigaName:Vector.<String> = Vector.<String>([
        "0m","1m","2m","3m","4m","5m","6m","7m","8m","9m",
        "0p","1p","2p","3p","4p","5p","6p","7p","8p","9p",
        "0s","1s","2s","3s","4s","5s","6s","7s","8s","9s",
        "1z","2z","3z","4z","5z","6z","7z"
    ]);
    private static const loaderContext:LoaderContext = new LoaderContext(true);
    public var hai36:int;
    public function Haiga(_hai36:int){
        super(31,47);
        hai36 = _hai36;
        var loader:Loader = new Loader();
        var req:URLRequest = new URLRequest("http://www.tenhoulab.sakura.ne.jp/tenhouhaiga/" + haigaName[_hai36] + ".gif");
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoadComplete);
        loader.load(req,loaderContext);
    }
    
    private function onLoadComplete(e:Event):void{
        var target:Loader = (e.target as LoaderInfo).loader;
        draw(target);
    }
}

import flash.display.Bitmap;
import flash.filters.ColorMatrixFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;
import flash.display.Sprite;
import flash.geom.Rectangle;
class Hai extends Sprite{
    public var hai36:int;
    private var bitmap:Bitmap;
    private static const f:ColorMatrixFilter = new ColorMatrixFilter([0.7,0,0,0,0,0,1,0,0,0,0,0,0.7,0,0,0,0,0,1,0]);
    public function Hai(haiga:Haiga){
        bitmap = new Bitmap(haiga as BitmapData);
        addChild(bitmap);
        hai36 = haiga.hai36
        addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
        addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
    }
    private function onMouseOver(e:Event):void{
            this.filters = [f];
    }
    
    private function onMouseOut(e:Event):void{
            this.filters = [];
    }
    
    public function removeAllEventListener():void{
            removeEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
            removeEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
    }
}
import flash.display.Shape;
class Batsu extends Shape{
    public function Batsu(){
        graphics.lineStyle(10,0x0000ff);
        graphics.lineTo(100,100);
        graphics.moveTo(100,0);
        graphics.lineTo(0,100);
    }
}
class Maru extends Shape{
    public function Maru(){
        graphics.lineStyle(10,0xff0000);
        graphics.drawCircle(50,50,50);
    }
}

class Question{
    public var tehai:Vector.<int>;
    public var dora:int;
    public var answer:int;
    public function Question(_tehai:String,_dora:int,_answer:int){
        tehai = Vector.<int>(_tehai.split(","));
        dora = _dora;
        answer = _answer;
    }
}
import flash.events.TimerEvent;
import flash.text.*;
import flash.display.Bitmap;
import flash.utils.Timer;
class CountDown extends Sprite {
        
        public static const TIME_UP:String = "timeUp";
        public static const ONESECOND:String= "onesecond";
        //可変パラメータ
        private const radius:int = 50;
        private const color:int = 0x3737a6;
        private const fontColor:int = 0xffffdd;
        private const timeLimit:int = 5;
        //不可変パラメータ？
        private const numSize:int = 10;
        private const center:int = radius * (1.0 + numSize * 0.01);
        private const format:TextFormat = new TextFormat("Meiryo",radius * 1.5,fontColor);
            
       private var _circles:Vector.<Shape>;
       private var _numbers:Vector.<Bitmap>;
       private var _timer:Timer;
        private var animationStep:int;
        
    public function CountDown(){
        _circles = new Vector.<Shape>(numSize);//0-9
        var tmp:int;
        for(var i:int = 0; i < numSize; i++){
            tmp = radius * (1.00 + 0.01*i)
            _circles[i] = Circle(tmp,color);
            if(i != 0)_circles[i].visible = false;
        }
        animationStep = 0;
            
        var tf:TextField = new TextField();
        tf.defaultTextFormat = format;
        tf.autoSize = TextFieldAutoSize.LEFT;
        _numbers = new Vector.<Bitmap>();
        for(var j:int = 0; j <= timeLimit ; j++){
                tf.text = String(j);
             var bmpdata:BitmapData = new BitmapData(tf.width,tf.textHeight,true,0);
                bmpdata.draw(tf);
                _numbers[j] = new Bitmap(bmpdata);
                _numbers[j].x = center - _numbers[j].width/2;
                _numbers[j].y = center - _numbers[j].height/2;
                addChild(_numbers[j]);
                _numbers[j].visible = false;
        }
        _numbers[timeLimit].visible = true;
            
        _timer = new Timer(1000,5);
        _timer.addEventListener(TimerEvent.TIMER,onTimer);
        _timer.addEventListener(TimerEvent.TIMER_COMPLETE,onTimerComplete);
        }
    private function onTimer(e:TimerEvent):void{
            dispatchEvent(new Event("onesecond"));
        if(!_timer.hasEventListener(Event.ENTER_FRAME)){
             addEventListener(Event.ENTER_FRAME,onEnterFrame);
                var timeLeft:int = timeLimit - _timer.currentCount;
                _numbers[timeLeft + 1].visible = false;
                _numbers[timeLeft].visible = true;
        }
    }
        
    private function onTimerComplete(e:TimerEvent):void{
            dispatchEvent(new Event("timeUp"));
    }
        
    public function start(e:Event=null):void{
            if(_timer.currentCount != timeLimit)_timer.start();
    }
        
    public function reset(e:Event=null):void{
            _timer.reset();
            for(var i:int = 0; i< timeLimit; i++){
                _numbers[i].visible = false;
            }
            _numbers[timeLimit].visible = true;
    }
        
    public function stop(e:Event=null):void{
            _timer.stop();
    }
        
    private function onEnterFrame(e:Event):void{
            if(animationStep != numSize){
                if(animationStep == 0){
                    _circles[0].visible = false;
                    _circles[numSize - 1].visible = true;
                }
                else{
                    _circles[numSize - animationStep].visible = false;
                    _circles[numSize - animationStep - 1].visible = true;
                }
                animationStep++;
          }
            else{
                removeEventListener(Event.ENTER_FRAME,onEnterFrame);
                animationStep = 0;
            }
    }
        
    private function Circle(rad:int,color:int):Shape{
            var sp:Shape = new Shape();
            sp.graphics.beginFill(color);
            sp.graphics.drawCircle(center,center,rad);
            sp.graphics.endFill();
            addChild(sp);
            return sp;    
    }
}
class ExArray {
    static public function shuffle(arr:Vector.<int>):Vector.<int>{
        var l:int = arr.length;
        var newArr:Vector.<int> = arr.concat();
        while(l){
            var m:int = Math.floor(Math.random()*l);
            var n:int = newArr[--l];
            newArr[l] = newArr[m];
            newArr[m] = n;
            
        }
        return newArr;
    }
}