/**
 * Copyright H.S ( http://wonderfl.net/user/H.S )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/acM8
 */

// forked from dannnn's flash on 2016-6-25
package {
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    public class FlashTest extends Sprite {
        public var waku:Sprite;
        public var waku2:Sprite;
        public var slider:Sprite;
        public var rad:Number = -90 * Math.PI / 180;
        public var dragFlag:Boolean = false;
        public var gap:Number;
        public var loader:Loader;

        public function FlashTest() {
            // write as3 code here..
            
            waku = new Sprite();
                waku.graphics.beginFill(0x000000, 0.1);
                waku.graphics.lineStyle(2, 0x000000, 0.5);
                waku.graphics.moveTo(210, 10);
                for(var i:Number = 0; i<=Math.PI; i=i+Math.PI/60){
                    waku.graphics.lineTo(200*Math.sin(i)+210, 200*Math.cos(i)+210);
                }
                waku.graphics.endFill();
                addChild(waku);
            
                
            waku2 = new Sprite();
                waku2.graphics.beginFill(0x000000, 0.1);
                waku2.graphics.lineStyle(2, 0x000000, 0.5);
                waku2.graphics.moveTo(210, 20);
                for(i = 0; i<=Math.PI; i=i+Math.PI/60){
                    waku2.graphics.lineTo(180*Math.sin(i)+210, 180*Math.cos(i)+210);
                }
                waku2.graphics.endFill();
                addChild(waku2);
            
            loader = new Loader();
            loader.load(new URLRequest("http://chococornet.sakura.ne.jp/img/watermelon.png"), new LoaderContext(true));
            addChild(loader);
            loader.x = 209;
            loader.y = 9;
            loader.alpha = 0;

            slider = new Sprite();
                drawSlider();
                slider.buttonMode = true;
                addChild(slider);
                
                slider.addEventListener(MouseEvent.MOUSE_DOWN, onStartDrag);
                stage.addEventListener(MouseEvent.MOUSE_UP, onStopDrag);
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        protected function onStartDrag(e:Event):void {
            dragFlag = true;
            gap = rad - Math.atan2(mouseY - 210, mouseX - 210);
        }
        
        protected function onStopDrag(e:MouseEvent):void {
            dragFlag = false;
        }
        
        public function onEnterFrame(e:Event):void {
            var mouseRad:Number = Math.atan2(mouseY - 210, mouseX - 210);
            if (dragFlag) {
                rad = mouseRad + gap;
                if (rad < -90 * Math.PI / 180) {
                    rad = -90 * Math.PI / 180;
                }
                if (rad > 81 * Math.PI / 180) {
                    rad = 81 * Math.PI / 180;
                }
                drawSlider();
                loader.alpha = (rad / Math.PI * 180 + 90) / 171;
                slider.alpha = 1 - loader.alpha;
            }
        }
        
        public function drawSlider():void {
            slider.graphics.clear();
            slider.graphics.beginFill(0x0000FF, 0.5);
            slider.graphics.lineStyle(2, 0x0000FF, 0.5);
            for (var j:int = 0; j < 8; j++) {
                var r:Number;
                var rad2:Number;
                if (j < 4) {
                    r = 200;
                    rad2 = rad + 3 * j * Math.PI / 180;
                }
                else {
                    r = 180;
                    rad2 = rad + 3 * (7 - j) * Math.PI / 180;
                }
                var x:Number = r * Math.cos(rad2) + 210;
                var y:Number = r * Math.sin(rad2) + 210;
                if (j == 0) {
                    slider.graphics.moveTo(x, y);
                }
                else {
                    slider.graphics.lineTo(x, y);
                }
            }
            slider.graphics.endFill();
        }
    }
}